package drr.regulation.common.trade.party.functions;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.base.staticdata.party.RelatedParty;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.functions.ExtractPartyFromRelatedPartyByRole;
import drr.regulation.common.functions.PartyLei;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ExecutionAgentCounterparty2_Common.ExecutionAgentCounterparty2_CommonDefault.class)
public abstract class ExecutionAgentCounterparty2_Common implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractPartyFromRelatedPartyByRole extractPartyFromRelatedPartyByRole;
	@Inject protected PartyLei partyLei;

	/**
	* @param partyInfo 
	* @param reportingParty 
	* @param counterparty 
	* @return agent 
	*/
	public String evaluate(PartyInformation partyInfo, Party reportingParty, Party counterparty) {
		String agent = doEvaluate(partyInfo, reportingParty, counterparty);
		
		return agent;
	}

	protected abstract String doEvaluate(PartyInformation partyInfo, Party reportingParty, Party counterparty);

	public static class ExecutionAgentCounterparty2_CommonDefault extends ExecutionAgentCounterparty2_Common {
		@Override
		protected String doEvaluate(PartyInformation partyInfo, Party reportingParty, Party counterparty) {
			String agent = null;
			return assignOutput(agent, partyInfo, reportingParty, counterparty);
		}
		
		protected String assignOutput(String agent, PartyInformation partyInfo, Party reportingParty, Party counterparty) {
			final MapperS<PartyInformation> thenArg0 = MapperS.of(partyInfo)
				.filterSingleNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()), MapperS.of(counterparty), CardinalityOperator.All).get());
			final MapperS<PartyInformation> thenArg1 = MapperS.of(distinct(thenArg0).get());
			final MapperS<Party> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(extractPartyFromRelatedPartyByRole.evaluate(item.<RelatedParty>mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.EXECUTION_AGENT)));
			agent = thenArg2
				.mapSingleToItem(item -> MapperS.of(partyLei.evaluate(item.<PartyIdentifier>mapC("getPartyId", party -> party.getPartyId()).getMulti()))).get();
			
			return agent;
		}
	}
}
