package drr.regulation.common.trade.underlier.reports;

import cdm.base.datetime.Period;
import cdm.base.datetime.PeriodEnum;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FloatingReferencePeriod;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsFRA;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.common.functions.RateOption;
import drr.standards.iso.FrequencyPeriodEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FloatingRateReferencePeriodLeg2Rule.FloatingRateReferencePeriodLeg2RuleDefault.class)
public abstract class FloatingRateReferencePeriodLeg2Rule implements ReportFunction<TransactionReportInstruction, FrequencyPeriodEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FloatingReferencePeriod floatingReferencePeriod;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsFRA isFRA;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;
	@Inject protected RateOption rateOption;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public FrequencyPeriodEnum evaluate(TransactionReportInstruction input) {
		FrequencyPeriodEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract FrequencyPeriodEnum doEvaluate(TransactionReportInstruction input);

	public static class FloatingRateReferencePeriodLeg2RuleDefault extends FloatingRateReferencePeriodLeg2Rule {
		@Override
		protected FrequencyPeriodEnum doEvaluate(TransactionReportInstruction input) {
			FrequencyPeriodEnum output = null;
			return assignOutput(output, input);
		}
		
		protected FrequencyPeriodEnum assignOutput(FrequencyPeriodEnum output, TransactionReportInstruction input) {
			final MapperS<Product> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> areEqual(MapperS.of(isFRA.evaluate(item.get())), MapperS.of(false), CardinalityOperator.All).get());
			final MapperS<Product> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg3 = thenArg2
				.mapSingleToItem(item -> MapperS.of(interestRateLeg2.evaluate(item.get())));
			final MapperS<PeriodEnum> thenArg4 = thenArg3
				.mapSingleToItem(item -> MapperS.of(rateOption.evaluate(item.get())).<Period>map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).<PeriodEnum>map("getPeriod", period -> period.getPeriod()));
			output = thenArg4
				.mapSingleToItem(item -> MapperS.of(floatingReferencePeriod.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
