package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.MandatorilyClearableEnum;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.19.3
 */
@RosettaDataRule("ReportableInformationMandatorilyClearableConditionCFTC")
@ImplementedBy(ReportableInformationMandatorilyClearableConditionCFTC.Default.class)
public interface ReportableInformationMandatorilyClearableConditionCFTC extends Validator<ReportableInformation> {
	
	String NAME = "ReportableInformationMandatorilyClearableConditionCFTC";
	String DEFINITION = "partyInformation -> regimeInformation then filter supervisoryBody = SupervisoryBodyEnum -> CFTC then if mandatorilyClearable exists then mandatorilyClearable distinct count = 1";
	
	class Default implements ReportableInformationMandatorilyClearableConditionCFTC {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportableInformation reportableInformation) {
			ComparisonResult result = executeDataRule(reportableInformation);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ReportableInformation", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ReportableInformation", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ReportableInformation reportableInformation) {
			try {
				final MapperC<ReportingRegime> thenArg0 = MapperS.of(reportableInformation).<PartyInformation>mapC("getPartyInformation", _reportableInformation -> _reportableInformation.getPartyInformation()).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation());
				final MapperC<ReportingRegime> thenArg1 = thenArg0
					.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.All).get());
				final MapperS<Boolean> ifThenElseResult;
				if (exists(thenArg1.<MandatorilyClearableEnum>map("getMandatorilyClearable", reportingRegime -> reportingRegime.getMandatorilyClearable())).getOrDefault(false)) {
					ifThenElseResult = areEqual(MapperS.of(distinct(thenArg1.<MandatorilyClearableEnum>map("getMandatorilyClearable", reportingRegime -> reportingRegime.getMandatorilyClearable())).resultCount()), MapperS.of(1), CardinalityOperator.All).asMapper();
				} else {
					ifThenElseResult = MapperS.<Boolean>ofNull();
				}
				return ComparisonResult.of(ifThenElseResult);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ReportableInformationMandatorilyClearableConditionCFTC {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportableInformation reportableInformation) {
			return Collections.emptyList();
		}
	}
}
