package drr.regulation.csa.rewrite.trade.reports;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.standards.iosco.cde.version3.payment.reports.PeriodicPaymentRule;
import drr.standards.iso.InterestComputationMethod4Code;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FloatingRateDayCountConventionLeg1Rule.FloatingRateDayCountConventionLeg1RuleDefault.class)
public abstract class FloatingRateDayCountConventionLeg1Rule implements ReportFunction<TransactionReportInstruction, InterestComputationMethod4Code> {
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCSAAlignedRule isCSAAlignedRule;
	@Inject protected PeriodicPaymentRule periodicPaymentRule;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public InterestComputationMethod4Code evaluate(TransactionReportInstruction input) {
		InterestComputationMethod4Code output = doEvaluate(input);
		
		return output;
	}

	protected abstract InterestComputationMethod4Code doEvaluate(TransactionReportInstruction input);

	public static class FloatingRateDayCountConventionLeg1RuleDefault extends FloatingRateDayCountConventionLeg1Rule {
		@Override
		protected InterestComputationMethod4Code doEvaluate(TransactionReportInstruction input) {
			InterestComputationMethod4Code output = null;
			return assignOutput(output, input);
		}
		
		protected InterestComputationMethod4Code assignOutput(InterestComputationMethod4Code output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final MapperS<InterestRatePayout> ifThenElseResult;
			if (areEqual(MapperS.of(isCSAAlignedRule.evaluate(thenArg.get())), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(interestRateLeg1.evaluate(productOrUnderlierProduct.evaluate(productForEvent.evaluate(thenArg.get()))));
			} else {
				ifThenElseResult = MapperS.of(interestRateLeg2.evaluate(productOrUnderlierProduct.evaluate(productForEvent.evaluate(thenArg.get()))));
			}
			output = MapperS.of(periodicPaymentRule.evaluate(ifThenElseResult.get())).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", periodicPayment -> periodicPayment.getFloatingRateDayCountConvention()).get();
			
			return output;
		}
	}
}
