package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg1;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg2;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.standards.iso.FrequencyPeriodEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(QuantityFrequencyLeg1Rule.QuantityFrequencyLeg1RuleDefault.class)
public abstract class QuantityFrequencyLeg1Rule implements ReportFunction<TransactionReportInstruction, FrequencyPeriodEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsCSAAlignedRule isCSAAlignedRule;
	@Inject protected QuantityFrequencyLeg1 quantityFrequencyLeg1;
	@Inject protected QuantityFrequencyLeg2 quantityFrequencyLeg2;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public FrequencyPeriodEnum evaluate(TransactionReportInstruction input) {
		FrequencyPeriodEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract FrequencyPeriodEnum doEvaluate(TransactionReportInstruction input);

	public static class QuantityFrequencyLeg1RuleDefault extends QuantityFrequencyLeg1Rule {
		@Override
		protected FrequencyPeriodEnum doEvaluate(TransactionReportInstruction input) {
			FrequencyPeriodEnum output = null;
			return assignOutput(output, input);
		}
		
		protected FrequencyPeriodEnum assignOutput(FrequencyPeriodEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final MapperS<FrequencyPeriodEnum> ifThenElseResult;
			if (areEqual(MapperS.of(isCSAAlignedRule.evaluate(thenArg.get())), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(quantityFrequencyLeg1.evaluate(thenArg.get())).<FrequencyPeriodEnum>map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod());
			} else {
				ifThenElseResult = MapperS.of(quantityFrequencyLeg2.evaluate(thenArg.get())).<FrequencyPeriodEnum>map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod());
			}
			output = ifThenElseResult.get();
			
			return output;
		}
	}
}
