package drr.regulation.csa.rewrite.trade.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.PartyLeiAndPersonByRoles;
import drr.standards.iosco.cde.version3.party.reports.Direction2ReceiverPartyLeg1Rule;
import drr.standards.iosco.cde.version3.party.reports.Direction2ReceiverPartyLeg2Rule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ReceiverIdentifierLeg2Rule.ReceiverIdentifierLeg2RuleDefault.class)
public abstract class ReceiverIdentifierLeg2Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Direction2ReceiverPartyLeg1Rule direction2ReceiverPartyLeg1Rule;
	@Inject protected Direction2ReceiverPartyLeg2Rule direction2ReceiverPartyLeg2Rule;
	@Inject protected IsCSAAlignedRule isCSAAlignedRule;
	@Inject protected PartyLeiAndPersonByRoles partyLeiAndPersonByRoles;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class ReceiverIdentifierLeg2RuleDefault extends ReceiverIdentifierLeg2Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			if (areEqual(MapperS.of(isCSAAlignedRule.evaluate(input)), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
				final ReferenceWithMetaParty referenceWithMetaParty0 = MapperS.of(input).<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).get();
				output = partyLeiAndPersonByRoles.evaluate(direction2ReceiverPartyLeg2Rule.evaluate(input), (referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()));
			} else {
				final ReferenceWithMetaParty referenceWithMetaParty1 = MapperS.of(input).<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).get();
				output = partyLeiAndPersonByRoles.evaluate(direction2ReceiverPartyLeg1Rule.evaluate(input), (referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()));
			}
			
			return output;
		}
	}
}
