package drr.regulation.csa.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.cde.base.basket.BasketConstituentsReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.19.3
 */
@RosettaDataRule("CSATransactionReportCSA_VR_0127_01")
@ImplementedBy(CSATransactionReportCSA_VR_0127_01.Default.class)
public interface CSATransactionReportCSA_VR_0127_01 extends Validator<CSATransactionReport> {
	
	String NAME = "CSATransactionReportCSA_VR_0127_01";
	String DEFINITION = "if dtccAdditionalFields -> messageTypeTransaction exists then (if basketConstituents -> identifier exists then basketConstituents -> unitOfMeasure count = basketConstituents -> numberOfUnits count and basketConstituents -> unitOfMeasure count = basketConstituents -> identifier count and basketConstituents -> unitOfMeasure count = basketConstituents -> source count else basketConstituents -> unitOfMeasure is absent)";
	
	class Default implements CSATransactionReportCSA_VR_0127_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
			ComparisonResult result = executeDataRule(cSATransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
			try {
				if (exists(MapperS.of(cSATransactionReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).<String>map("getMessageTypeTransaction", dTCCAdditionalFields -> dTCCAdditionalFields.getMessageTypeTransaction())).getOrDefault(false)) {
					if (exists(MapperS.of(cSATransactionReport).<BasketConstituentsReport>mapC("getBasketConstituents", _cSATransactionReport -> _cSATransactionReport.getBasketConstituents()).<String>map("getIdentifier", basketConstituentsReport -> basketConstituentsReport.getIdentifier())).getOrDefault(false)) {
						return areEqual(MapperS.of(MapperS.of(cSATransactionReport).<BasketConstituentsReport>mapC("getBasketConstituents", _cSATransactionReport -> _cSATransactionReport.getBasketConstituents()).<String>map("getUnitOfMeasure", basketConstituentsReport -> basketConstituentsReport.getUnitOfMeasure()).resultCount()), MapperS.of(MapperS.of(cSATransactionReport).<BasketConstituentsReport>mapC("getBasketConstituents", _cSATransactionReport -> _cSATransactionReport.getBasketConstituents()).<BigDecimal>map("getNumberOfUnits", basketConstituentsReport -> basketConstituentsReport.getNumberOfUnits()).resultCount()), CardinalityOperator.All).and(areEqual(MapperS.of(MapperS.of(cSATransactionReport).<BasketConstituentsReport>mapC("getBasketConstituents", _cSATransactionReport -> _cSATransactionReport.getBasketConstituents()).<String>map("getUnitOfMeasure", basketConstituentsReport -> basketConstituentsReport.getUnitOfMeasure()).resultCount()), MapperS.of(MapperS.of(cSATransactionReport).<BasketConstituentsReport>mapC("getBasketConstituents", _cSATransactionReport -> _cSATransactionReport.getBasketConstituents()).<String>map("getIdentifier", basketConstituentsReport -> basketConstituentsReport.getIdentifier()).resultCount()), CardinalityOperator.All)).and(areEqual(MapperS.of(MapperS.of(cSATransactionReport).<BasketConstituentsReport>mapC("getBasketConstituents", _cSATransactionReport -> _cSATransactionReport.getBasketConstituents()).<String>map("getUnitOfMeasure", basketConstituentsReport -> basketConstituentsReport.getUnitOfMeasure()).resultCount()), MapperS.of(MapperS.of(cSATransactionReport).<BasketConstituentsReport>mapC("getBasketConstituents", _cSATransactionReport -> _cSATransactionReport.getBasketConstituents()).<ProductIdTypeEnum>map("getSource", basketConstituentsReport -> basketConstituentsReport.getSource()).resultCount()), CardinalityOperator.All));
					}
					return notExists(MapperS.of(cSATransactionReport).<BasketConstituentsReport>mapC("getBasketConstituents", _cSATransactionReport -> _cSATransactionReport.getBasketConstituents()).<String>map("getUnitOfMeasure", basketConstituentsReport -> basketConstituentsReport.getUnitOfMeasure()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CSATransactionReportCSA_VR_0127_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
