package drr.regulation.esma.emir.refit.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.CollateralEnrichmentDataRule;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.esma.emir.refit.margin.ESMAEMIRMarginReport;
import drr.regulation.esma.emir.refit.margin.labels.ESMAEMIRMarginLabelProvider;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.esma.emir.refit.margin", body="ESMA", corpusList={"EMIR", "Margin"})
@RuneLabelProvider(labelProvider=ESMAEMIRMarginLabelProvider.class)
@ImplementedBy(ESMAEMIRMarginReportFunction.ESMAEMIRMarginReportFunctionDefault.class)
public abstract class ESMAEMIRMarginReportFunction implements ReportFunction<CollateralReportInstruction, ESMAEMIRMarginReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected CollateralEnrichmentDataRule collateralEnrichmentDataRule;
	@Inject protected CollateralPortfolioCodeRule collateralPortfolioCodeRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected CollateralTimestampRule collateralTimestampRule;
	@Inject protected CollateralisationCategoryRule collateralisationCategoryRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CurrencyOfExcessCollateralCollectedRule currencyOfExcessCollateralCollectedRule;
	@Inject protected CurrencyOfTheExcessCollateralPostedRule currencyOfTheExcessCollateralPostedRule;
	@Inject protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
	@Inject protected EventDateRule eventDateRule;
	@Inject protected ExcessCollateralCollectedByTheCounterparty1Rule excessCollateralCollectedByTheCounterparty1Rule;
	@Inject protected ExcessCollateralPostedByTheCounterparty1Rule excessCollateralPostedByTheCounterparty1Rule;
	@Inject protected InitialMarginCollectedByCounterparty1CurrencyRule initialMarginCollectedByCounterparty1CurrencyRule;
	@Inject protected InitialMarginCollectedByCounterparty1PostHaircutRule initialMarginCollectedByCounterparty1PostHaircutRule;
	@Inject protected InitialMarginCollectedByCounterparty1PreHaircutRule initialMarginCollectedByCounterparty1PreHaircutRule;
	@Inject protected InitialMarginPostedByCounterparty1CurrencyRule initialMarginPostedByCounterparty1CurrencyRule;
	@Inject protected InitialMarginPostedByTheCounterparty1PostHaircutRule initialMarginPostedByTheCounterparty1PostHaircutRule;
	@Inject protected InitialMarginPostedByTheCounterparty1PreHaircutRule initialMarginPostedByTheCounterparty1PreHaircutRule;
	@Inject protected MICCollateralRule mICCollateralRule;
	@Inject protected ReportSubmittingEntityIDRule reportSubmittingEntityIDRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected UTIRule uTIRule;
	@Inject protected VariationMarginCollectedByCounterparty1CurrencyRule variationMarginCollectedByCounterparty1CurrencyRule;
	@Inject protected VariationMarginCollectedByTheCounterparty1PostHaircutRule variationMarginCollectedByTheCounterparty1PostHaircutRule;
	@Inject protected VariationMarginCollectedByTheCounterparty1PreHaircutRule variationMarginCollectedByTheCounterparty1PreHaircutRule;
	@Inject protected VariationMarginPostedByCounterparty1CurrencyRule variationMarginPostedByCounterparty1CurrencyRule;
	@Inject protected VariationMarginPostedByTheCounterparty1PostHaircutRule variationMarginPostedByTheCounterparty1PostHaircutRule;
	@Inject protected VariationMarginPostedByTheCounterparty1PreHaircutRule variationMarginPostedByTheCounterparty1PreHaircutRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ESMAEMIRMarginReport evaluate(CollateralReportInstruction input) {
		ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder outputBuilder = doEvaluate(input);
		
		final ESMAEMIRMarginReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(ESMAEMIRMarginReport.class, output);
		}
		
		return output;
	}

	protected abstract ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder doEvaluate(CollateralReportInstruction input);

	public static class ESMAEMIRMarginReportFunctionDefault extends ESMAEMIRMarginReportFunction {
		@Override
		protected ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder doEvaluate(CollateralReportInstruction input) {
			ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder output = ESMAEMIRMarginReport.builder();
			return assignOutput(output, input);
		}
		
		protected ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder assignOutput(ESMAEMIRMarginReport.ESMAEMIRMarginReportBuilder output, CollateralReportInstruction input) {
			output
				.getOrCreatePartiesToTheDerivative()
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.getOrCreatePartiesToTheDerivative()
				.setReportSubmittingEntityID(reportSubmittingEntityIDRule.evaluate(input));
			
			output
				.getOrCreatePartiesToTheDerivative()
				.setEntityResponsibleForReporting(entityResponsibleForReportingRule.evaluate(input));
			
			output
				.getOrCreatePartiesToTheDerivative()
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.getOrCreatePartiesToTheDerivative()
				.setCounterparty2IdentifierType(counterparty2IdentifierTypeRule.evaluate(input));
			
			output
				.getOrCreatePartiesToTheDerivative()
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.getOrCreatePartiesToTheDerivative()
				.getOrCreateNonReportable()
				.setEnrichment(collateralEnrichmentDataRule.evaluate(input));
			
			output
				.getOrCreatePartiesToTheDerivative()
				.getOrCreateNonReportable()
				.setMic(mICCollateralRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCollateralTimestamp(collateralTimestampRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCollateralPortfolioCode(collateralPortfolioCodeRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setUti(uTIRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCollateralisationCategory(collateralisationCategoryRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setInitialMarginPostedByTheCounterparty1PreHaircut(initialMarginPostedByTheCounterparty1PreHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setInitialMarginPostedByTheCounterparty1PostHaircut(initialMarginPostedByTheCounterparty1PostHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setInitialMarginPostedByCounterparty1Currency(initialMarginPostedByCounterparty1CurrencyRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setVariationMarginPostedByTheCounterparty1PreHaircut(variationMarginPostedByTheCounterparty1PreHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setVariationMarginPostedByTheCounterparty1PostHaircut(variationMarginPostedByTheCounterparty1PostHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setVariationMarginPostedByCounterparty1Currency(variationMarginPostedByCounterparty1CurrencyRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setInitialMarginCollectedByCounterparty1PreHaircut(initialMarginCollectedByCounterparty1PreHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setInitialMarginCollectedByCounterparty1PostHaircut(initialMarginCollectedByCounterparty1PostHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setInitialMarginCollectedByCounterparty1Currency(initialMarginCollectedByCounterparty1CurrencyRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setVariationMarginCollectedByTheCounterparty1PreHaircut(variationMarginCollectedByTheCounterparty1PreHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setVariationMarginCollectedByTheCounterparty1PostHaircut(variationMarginCollectedByTheCounterparty1PostHaircutRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setVariationMarginCollectedByCounterparty1Currency(variationMarginCollectedByCounterparty1CurrencyRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setExcessCollateralPostedByTheCounterparty1(excessCollateralPostedByTheCounterparty1Rule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCurrencyOfTheExcessCollateralPosted(currencyOfTheExcessCollateralPostedRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setExcessCollateralCollectedByTheCounterparty1(excessCollateralCollectedByTheCounterparty1Rule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setCurrencyOfTheExcessCollateralCollected(currencyOfExcessCollateralCollectedRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.getOrCreateCollateral()
				.setEventDate(eventDateRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
