package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.event.position.CounterpartyPosition;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.asset.ForeignExchange;
import cdm.product.common.settlement.Cashflow;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_AssetClass_ForeignExchange;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDS;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Swap;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FXNearLeg;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsProductETD;
import drr.regulation.common.functions.PositionForEvent;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductForPosition;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.base.price.functions.FormatToBaseOne18Rate;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ExchangeRateRule.ExchangeRateRuleDefault.class)
public abstract class ExchangeRateRule implements ReportFunction<ReportableEvent, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FXNearLeg fXNearLeg;
	@Inject protected FormatToBaseOne18Rate formatToBaseOne18Rate;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsProductETD isProductETD;
	@Inject protected PositionForEvent positionForEvent;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductForPosition productForPosition;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_AssetClass_ForeignExchange qualify_AssetClass_ForeignExchange;
	@Inject protected Qualify_ForeignExchange_NDS qualify_ForeignExchange_NDS;
	@Inject protected Qualify_ForeignExchange_Swap qualify_ForeignExchange_Swap;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(ReportableEvent input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(ReportableEvent input);

	public static class ExchangeRateRuleDefault extends ExchangeRateRule {
		@Override
		protected BigDecimal doEvaluate(ReportableEvent input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, ReportableEvent input) {
			final MapperS<ReportableEvent> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					if (exists(MapperS.of(tradeForEvent.evaluate(item.get()))).and(areEqual(MapperS.of(isProductETD.evaluate(productForEvent.evaluate(item.get()))), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
						final MapperS<Trade> thenArg0 = item
							.mapSingleToItem(_item -> MapperS.of(tradeForEvent.evaluate(_item.get())));
						final MapperS<Trade> thenArg1 = thenArg0
							.filterSingleNullSafe(_item -> ComparisonResult.of(MapperS.of(qualify_ForeignExchange_Swap.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(_item.get()))))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_NDS.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(_item.get())))))).get());
						return thenArg1
							.mapSingleToItem(trade -> {
								final MapperC<PriceQuantity> _thenArg0 = thenArg1.<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity())
									.filterItemNullSafe(_item -> areEqual(_item.<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), MapperS.of(fXNearLeg.evaluate(productForTrade.evaluate(trade.get()))).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", product -> product.getForeignExchange()).<Cashflow>map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), CardinalityOperator.Any).and(areEqual(_item.<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), MapperS.of(fXNearLeg.evaluate(productForTrade.evaluate(trade.get()))).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", product -> product.getForeignExchange()).<Cashflow>map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()).<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), CardinalityOperator.Any)).get());
								final MapperListOfLists<FieldWithMetaPriceSchedule> _thenArg1 = _thenArg0
									.mapItemToList(_item -> _item.<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice()));
								final MapperC<FieldWithMetaPriceSchedule> _thenArg2 = _thenArg1
									.flattenList();
								final MapperC<FieldWithMetaPriceSchedule> _thenArg3 = _thenArg2
									.filterItemNullSafe(_item -> areEqual(_item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.EXCHANGE_RATE), CardinalityOperator.All).and(notExists(_item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).<ArithmeticOperationEnum>map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).get());
								final MapperS<FieldWithMetaPriceSchedule> _thenArg4 = MapperS.of(_thenArg3.get());
								return _thenArg4
									.mapSingleToItem(_item -> _item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()));
							});
					}
					if (exists(MapperS.of(positionForEvent.evaluate(item.get()))).getOrDefault(false)) {
						final MapperS<CounterpartyPosition> thenArg2 = item
							.mapSingleToItem(_item -> MapperS.of(positionForEvent.evaluate(_item.get())));
						final MapperS<CounterpartyPosition> thenArg3 = thenArg2
							.filterSingleNullSafe(_item -> ComparisonResult.of(MapperS.of(qualify_ForeignExchange_Swap.evaluate(economicTermsForProduct.evaluate(productForPosition.evaluate(_item.get()))))).or(ComparisonResult.of(MapperS.of(qualify_ForeignExchange_NDS.evaluate(economicTermsForProduct.evaluate(productForPosition.evaluate(_item.get())))))).get());
						return thenArg3
							.mapSingleToItem(counterpartyPosition -> {
								final MapperC<PriceQuantity> _thenArg0 = thenArg3.<TradableProduct>map("getPositionBase", _counterpartyPosition -> _counterpartyPosition.getPositionBase()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity())
									.filterItemNullSafe(_item -> areEqual(_item.<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), MapperS.of(fXNearLeg.evaluate(productForPosition.evaluate(counterpartyPosition.get()))).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", product -> product.getForeignExchange()).<Cashflow>map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), CardinalityOperator.Any).and(areEqual(_item.<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), MapperS.of(fXNearLeg.evaluate(productForPosition.evaluate(counterpartyPosition.get()))).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", product -> product.getForeignExchange()).<Cashflow>map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()).<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), CardinalityOperator.Any)).get());
								final MapperListOfLists<FieldWithMetaPriceSchedule> _thenArg1 = _thenArg0
									.mapItemToList(_item -> _item.<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice()));
								final MapperC<FieldWithMetaPriceSchedule> _thenArg2 = _thenArg1
									.flattenList();
								final MapperC<FieldWithMetaPriceSchedule> _thenArg3 = _thenArg2
									.filterItemNullSafe(_item -> areEqual(_item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.EXCHANGE_RATE), CardinalityOperator.All).and(notExists(_item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).<ArithmeticOperationEnum>map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).get());
								final MapperS<FieldWithMetaPriceSchedule> _thenArg4 = MapperS.of(_thenArg3.get());
								return _thenArg4
									.mapSingleToItem(_item -> _item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()));
							});
					}
					if (exists(MapperS.of(positionForEvent.evaluate(item.get()))).and(ComparisonResult.of(MapperS.of(isProductETD.evaluate(productForEvent.evaluate(item.get()))))).and(ComparisonResult.of(MapperS.of(qualify_AssetClass_ForeignExchange.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get())))))).getOrDefault(false)) {
						final MapperS<CounterpartyPosition> thenArg4 = item
							.mapSingleToItem(_item -> MapperS.of(positionForEvent.evaluate(_item.get())));
						return thenArg4
							.mapSingleToItem(counterpartyPosition -> {
								final MapperC<PriceQuantity> _thenArg0 = thenArg4.<TradableProduct>map("getPositionBase", _counterpartyPosition -> _counterpartyPosition.getPositionBase()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity());
								final MapperListOfLists<FieldWithMetaPriceSchedule> _thenArg1 = _thenArg0
									.mapItemToList(_item -> _item.<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice()));
								final MapperC<FieldWithMetaPriceSchedule> _thenArg2 = _thenArg1
									.flattenList();
								final MapperC<FieldWithMetaPriceSchedule> _thenArg3 = _thenArg2
									.filterItemNullSafe(_item -> areEqual(_item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.EXCHANGE_RATE), CardinalityOperator.All).and(notExists(_item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).<ArithmeticOperationEnum>map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).get());
								final MapperS<FieldWithMetaPriceSchedule> _thenArg4 = MapperS.of(_thenArg3.get());
								return _thenArg4
									.mapSingleToItem(_item -> _item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()));
							});
					}
					if (ComparisonResult.of(MapperS.of(isProductETD.evaluate(productForEvent.evaluate(item.get())))).and(ComparisonResult.of(MapperS.of(qualify_AssetClass_ForeignExchange.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get())))))).getOrDefault(false)) {
						final MapperS<Trade> thenArg5 = item
							.mapSingleToItem(_item -> MapperS.of(tradeForEvent.evaluate(_item.get())));
						final MapperS<BigDecimal> thenArg6 = thenArg5
							.mapSingleToItem(trade -> {
								final MapperC<PriceQuantity> _thenArg0 = thenArg5.<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity());
								final MapperListOfLists<FieldWithMetaPriceSchedule> _thenArg1 = _thenArg0
									.mapItemToList(_item -> _item.<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice()));
								final MapperC<FieldWithMetaPriceSchedule> _thenArg2 = _thenArg1
									.flattenList();
								final MapperC<FieldWithMetaPriceSchedule> _thenArg3 = _thenArg2
									.filterItemNullSafe(_item -> areEqual(_item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule0 -> fieldWithMetaPriceSchedule0 == null ? null : fieldWithMetaPriceSchedule0.getValue()).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.EXCHANGE_RATE), CardinalityOperator.All).and(notExists(_item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule1 -> fieldWithMetaPriceSchedule1 == null ? null : fieldWithMetaPriceSchedule1.getValue()).<ArithmeticOperationEnum>map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).get());
								final MapperS<FieldWithMetaPriceSchedule> _thenArg4 = MapperS.of(_thenArg3.get());
								return _thenArg4
									.mapSingleToItem(_item -> _item.<PriceSchedule>map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()));
							});
						return MapperS.of(formatToBaseOne18Rate.evaluate(thenArg6.get()));
					}
					return MapperS.<BigDecimal>ofNull();
				}).get();
			
			return output;
		}
	}
}
