package drr.regulation.esma.emir.refit.trade.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNameOfTheFloatingRateOfLeg2;
import drr.regulation.common.functions.IsAllowableAction;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg2NotationEnumRule;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg2Rule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SpreadOfLeg2NotationRule.SpreadOfLeg2NotationRuleDefault.class)
public abstract class SpreadOfLeg2NotationRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetNameOfTheFloatingRateOfLeg2 getNameOfTheFloatingRateOfLeg2;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected SpreadLeg2NotationEnumRule spreadLeg2NotationEnumRule;
	@Inject protected SpreadLeg2Rule spreadLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class SpreadOfLeg2NotationRuleDefault extends SpreadOfLeg2NotationRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					final PriceSchedule priceSchedule = spreadLeg2Rule.evaluate(item.get());
					if ((priceSchedule == null ? exists(MapperS.<ReferenceWithMetaPriceSchedule>ofNull()).getOrDefault(false) : exists(MapperS.of(ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build())).getOrDefault(false))) {
						return MapperS.of(spreadLeg2NotationEnumRule.evaluate(item.get()));
					}
					if (exists(MapperS.of(getNameOfTheFloatingRateOfLeg2.evaluate(item.get()))).getOrDefault(false)) {
						return MapperS.of(PriceNotationEnum.BASIS);
					}
					return MapperS.<PriceNotationEnum>ofNull();
				}).get();
			
			return output;
		}
	}
}
