package drr.regulation.fca.ukemir.refit.margin.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.margin.FCAUKEMIRMarginReport;
import drr.regulation.fca.ukemir.refit.margin.FCAUKEMIRNonReportableCollateralData;
import drr.regulation.fca.ukemir.refit.margin.PartiesToTheDerivative;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.19.3
 */
@RosettaDataRule("FCAUKEMIRMarginReportEMIR_VR_3030_01")
@ImplementedBy(FCAUKEMIRMarginReportEMIR_VR_3030_01.Default.class)
public interface FCAUKEMIRMarginReportEMIR_VR_3030_01 extends Validator<FCAUKEMIRMarginReport> {
	
	String NAME = "FCAUKEMIRMarginReportEMIR_VR_3030_01";
	String DEFINITION = "if (partiesToTheDerivative -> executionAgentOfCounterparty1 exists and partiesToTheDerivative -> executionAgentOfCounterparty2 exists) or (partiesToTheDerivative -> executionAgentOfCounterparty1 is absent and partiesToTheDerivative -> executionAgentOfCounterparty2 is absent) then partiesToTheDerivative -> nonReportable -> relationshipRecord is absent";
	
	class Default implements FCAUKEMIRMarginReportEMIR_VR_3030_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRMarginReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRMarginReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRMarginReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			try {
				if (exists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty1())).and(exists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty2()))).or(notExists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty1())).and(notExists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty2())))).getOrDefault(false)) {
					return notExists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<FCAUKEMIRNonReportableCollateralData>map("getNonReportable", partiesToTheDerivative -> partiesToTheDerivative.getNonReportable()).<String>map("getRelationshipRecord", fCAUKEMIRNonReportableCollateralData -> fCAUKEMIRNonReportableCollateralData.getRelationshipRecord()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRMarginReportEMIR_VR_3030_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			return Collections.emptyList();
		}
	}
}
