package drr.regulation.fca.ukemir.refit.margin.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.common.EnrichmentData;
import drr.enrichment.lei.LeiData;
import drr.enrichment.lei.LeiRegistrationStatusEnum;
import drr.enrichment.lei.functions.LeiRegistrationStatusIsValidForStatus;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.fca.ukemir.refit.margin.CollateralReport;
import drr.regulation.fca.ukemir.refit.margin.FCAUKEMIRMarginReport;
import drr.regulation.fca.ukemir.refit.margin.FCAUKEMIRNonReportableCollateralData;
import drr.regulation.fca.ukemir.refit.margin.PartiesToTheDerivative;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.19.3
 */
@RosettaDataRule("FCAUKEMIRMarginReportEMIR_VR_3030_04")
@ImplementedBy(FCAUKEMIRMarginReportEMIR_VR_3030_04.Default.class)
public interface FCAUKEMIRMarginReportEMIR_VR_3030_04 extends Validator<FCAUKEMIRMarginReport> {
	
	String NAME = "FCAUKEMIRMarginReportEMIR_VR_3030_04";
	String DEFINITION = "if [MarginActionEnum -> MARU, MarginActionEnum -> CORR] any = collateral -> actionType then ( if partiesToTheDerivative -> executionAgentOfCounterparty1 exists and partiesToTheDerivative -> executionAgentOfCounterparty2 is absent then LeiRegistrationStatusIsValidForStatus( partiesToTheDerivative -> nonReportable -> enrichment -> leiData, partiesToTheDerivative -> executionAgentOfCounterparty1, collateral -> eventDate, partiesToTheDerivative -> reportingTimestamp -> date, [LeiRegistrationStatusEnum -> Issued, LeiRegistrationStatusEnum -> PendingTransfer, LeiRegistrationStatusEnum -> PendingArchival] ) else if partiesToTheDerivative -> executionAgentOfCounterparty2 exists and partiesToTheDerivative -> executionAgentOfCounterparty1 is absent then LeiRegistrationStatusIsValidForStatus( partiesToTheDerivative -> nonReportable -> enrichment -> leiData, partiesToTheDerivative -> executionAgentOfCounterparty2, collateral -> eventDate, partiesToTheDerivative -> reportingTimestamp -> date, [LeiRegistrationStatusEnum -> Issued, LeiRegistrationStatusEnum -> PendingTransfer, LeiRegistrationStatusEnum -> PendingArchival] ) else if partiesToTheDerivative -> executionAgentOfCounterparty1 exists and partiesToTheDerivative -> executionAgentOfCounterparty2 exists then LeiRegistrationStatusIsValidForStatus( partiesToTheDerivative -> nonReportable -> enrichment -> leiData, partiesToTheDerivative -> executionAgentOfCounterparty1, collateral -> eventDate, partiesToTheDerivative -> reportingTimestamp -> date, [LeiRegistrationStatusEnum -> Issued, LeiRegistrationStatusEnum -> PendingTransfer, LeiRegistrationStatusEnum -> PendingArchival] ) and LeiRegistrationStatusIsValidForStatus( partiesToTheDerivative -> nonReportable -> enrichment -> leiData, partiesToTheDerivative -> executionAgentOfCounterparty2, collateral -> eventDate, partiesToTheDerivative -> reportingTimestamp -> date, [LeiRegistrationStatusEnum -> Issued, LeiRegistrationStatusEnum -> PendingTransfer, LeiRegistrationStatusEnum -> PendingArchival] ))";
	
	class Default implements FCAUKEMIRMarginReportEMIR_VR_3030_04 {
	
		@Inject protected LeiRegistrationStatusIsValidForStatus leiRegistrationStatusIsValidForStatus;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRMarginReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRMarginReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRMarginReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			try {
				if (areEqual(MapperC.<MarginActionEnum>of(MapperS.of(MarginActionEnum.MARU), MapperS.of(MarginActionEnum.CORR)), MapperS.of(fCAUKEMIRMarginReport).<CollateralReport>map("getCollateral", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getCollateral()).<MarginActionEnum>map("getActionType", collateralReport -> collateralReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					if (exists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty1())).and(notExists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty2()))).getOrDefault(false)) {
						return ComparisonResult.of(MapperS.of(leiRegistrationStatusIsValidForStatus.evaluate(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<FCAUKEMIRNonReportableCollateralData>map("getNonReportable", partiesToTheDerivative -> partiesToTheDerivative.getNonReportable()).<EnrichmentData>map("getEnrichment", fCAUKEMIRNonReportableCollateralData -> fCAUKEMIRNonReportableCollateralData.getEnrichment()).<LeiData>mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty1()).get(), MapperS.of(fCAUKEMIRMarginReport).<CollateralReport>map("getCollateral", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getCollateral()).<Date>map("getEventDate", collateralReport -> collateralReport.getEventDate()).get(), MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<ZonedDateTime>map("getReportingTimestamp", partiesToTheDerivative -> partiesToTheDerivative.getReportingTimestamp()).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())).get(), MapperC.<LeiRegistrationStatusEnum>of(MapperS.of(LeiRegistrationStatusEnum.ISSUED), MapperS.of(LeiRegistrationStatusEnum.PENDING_TRANSFER), MapperS.of(LeiRegistrationStatusEnum.PENDING_ARCHIVAL)).getMulti())));
					}
					if (exists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty2())).and(notExists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty1()))).getOrDefault(false)) {
						return ComparisonResult.of(MapperS.of(leiRegistrationStatusIsValidForStatus.evaluate(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<FCAUKEMIRNonReportableCollateralData>map("getNonReportable", partiesToTheDerivative -> partiesToTheDerivative.getNonReportable()).<EnrichmentData>map("getEnrichment", fCAUKEMIRNonReportableCollateralData -> fCAUKEMIRNonReportableCollateralData.getEnrichment()).<LeiData>mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty2()).get(), MapperS.of(fCAUKEMIRMarginReport).<CollateralReport>map("getCollateral", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getCollateral()).<Date>map("getEventDate", collateralReport -> collateralReport.getEventDate()).get(), MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<ZonedDateTime>map("getReportingTimestamp", partiesToTheDerivative -> partiesToTheDerivative.getReportingTimestamp()).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())).get(), MapperC.<LeiRegistrationStatusEnum>of(MapperS.of(LeiRegistrationStatusEnum.ISSUED), MapperS.of(LeiRegistrationStatusEnum.PENDING_TRANSFER), MapperS.of(LeiRegistrationStatusEnum.PENDING_ARCHIVAL)).getMulti())));
					}
					if (exists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty1())).and(exists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty2()))).getOrDefault(false)) {
						return ComparisonResult.of(MapperS.of(leiRegistrationStatusIsValidForStatus.evaluate(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<FCAUKEMIRNonReportableCollateralData>map("getNonReportable", partiesToTheDerivative -> partiesToTheDerivative.getNonReportable()).<EnrichmentData>map("getEnrichment", fCAUKEMIRNonReportableCollateralData -> fCAUKEMIRNonReportableCollateralData.getEnrichment()).<LeiData>mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty1()).get(), MapperS.of(fCAUKEMIRMarginReport).<CollateralReport>map("getCollateral", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getCollateral()).<Date>map("getEventDate", collateralReport -> collateralReport.getEventDate()).get(), MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<ZonedDateTime>map("getReportingTimestamp", partiesToTheDerivative -> partiesToTheDerivative.getReportingTimestamp()).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())).get(), MapperC.<LeiRegistrationStatusEnum>of(MapperS.of(LeiRegistrationStatusEnum.ISSUED), MapperS.of(LeiRegistrationStatusEnum.PENDING_TRANSFER), MapperS.of(LeiRegistrationStatusEnum.PENDING_ARCHIVAL)).getMulti()))).and(ComparisonResult.of(MapperS.of(leiRegistrationStatusIsValidForStatus.evaluate(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<FCAUKEMIRNonReportableCollateralData>map("getNonReportable", partiesToTheDerivative -> partiesToTheDerivative.getNonReportable()).<EnrichmentData>map("getEnrichment", fCAUKEMIRNonReportableCollateralData -> fCAUKEMIRNonReportableCollateralData.getEnrichment()).<LeiData>mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty2()).get(), MapperS.of(fCAUKEMIRMarginReport).<CollateralReport>map("getCollateral", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getCollateral()).<Date>map("getEventDate", collateralReport -> collateralReport.getEventDate()).get(), MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<ZonedDateTime>map("getReportingTimestamp", partiesToTheDerivative -> partiesToTheDerivative.getReportingTimestamp()).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())).get(), MapperC.<LeiRegistrationStatusEnum>of(MapperS.of(LeiRegistrationStatusEnum.ISSUED), MapperS.of(LeiRegistrationStatusEnum.PENDING_TRANSFER), MapperS.of(LeiRegistrationStatusEnum.PENDING_ARCHIVAL)).getMulti()))));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRMarginReportEMIR_VR_3030_04 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			return Collections.emptyList();
		}
	}
}
