package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.event.common.Trade;
import cdm.observable.asset.FloatingRateOption;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetIndexIndicatorFromFloatingRate;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsFRA;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.common.functions.RateOption;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iso.IndexEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IndicatorOfTheFloatingRateOfLeg1Rule.IndicatorOfTheFloatingRateOfLeg1RuleDefault.class)
public abstract class IndicatorOfTheFloatingRateOfLeg1Rule implements ReportFunction<TransactionReportInstruction, IndexEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetIndexIndicatorFromFloatingRate getIndexIndicatorFromFloatingRate;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsFRA isFRA;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;
	@Inject protected RateOption rateOption;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public IndexEnum evaluate(TransactionReportInstruction input) {
		IndexEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract IndexEnum doEvaluate(TransactionReportInstruction input);

	public static class IndicatorOfTheFloatingRateOfLeg1RuleDefault extends IndicatorOfTheFloatingRateOfLeg1Rule {
		@Override
		protected IndexEnum doEvaluate(TransactionReportInstruction input) {
			IndexEnum output = null;
			return assignOutput(output, input);
		}
		
		protected IndexEnum assignOutput(IndexEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<Trade> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(productForTrade.evaluate(item.get())));
			final MapperS<Product> thenArg3 = thenArg2
				.filterSingleNullSafe(item -> areEqual(MapperS.of(isFRA.evaluate(item.get())), MapperS.of(false), CardinalityOperator.All).get());
			final MapperS<Product> thenArg4 = thenArg3
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg5 = thenArg4
				.mapSingleToItem(item -> MapperS.of(interestRateLeg1.evaluate(item.get())));
			final MapperS<FloatingRateOption> thenArg6 = thenArg5
				.mapSingleToItem(item -> MapperS.of(rateOption.evaluate(item.get())));
			final MapperS<String> thenArg7 = thenArg6
				.mapSingleToItem(item -> item.<FieldWithMetaFloatingRateIndexEnum>map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex()).<FloatingRateIndexEnum>map("Type coercion", fieldWithMetaFloatingRateIndexEnum -> fieldWithMetaFloatingRateIndexEnum == null ? null : fieldWithMetaFloatingRateIndexEnum.getValue()).map("to-string", FloatingRateIndexEnum::toDisplayString));
			final MapperS<IndexEnum> thenArg8 = thenArg7
				.mapSingleToItem(item -> MapperS.of(getIndexIndicatorFromFloatingRate.evaluate(item.get())));
			output = thenArg8
				.mapSingleToItem(item -> {
					if (areEqual(MapperC.<IndexEnum>of(MapperS.of(IndexEnum.CORA), MapperS.of(IndexEnum.HKIO), MapperS.of(IndexEnum.TORF), MapperS.of(IndexEnum.SIBO), MapperS.of(IndexEnum.SSOR), MapperS.of(IndexEnum.SORA)), item, CardinalityOperator.Any).getOrDefault(false)) {
						return MapperS.<IndexEnum>ofNull();
					}
					return item;
				}).get();
			
			return output;
		}
	}
}
