package drr.regulation.hkma.rewrite.margin.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.hkma.rewrite.margin.HKMAMarginReport;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class HKMAMarginReportTypeFormatValidator implements Validator<HKMAMarginReport> {

	private List<ComparisonResult> getComparisonResults(HKMAMarginReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("counterparty1", o.getCounterparty1(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkString("counterparty2", o.getCounterparty2(), 20, of(72), of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), 
				checkString("counterparty2Name", o.getCounterparty2Name(), 1, of(105), of(Pattern.compile("[a-zA-Z0-9]{1,105}"))), 
				checkNumber("initialMarginPostedByTheReportingCounterparty1PreHaircut", o.getInitialMarginPostedByTheReportingCounterparty1PreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginPostedByTheReportingCounterparty1PostHaircut", o.getInitialMarginPostedByTheReportingCounterparty1PostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginCollectedByTheReportingCounterparty1PreHaircut", o.getInitialMarginCollectedByTheReportingCounterparty1PreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginCollectedByTheReportingCounterparty1PostHaircut", o.getInitialMarginCollectedByTheReportingCounterparty1PostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginPostedByTheReportingCounterparty1PreHaircut", o.getVariationMarginPostedByTheReportingCounterparty1PreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginPostedByTheReportingCounterparty1PostHaircut", o.getVariationMarginPostedByTheReportingCounterparty1PostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginCollectedByTheReportingCounterparty1PreHaircut", o.getVariationMarginCollectedByTheReportingCounterparty1PreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginCollectedByTheReportingCounterparty1PostHaircut", o.getVariationMarginCollectedByTheReportingCounterparty1PostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("excessCollateralPostedByTheCounterparty1", o.getExcessCollateralPostedByTheCounterparty1(), of(25), of(5), empty(), empty()), 
				checkNumber("excessCollateralCollectedByTheCounterparty1", o.getExcessCollateralCollectedByTheCounterparty1(), of(25), of(5), empty(), empty()), 
				checkString("uniqueTransactionIdentifier", o.getUniqueTransactionIdentifier(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}"))), 
				checkString("initialMarginCollateralPortfolioCode", o.getInitialMarginCollateralPortfolioCode(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), 
				checkString("variationMarginCollateralPortfolioCode", o.getVariationMarginCollateralPortfolioCode(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), 
				checkString("entityResponsibleForReporting", o.getEntityResponsibleForReporting(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkNumber("numberRecords", o.getNumberRecords(), of(25), of(5), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMAMarginReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("HKMAMarginReport", ValidationResult.ValidationType.TYPE_FORMAT, "HKMAMarginReport", path, "", res.getError());
				}
				return success("HKMAMarginReport", ValidationResult.ValidationType.TYPE_FORMAT, "HKMAMarginReport", path, "");
			})
			.collect(toList());
	}

}
