package drr.regulation.hkma.rewrite.trade.reports;

import cdm.product.template.BasketConstituent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import javax.inject.Inject;


@ImplementedBy(BasketConstituentUnitOfMeasureRule.BasketConstituentUnitOfMeasureRuleDefault.class)
public abstract class BasketConstituentUnitOfMeasureRule implements ReportFunction<BasketConstituent, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.regulation.common.trade.basket.reports.BasketConstituentUnitOfMeasureRule basketConstituentUnitOfMeasureRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(BasketConstituent input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(BasketConstituent input);

	public static class BasketConstituentUnitOfMeasureRuleDefault extends BasketConstituentUnitOfMeasureRule {
		@Override
		protected String doEvaluate(BasketConstituent input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, BasketConstituent input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(basketConstituentUnitOfMeasureRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
