package drr.regulation.mas.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.mas.rewrite.margin.MASMarginReport;
import drr.regulation.mas.rewrite.margin.labels.MASMarginLabelProvider;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.mas.rewrite.margin", body="MAS", corpusList={"Margin"})
@RuneLabelProvider(labelProvider=MASMarginLabelProvider.class)
@ImplementedBy(MASMarginReportFunction.MASMarginReportFunctionDefault.class)
public abstract class MASMarginReportFunction implements ReportFunction<CollateralReportInstruction, MASMarginReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected CollateralTimestampRule collateralTimestampRule;
	@Inject protected CollateralisationCategoryRule collateralisationCategoryRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CurrencyOfExcessCollateralCollectedRule currencyOfExcessCollateralCollectedRule;
	@Inject protected CurrencyOfExcessCollateralPostedRule currencyOfExcessCollateralPostedRule;
	@Inject protected DataSubmitterRule dataSubmitterRule;
	@Inject protected EventDateRule eventDateRule;
	@Inject protected ExcessCollateralCollectedByCounterparty1Rule excessCollateralCollectedByCounterparty1Rule;
	@Inject protected ExcessCollateralPostedByCounterparty1Rule excessCollateralPostedByCounterparty1Rule;
	@Inject protected ExecutionAgentOfTheCounterparty1DTCCRule executionAgentOfTheCounterparty1DTCCRule;
	@Inject protected InitialMarginCollateralPortfolioCodeDTCCRule initialMarginCollateralPortfolioCodeDTCCRule;
	@Inject protected InitialMarginCollectedByCounterparty1CurrencyRule initialMarginCollectedByCounterparty1CurrencyRule;
	@Inject protected InitialMarginCollectedByCounterparty1PostHaircutRule initialMarginCollectedByCounterparty1PostHaircutRule;
	@Inject protected InitialMarginCollectedByCounterparty1PreHaircutRule initialMarginCollectedByCounterparty1PreHaircutRule;
	@Inject protected InitialMarginPostedByCounterparty1CurrencyRule initialMarginPostedByCounterparty1CurrencyRule;
	@Inject protected InitialMarginPostedByCounterparty1PostHaircutRule initialMarginPostedByCounterparty1PostHaircutRule;
	@Inject protected InitialMarginPostedByCounterparty1PreHaircutRule initialMarginPostedByCounterparty1PreHaircutRule;
	@Inject protected ReportingSpecifiedPersonRule reportingSpecifiedPersonRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected TechnicalRecordIdRule technicalRecordIdRule;
	@Inject protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected VariationMarginCollateralPortfolioCodeDTCCRule variationMarginCollateralPortfolioCodeDTCCRule;
	@Inject protected VariationMarginCollectedByCounterparty1CurrencyRule variationMarginCollectedByCounterparty1CurrencyRule;
	@Inject protected VariationMarginCollectedByCounterparty1PostHaircutRule variationMarginCollectedByCounterparty1PostHaircutRule;
	@Inject protected VariationMarginCollectedByCounterparty1PreHaircutRule variationMarginCollectedByCounterparty1PreHaircutRule;
	@Inject protected VariationMarginPostedByCounterparty1CurrencyRule variationMarginPostedByCounterparty1CurrencyRule;
	@Inject protected VariationMarginPostedByCounterparty1PostHaircutRule variationMarginPostedByCounterparty1PostHaircutRule;
	@Inject protected VariationMarginPostedByCounterparty1PreHaircutRule variationMarginPostedByCounterparty1PreHaircutRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public MASMarginReport evaluate(CollateralReportInstruction input) {
		MASMarginReport.MASMarginReportBuilder outputBuilder = doEvaluate(input);
		
		final MASMarginReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(MASMarginReport.class, output);
		}
		
		return output;
	}

	protected abstract MASMarginReport.MASMarginReportBuilder doEvaluate(CollateralReportInstruction input);

	public static class MASMarginReportFunctionDefault extends MASMarginReportFunction {
		@Override
		protected MASMarginReport.MASMarginReportBuilder doEvaluate(CollateralReportInstruction input) {
			MASMarginReport.MASMarginReportBuilder output = MASMarginReport.builder();
			return assignOutput(output, input);
		}
		
		protected MASMarginReport.MASMarginReportBuilder assignOutput(MASMarginReport.MASMarginReportBuilder output, CollateralReportInstruction input) {
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierType(counterparty2IdentifierTypeRule.evaluate(input));
			
			output
				.setReportingSpecifiedPerson(reportingSpecifiedPersonRule.evaluate(input));
			
			output
				.setDataSubmitter(dataSubmitterRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifierProprietary(uniqueTransactionIdentifierProprietaryRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setCollateralTimestamp(collateralTimestampRule.evaluate(input));
			
			output
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.setInitialMarginCollateralPortfolioCode(initialMarginCollateralPortfolioCodeDTCCRule.evaluate(input));
			
			output
				.setVariationMarginCollateralPortfolioCode(variationMarginCollateralPortfolioCodeDTCCRule.evaluate(input));
			
			output
				.setInitialMarginPostedByCounterparty1PreHaircut(initialMarginPostedByCounterparty1PreHaircutRule.evaluate(input));
			
			output
				.setInitialMarginPostedByCounterparty1PostHaircut(initialMarginPostedByCounterparty1PostHaircutRule.evaluate(input));
			
			output
				.setInitialMarginPostedByCounterparty1Currency(initialMarginPostedByCounterparty1CurrencyRule.evaluate(input));
			
			output
				.setInitialMarginCollectedByCounterparty1PreHaircut(initialMarginCollectedByCounterparty1PreHaircutRule.evaluate(input));
			
			output
				.setInitialMarginCollectedByCounterparty1PostHaircut(initialMarginCollectedByCounterparty1PostHaircutRule.evaluate(input));
			
			output
				.setInitialMarginCollectedByCounterparty1Currency(initialMarginCollectedByCounterparty1CurrencyRule.evaluate(input));
			
			output
				.setVariationMarginPostedByCounterparty1PreHaircut(variationMarginPostedByCounterparty1PreHaircutRule.evaluate(input));
			
			output
				.setVariationMarginPostedByCounterparty1PostHaircut(variationMarginPostedByCounterparty1PostHaircutRule.evaluate(input));
			
			output
				.setVariationMarginPostedByCounterparty1Currency(variationMarginPostedByCounterparty1CurrencyRule.evaluate(input));
			
			output
				.setVariationMarginCollectedByCounterparty1PreHaircut(variationMarginCollectedByCounterparty1PreHaircutRule.evaluate(input));
			
			output
				.setVariationMarginCollectedByCounterparty1PostHaircut(variationMarginCollectedByCounterparty1PostHaircutRule.evaluate(input));
			
			output
				.setVariationMarginCollectedByCounterparty1Currency(variationMarginCollectedByCounterparty1CurrencyRule.evaluate(input));
			
			output
				.setExcessCollateralPostedByCounterparty1(excessCollateralPostedByCounterparty1Rule.evaluate(input));
			
			output
				.setCurrencyOfExcessCollateralPosted(currencyOfExcessCollateralPostedRule.evaluate(input));
			
			output
				.setExcessCollateralCollectedByCounterparty1(excessCollateralCollectedByCounterparty1Rule.evaluate(input));
			
			output
				.setCurrencyOfExcessCollateralCollected(currencyOfExcessCollateralCollectedRule.evaluate(input));
			
			output
				.setCollateralisationCategory(collateralisationCategoryRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventDate(eventDateRule.evaluate(input));
			
			output
				.setTechnicalRecordId(technicalRecordIdRule.evaluate(input));
			
			output
				.setExecutionAgentOfTheCounterparty1(executionAgentOfTheCounterparty1DTCCRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
