package drr.standards.iosco.cde.base.execution.functions;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.AdjustableDates;
import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.AdjustableOrRelativeDates;
import cdm.base.datetime.DateRange;
import cdm.base.datetime.PeriodicDates;
import cdm.observable.asset.PerformanceValuationDates;
import cdm.observable.asset.ValuationDates;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.ObservationDates;
import cdm.product.common.schedule.ObservationTerms;
import cdm.product.common.schedule.PaymentDateSchedule;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.common.settlement.SettlementDate;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.AmericanExercise;
import cdm.product.template.BermudaExercise;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.EuropeanExercise;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionStyle;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.SchedulePeriod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.functions.AdjustableDateResolution;
import drr.regulation.common.functions.AdjustableDatesResolution;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCommodityFixedPriceForward;
import drr.regulation.common.functions.IsCommodityFloatingPriceForward;
import drr.regulation.common.functions.IsCommodityOption;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsCommoditySwapFloatFloat;
import drr.regulation.common.functions.IsCommoditySwaption;
import drr.regulation.common.functions.IsProductETD;
import drr.regulation.common.functions.IsVarianceSwap;
import drr.regulation.common.functions.IsVolatilitySwap;
import drr.regulation.common.functions.MaxTerminationDate;
import drr.regulation.common.functions.UnderlierForProduct;
import java.util.Arrays;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ExtractFinalContractualSettlementDate.ExtractFinalContractualSettlementDateDefault.class)
public abstract class ExtractFinalContractualSettlementDate implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected AdjustableDateResolution adjustableDateResolution;
	@Inject protected AdjustableDatesResolution adjustableDatesResolution;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCommodityOption isCommodityOption;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;
	@Inject protected IsCommoditySwaption isCommoditySwaption;
	@Inject protected IsProductETD isProductETD;
	@Inject protected IsVarianceSwap isVarianceSwap;
	@Inject protected IsVolatilitySwap isVolatilitySwap;
	@Inject protected MaxTerminationDate maxTerminationDate;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param reportableInformation 
	* @param product 
	* @return finalContractualSettlementDate 
	*/
	public Date evaluate(ReportableInformation reportableInformation, Product product) {
		Date finalContractualSettlementDate = doEvaluate(reportableInformation, product);
		
		return finalContractualSettlementDate;
	}

	protected abstract Date doEvaluate(ReportableInformation reportableInformation, Product product);

	public static class ExtractFinalContractualSettlementDateDefault extends ExtractFinalContractualSettlementDate {
		@Override
		protected Date doEvaluate(ReportableInformation reportableInformation, Product product) {
			Date finalContractualSettlementDate = null;
			return assignOutput(finalContractualSettlementDate, reportableInformation, product);
		}
		
		protected Date assignOutput(Date finalContractualSettlementDate, ReportableInformation reportableInformation, Product product) {
			if (exists(MapperS.of(reportableInformation).<Date>map("getFinalContractualSettlementDate", _reportableInformation -> _reportableInformation.getFinalContractualSettlementDate())).getOrDefault(false)) {
				finalContractualSettlementDate = MapperS.of(reportableInformation).<Date>map("getFinalContractualSettlementDate", _reportableInformation -> _reportableInformation.getFinalContractualSettlementDate()).get();
			} else if (ComparisonResult.of(MapperS.of(isCommoditySwap.evaluate(product))).or(ComparisonResult.of(MapperS.of(isCommodityFloatingPriceForward.evaluate(product)))).and(exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule()))).getOrDefault(false)) {
				finalContractualSettlementDate = MapperC.<Date>of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule()).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).<Date>map("getPaymentDate", schedulePeriod -> schedulePeriod.getPaymentDate())
					.max(), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
					.max().get();
			} else if (ComparisonResult.of(MapperS.of(isCommodityFixedPriceForward.evaluate(product))).and(exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).<CalculationSchedule>map("getSchedule", fixedPricePayout -> fixedPricePayout.getSchedule()))).getOrDefault(false)) {
				finalContractualSettlementDate = MapperC.<Date>of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).<CalculationSchedule>map("getSchedule", fixedPricePayout -> fixedPricePayout.getSchedule()).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).<Date>map("getPaymentDate", schedulePeriod -> schedulePeriod.getPaymentDate())
					.max(), MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).<CalculationSchedule>map("getSchedule", fixedPricePayout -> fixedPricePayout.getSchedule()).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).<DateRange>map("getFixingPeriod", schedulePeriod -> schedulePeriod.getFixingPeriod()).<Date>map("getEndDate", dateRange -> dateRange.getEndDate())
					.max(), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
					.max().get();
			} else if (ComparisonResult.of(MapperS.of(isCommodityOption.evaluate(product))).or(ComparisonResult.of(MapperS.of(isCommoditySwaption.evaluate(product)))).and(exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<CalculationSchedule>map("getSchedule", optionPayout -> optionPayout.getSchedule()))).getOrDefault(false)) {
				finalContractualSettlementDate = MapperC.<Date>of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<CalculationSchedule>map("getSchedule", optionPayout -> optionPayout.getSchedule()).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).<Date>map("getPaymentDate", schedulePeriod -> schedulePeriod.getPaymentDate())
					.max(), MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<CalculationSchedule>map("getSchedule", optionPayout -> optionPayout.getSchedule()).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).<DateRange>map("getFixingPeriod", schedulePeriod -> schedulePeriod.getFixingPeriod()).<Date>map("getEndDate", dateRange -> dateRange.getEndDate())
					.max(), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
					.max().get();
			} else if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(product)))).and(exists(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule()))).getOrDefault(false)) {
				finalContractualSettlementDate = MapperC.<Date>of(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule()).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).<Date>map("getPaymentDate", schedulePeriod -> schedulePeriod.getPaymentDate())
					.max(), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
					.max().get();
			} else if (ComparisonResult.of(MapperS.of(isCommoditySwap.evaluate(product))).or(ComparisonResult.of(MapperS.of(isCommodityFloatingPriceForward.evaluate(product)))).getOrDefault(false)) {
				finalContractualSettlementDate = MapperC.<Date>of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<PaymentDates>map("getPaymentDates", commodityPayout -> commodityPayout.getPaymentDates())
					.first().<Date>map("getLastRegularPaymentDate", paymentDates -> paymentDates.getLastRegularPaymentDate()), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
					.max().get();
			} else {
				final Boolean boolean0 = isCommodityFixedPriceForward.evaluate(product);
				if ((boolean0 == null ? false : boolean0)) {
					finalContractualSettlementDate = MapperC.<Date>of(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get()).<PaymentDates>map("getPaymentDates", fixedPricePayout -> fixedPricePayout.getPaymentDates()).<Date>map("getLastRegularPaymentDate", paymentDates -> paymentDates.getLastRegularPaymentDate()), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
						.max().get();
				} else if (exists(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product))).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate())).getOrDefault(false)) {
					finalContractualSettlementDate = MapperC.<Date>of(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product))).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
						.mapSingleToItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get()))), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
						.max().get();
				} else if (exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(false)) {
					final MapperC<Date> thenArg0 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
						.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
					final MapperC<Date> thenArg1 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Date>map("getFirstPaymentDate", paymentDates -> paymentDates.getFirstPaymentDate());
					final MapperC<Date> thenArg2 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Date>map("getLastRegularPaymentDate", paymentDates -> paymentDates.getLastRegularPaymentDate());
					final MapperC<Date> thenArg3 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<PaymentDateSchedule>map("getPaymentDateSchedule", paymentDates -> paymentDates.getPaymentDateSchedule()).<AdjustableOrRelativeDate>map("getFinalPaymentDate", paymentDateSchedule -> paymentDateSchedule.getFinalPaymentDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
						.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
					finalContractualSettlementDate = MapperC.<Date>of(thenArg0
						.max(), thenArg1
						.max(), thenArg2
						.max(), thenArg3
						.max(), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
						.max().get();
				} else {
					final Boolean boolean1 = isCommoditySwapFloatFloat.evaluate(product);
					if ((boolean1 == null ? false : boolean1)) {
						final MapperC<Date> thenArg4 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<CalculationPeriodDates>map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						finalContractualSettlementDate = MapperC.<Date>of(thenArg4
							.max(), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
							.max().get();
					} else if (exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<EuropeanExercise>map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise()).<AdjustableOrRelativeDate>mapC("getExpirationDate", europeanExercise -> europeanExercise.getExpirationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(false)) {
						final MapperC<Date> thenArg5 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<EuropeanExercise>map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise()).<AdjustableOrRelativeDate>mapC("getExpirationDate", europeanExercise -> europeanExercise.getExpirationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						final MapperC<Date> thenArg6 = MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						finalContractualSettlementDate = MapperC.<Date>of(thenArg5
							.max(), MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<SettlementTerms>map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<Date>map("getValueDate", settlementDate -> settlementDate.getValueDate())
							.max(), thenArg6
							.max(), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
							.max().get();
					} else if (exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<BermudaExercise>map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise()).<AdjustableOrRelativeDates>map("getBermudaExerciseDates", bermudaExercise -> bermudaExercise.getBermudaExerciseDates()).<AdjustableDates>map("getAdjustableDates", adjustableOrRelativeDates -> adjustableOrRelativeDates.getAdjustableDates())).getOrDefault(false)) {
						final MapperListOfLists<Date> thenArg7 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<BermudaExercise>map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise()).<AdjustableOrRelativeDates>map("getBermudaExerciseDates", bermudaExercise -> bermudaExercise.getBermudaExerciseDates()).<AdjustableDates>map("getAdjustableDates", adjustableOrRelativeDates -> adjustableOrRelativeDates.getAdjustableDates())
							.mapItemToList(item -> MapperC.<Date>of(adjustableDatesResolution.evaluate(item.get())));
						final MapperC<Date> thenArg8 = thenArg7
							.flattenList();
						final MapperC<Date> thenArg9 = MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						finalContractualSettlementDate = MapperC.<Date>of(thenArg8
							.max(), MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<SettlementTerms>map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<Date>map("getValueDate", settlementDate -> settlementDate.getValueDate())
							.max(), thenArg9
							.max(), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
							.max().get();
					} else if (exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<AmericanExercise>map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise()).<AdjustableOrRelativeDate>map("getExpirationDate", americanExercise -> americanExercise.getExpirationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(false)) {
						final MapperC<Date> thenArg10 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<AmericanExercise>map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise()).<AdjustableOrRelativeDate>map("getExpirationDate", americanExercise -> americanExercise.getExpirationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						final MapperC<Date> thenArg11 = MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						finalContractualSettlementDate = MapperC.<Date>of(thenArg10
							.max(), MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<SettlementTerms>map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<Date>map("getValueDate", settlementDate -> settlementDate.getValueDate())
							.max(), thenArg11
							.max(), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
							.max().get();
					} else if (areEqual(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).resultCount()), MapperS.of(1), CardinalityOperator.All).and(areEqual(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).resultCount()), MapperS.of(1), CardinalityOperator.All)).or(ComparisonResult.of(MapperS.of(isVarianceSwap.evaluate(product)))).or(ComparisonResult.of(MapperS.of(isVolatilitySwap.evaluate(product)))).getOrDefault(false)) {
						final MapperC<Date> thenArg12 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<ObservationTerms>map("getObservationTerms", performancePayout -> performancePayout.getObservationTerms()).<ObservationDates>map("getObservationDates", observationTerms -> observationTerms.getObservationDates()).<PeriodicDates>map("getPeriodicSchedule", observationDates -> observationDates.getPeriodicSchedule()).<AdjustableOrRelativeDate>map("getEndDate", periodicDates -> periodicDates.getEndDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						final MapperC<Date> thenArg13 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<PaymentDates>map("getPaymentDates", performancePayout -> performancePayout.getPaymentDates()).<Date>map("getLastRegularPaymentDate", paymentDates -> paymentDates.getLastRegularPaymentDate());
						final MapperC<Date> thenArg14 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<PaymentDates>map("getPaymentDates", performancePayout -> performancePayout.getPaymentDates()).<Date>map("getFirstPaymentDate", paymentDates -> paymentDates.getFirstPaymentDate());
						final MapperC<Date> thenArg15 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<PaymentDates>map("getPaymentDates", performancePayout -> performancePayout.getPaymentDates()).<PaymentDateSchedule>map("getPaymentDateSchedule", paymentDates -> paymentDates.getPaymentDateSchedule()).<AdjustableOrRelativeDate>map("getFinalPaymentDate", paymentDateSchedule -> paymentDateSchedule.getFinalPaymentDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						final MapperC<Date> thenArg16 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Date>map("getLastRegularPaymentDate", paymentDates -> paymentDates.getLastRegularPaymentDate());
						final MapperC<Date> thenArg17 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Date>map("getFirstPaymentDate", paymentDates -> paymentDates.getFirstPaymentDate());
						final MapperC<Date> thenArg18 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<PaymentDateSchedule>map("getPaymentDateSchedule", paymentDates -> paymentDates.getPaymentDateSchedule()).<AdjustableOrRelativeDate>map("getFinalPaymentDate", paymentDateSchedule -> paymentDateSchedule.getFinalPaymentDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
							.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get())));
						final MapperC<Date> thenArg19 = MapperC.<Date>of(MapperS.of(maxTerminationDate.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<ValuationDates>map("getValuationDates", performancePayout -> performancePayout.getValuationDates()).<PerformanceValuationDates>map("getValuationDatesFinal", valuationDates -> valuationDates.getValuationDatesFinal()).<AdjustableOrRelativeDate>map("getValuationDate", performanceValuationDates -> performanceValuationDates.getValuationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get(), MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<AdjustableOrRelativeDate>map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())), thenArg12
							.max(), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())), thenArg13
							.max(), thenArg14
							.max(), thenArg15
							.max(), thenArg16
							.max(), thenArg17
							.max(), thenArg18
							.max());
						finalContractualSettlementDate = thenArg19
							.max().get();
					} else if (exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).<SettlementTerms>map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<Date>map("getValueDate", settlementDate -> settlementDate.getValueDate())).getOrDefault(false)) {
						finalContractualSettlementDate = MapperC.<Date>of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).<SettlementTerms>map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<Date>map("getValueDate", settlementDate -> settlementDate.getValueDate())
							.max(), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
							.max().get();
					} else if (ComparisonResult.of(MapperS.of(isProductETD.evaluate(product))).and(ComparisonResult.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout())
						.mapSingleToItem(item -> onlyExists(item, Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("forwardPayout")).asMapper()))).getOrDefault(false)) {
						finalContractualSettlementDate = MapperC.<Date>of(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<SettlementTerms>map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).<SettlementDate>map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).<Date>map("getValueDate", settlementDate -> settlementDate.getValueDate()), MapperS.of(adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get())))
							.max().get();
					} else if (exists(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate())).getOrDefault(false)) {
						finalContractualSettlementDate = adjustableDateResolution.evaluate(MapperS.of(economicTermsForProduct.evaluate(product)).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get());
					} else {
						finalContractualSettlementDate = null;
					}
				}
			}
			
			return finalContractualSettlementDate;
		}
	}
}
