package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.observable.asset.Price;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetPackageInformation;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PackageTransactionPriceNoFormatRule.PackageTransactionPriceNoFormatRuleDefault.class)
public abstract class PackageTransactionPriceNoFormatRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetPackageInformation getPackageInformation;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class PackageTransactionPriceNoFormatRuleDefault extends PackageTransactionPriceNoFormatRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<Price> thenArg = MapperS.of(getPackageInformation.evaluate(input)).<Price>map("getPrice", identifiedList -> identifiedList.getPrice());
			output = thenArg
				.mapSingleToItem(item -> {
					if (notExists(item.<ArithmeticOperationEnum>map("getArithmeticOperator", price -> price.getArithmeticOperator())).getOrDefault(false)) {
						return item.<BigDecimal>map("getValue", price -> price.getValue());
					}
					return MapperS.<BigDecimal>ofNull();
				}).get();
			
			return output;
		}
	}
}
