package drr.standards.iosco.cde.version1.price.reports;

import cdm.event.common.Trade;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.RateSpecification;
import cdm.product.asset.SpreadSchedule;
import cdm.product.common.settlement.CommodityPriceReturnTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(SpreadLeg2Rule.SpreadLeg2RuleDefault.class)
public abstract class SpreadLeg2Rule implements ReportFunction<TransactionReportInstruction, PriceSchedule> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected TradeForEvent tradeForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceSchedule evaluate(TransactionReportInstruction input) {
		PriceSchedule.PriceScheduleBuilder outputBuilder = doEvaluate(input);
		
		final PriceSchedule output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(PriceSchedule.class, output);
		}
		
		return output;
	}

	protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(TransactionReportInstruction input);

	public static class SpreadLeg2RuleDefault extends SpreadLeg2Rule {
		@Override
		protected PriceSchedule.PriceScheduleBuilder doEvaluate(TransactionReportInstruction input) {
			PriceSchedule.PriceScheduleBuilder output = PriceSchedule.builder();
			return assignOutput(output, input);
		}
		
		protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg0 = MapperS.of(tradeForEvent.evaluate(input));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForTrade.evaluate(item.get())));
			final MapperS<SpreadSchedule> thenArg2 = thenArg1
				.mapSingleToItem(item -> {
					final Boolean boolean0 = isIRSwaption.evaluate(item.get());
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(interestRateLeg2.evaluate(underlierForProduct.evaluate(item.get()))).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<SpreadSchedule>map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule());
					}
					final Boolean boolean1 = isCommoditySwap.evaluate(item.get());
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(commodityLeg2.evaluate(item.get())).<CommodityPriceReturnTerms>map("getCommodityPriceReturnTerms", commodityPayout -> commodityPayout.getCommodityPriceReturnTerms()).<SpreadSchedule>map("getSpread", commodityPriceReturnTerms -> commodityPriceReturnTerms.getSpread());
					}
					return MapperS.of(interestRateLeg2.evaluate(item.get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<SpreadSchedule>map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule());
				});
			final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = thenArg2
				.mapSingleToItem(item -> item.<ReferenceWithMetaPriceSchedule>map("getPrice", spreadSchedule -> spreadSchedule.getPrice())).get();
			if (referenceWithMetaPriceSchedule == null) {
				output = null;
			} else {
				output = toBuilder(referenceWithMetaPriceSchedule.getValue());
			}
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
