package drr.standards.iosco.cde.version1.price.reports;

import cdm.product.asset.CommodityPayout;
import cdm.product.asset.SpreadSchedule;
import cdm.product.common.settlement.CommodityPriceReturnTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Spread_CommodityRule.Spread_CommodityRuleDefault.class)
public abstract class Spread_CommodityRule implements ReportFunction<CommodityPayout, SpreadSchedule> {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public SpreadSchedule evaluate(CommodityPayout input) {
		SpreadSchedule.SpreadScheduleBuilder outputBuilder = doEvaluate(input);
		
		final SpreadSchedule output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(SpreadSchedule.class, output);
		}
		
		return output;
	}

	protected abstract SpreadSchedule.SpreadScheduleBuilder doEvaluate(CommodityPayout input);

	public static class Spread_CommodityRuleDefault extends Spread_CommodityRule {
		@Override
		protected SpreadSchedule.SpreadScheduleBuilder doEvaluate(CommodityPayout input) {
			SpreadSchedule.SpreadScheduleBuilder output = SpreadSchedule.builder();
			return assignOutput(output, input);
		}
		
		protected SpreadSchedule.SpreadScheduleBuilder assignOutput(SpreadSchedule.SpreadScheduleBuilder output, CommodityPayout input) {
			output = toBuilder(MapperS.of(input).<CommodityPriceReturnTerms>map("getCommodityPriceReturnTerms", commodityPayout -> commodityPayout.getCommodityPriceReturnTerms()).<SpreadSchedule>map("getSpread", commodityPriceReturnTerms -> commodityPriceReturnTerms.getSpread()).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
