package drr.standards.iosco.cde.version2.basket.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;


@ImplementedBy(BasketConstituentUnitOfMeasureRule.BasketConstituentUnitOfMeasureRuleDefault.class)
public abstract class BasketConstituentUnitOfMeasureRule implements ReportFunction<TransactionReportInstruction, List<String>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version1.basket.reports.BasketConstituentUnitOfMeasureRule basketConstituentUnitOfMeasureRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<String> evaluate(TransactionReportInstruction input) {
		List<String> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<String> doEvaluate(TransactionReportInstruction input);

	public static class BasketConstituentUnitOfMeasureRuleDefault extends BasketConstituentUnitOfMeasureRule {
		@Override
		protected List<String> doEvaluate(TransactionReportInstruction input) {
			List<String> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<String> assignOutput(List<String> output, TransactionReportInstruction input) {
			output = basketConstituentUnitOfMeasureRule.evaluate(input);
			
			return output;
		}
	}
}
