package drr.standards.iosco.cde.version2.party.functions;

import cdm.base.staticdata.party.PayerReceiver;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iso.Direction2Enum;
import javax.inject.Inject;


@ImplementedBy(Direction2.Direction2Default.class)
public abstract class Direction2 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version1.party.functions.Direction2 direction2;

	/**
	* @param event 
	* @param payerReceiver 
	* @return direction 
	*/
	public Direction2Enum evaluate(TransactionReportInstruction event, PayerReceiver payerReceiver) {
		Direction2Enum direction = doEvaluate(event, payerReceiver);
		
		return direction;
	}

	protected abstract Direction2Enum doEvaluate(TransactionReportInstruction event, PayerReceiver payerReceiver);

	public static class Direction2Default extends Direction2 {
		@Override
		protected Direction2Enum doEvaluate(TransactionReportInstruction event, PayerReceiver payerReceiver) {
			Direction2Enum direction = null;
			return assignOutput(direction, event, payerReceiver);
		}
		
		protected Direction2Enum assignOutput(Direction2Enum direction, TransactionReportInstruction event, PayerReceiver payerReceiver) {
			direction = direction2.evaluate(event, payerReceiver);
			
			return direction;
		}
	}
}
