package drr.standards.iosco.cde.version3.basket.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;


@ImplementedBy(BasketConstituentNumberOfUnitsRule.BasketConstituentNumberOfUnitsRuleDefault.class)
public abstract class BasketConstituentNumberOfUnitsRule implements ReportFunction<TransactionReportInstruction, List<BigDecimal>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version2.basket.reports.BasketConstituentNumberOfUnitsRule basketConstituentNumberOfUnitsRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<BigDecimal> evaluate(TransactionReportInstruction input) {
		List<BigDecimal> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<BigDecimal> doEvaluate(TransactionReportInstruction input);

	public static class BasketConstituentNumberOfUnitsRuleDefault extends BasketConstituentNumberOfUnitsRule {
		@Override
		protected List<BigDecimal> doEvaluate(TransactionReportInstruction input) {
			List<BigDecimal> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<BigDecimal> assignOutput(List<BigDecimal> output, TransactionReportInstruction input) {
			output = basketConstituentNumberOfUnitsRule.evaluate(input);
			
			return output;
		}
	}
}
