package drr.standards.iosco.upi.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.standards.iosco.upi.AnnaDsbBaseProduct;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class AnnaDsbBaseProductTypeFormatValidator implements Validator<AnnaDsbBaseProduct> {

	private List<ComparisonResult> getComparisonResults(AnnaDsbBaseProduct o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, AnnaDsbBaseProduct o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("AnnaDsbBaseProduct", ValidationResult.ValidationType.TYPE_FORMAT, "AnnaDsbBaseProduct", path, "", res.getError());
				}
				return success("AnnaDsbBaseProduct", ValidationResult.ValidationType.TYPE_FORMAT, "AnnaDsbBaseProduct", path, "");
			})
			.collect(toList());
	}

}
