/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.collect.ArgChecker;
import java.time.DayOfWeek;
import java.time.LocalDate;

enum StandardBusinessDayConventions implements BusinessDayConvention
{
    NO_ADJUST("NoAdjust"){

        @Override
        public LocalDate adjust(LocalDate date, HolidayCalendar calendar) {
            return (LocalDate)ArgChecker.notNull((Object)date, (String)"date");
        }
    }
    ,
    FOLLOWING("Following"){

        @Override
        public LocalDate adjust(LocalDate date, HolidayCalendar calendar) {
            return calendar.nextOrSame(date);
        }
    }
    ,
    MODIFIED_FOLLOWING("ModifiedFollowing"){

        @Override
        public LocalDate adjust(LocalDate date, HolidayCalendar calendar) {
            return calendar.nextSameOrLastInMonth(date);
        }
    }
    ,
    MODIFIED_FOLLOWING_BI_MONTHLY("ModifiedFollowingBiMonthly"){

        @Override
        public LocalDate adjust(LocalDate date, HolidayCalendar calendar) {
            LocalDate adjusted = calendar.nextOrSame(date);
            if (adjusted.getMonthValue() != date.getMonthValue() || adjusted.getDayOfMonth() > 15 && date.getDayOfMonth() <= 15) {
                adjusted = calendar.previous(date);
            }
            return adjusted;
        }
    }
    ,
    PRECEDING("Preceding"){

        @Override
        public LocalDate adjust(LocalDate date, HolidayCalendar calendar) {
            return calendar.previousOrSame(date);
        }
    }
    ,
    MODIFIED_PRECEDING("ModifiedPreceding"){

        @Override
        public LocalDate adjust(LocalDate date, HolidayCalendar calendar) {
            LocalDate adjusted = calendar.previousOrSame(date);
            if (adjusted.getMonth() != date.getMonth()) {
                adjusted = calendar.next(date);
            }
            return adjusted;
        }
    }
    ,
    NEAREST("Nearest"){

        @Override
        public LocalDate adjust(LocalDate date, HolidayCalendar calendar) {
            if (calendar.isBusinessDay(date)) {
                return date;
            }
            if (date.getDayOfWeek() == DayOfWeek.SUNDAY || date.getDayOfWeek() == DayOfWeek.MONDAY) {
                return calendar.next(date);
            }
            return calendar.previous(date);
        }
    };

    private final String name;

    private StandardBusinessDayConventions(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

