/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.basics.index.FloatingRateName;
import com.opengamma.strata.basics.index.FloatingRateType;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.collect.Guavate;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalInt;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(builderScope="package")
public final class ImmutableFloatingRateName
implements FloatingRateName,
ImmutableBean,
Serializable {
    private static final String AVERAGE_SUFFIX = "-AVG";
    @PropertyDefinition(validate="notEmpty")
    private final String externalName;
    @PropertyDefinition(validate="notEmpty")
    private final String indexName;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FloatingRateType type;
    @PropertyDefinition(get="optional")
    private final Integer fixingDateOffsetDays;
    private static final long serialVersionUID = 1L;

    public static ImmutableFloatingRateName of(String externalName, String indexName, FloatingRateType type) {
        return new ImmutableFloatingRateName(externalName, indexName, type, null);
    }

    public static ImmutableFloatingRateName of(String externalName, String indexName, FloatingRateType type, int fixingDateOffsetDays) {
        return new ImmutableFloatingRateName(externalName, indexName, type, fixingDateOffsetDays >= 0 ? Integer.valueOf(fixingDateOffsetDays) : null);
    }

    @Override
    public String getName() {
        return this.externalName;
    }

    @Override
    public Set<Tenor> getTenors() {
        if (!this.type.isIbor()) {
            return ImmutableSet.of();
        }
        return (Set)IborIndex.extendedEnum().lookupAll().values().stream().filter(index -> index.getName().startsWith(this.indexName)).filter(index -> index.isActive()).map(index -> index.getTenor()).sorted().collect(Guavate.toImmutableSet());
    }

    @Override
    public FloatingRateName normalized() {
        if (this.type.isIbor() && this.indexName.endsWith("-")) {
            return FloatingRateName.of(this.indexName.substring(0, this.indexName.length() - 1));
        }
        return FloatingRateName.of(this.indexName);
    }

    @Override
    public IborIndex toIborIndex(Tenor tenor) {
        if (!this.type.isIbor()) {
            throw new IllegalStateException("Incorrect index type, expected Ibor: " + this.externalName);
        }
        return IborIndex.of(this.indexName + tenor.normalized().toString());
    }

    @Override
    public DaysAdjustment toIborIndexFixingOffset() {
        DaysAdjustment base = FloatingRateName.super.toIborIndexFixingOffset();
        if (this.fixingDateOffsetDays == null) {
            return base;
        }
        if (this.fixingDateOffsetDays == 0) {
            return DaysAdjustment.ofCalendarDays(0, BusinessDayAdjustment.of(BusinessDayConventions.PRECEDING, base.getResultCalendar()));
        }
        return base.toBuilder().days(this.fixingDateOffsetDays).build().normalized();
    }

    @Override
    public OvernightIndex toOvernightIndex() {
        if (!this.type.isOvernight()) {
            throw new IllegalStateException("Incorrect index type, expected Overnight: " + this.externalName);
        }
        if (this.indexName.endsWith(AVERAGE_SUFFIX)) {
            return OvernightIndex.of(this.indexName.substring(0, this.indexName.length() - 4));
        }
        return OvernightIndex.of(this.indexName);
    }

    @Override
    public PriceIndex toPriceIndex() {
        if (!this.type.isPrice()) {
            throw new IllegalStateException("Incorrect index type, expected Price: " + this.externalName);
        }
        return PriceIndex.of(this.indexName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImmutableFloatingRateName) {
            return this.externalName.equals(((ImmutableFloatingRateName)obj).externalName);
        }
        return false;
    }

    public int hashCode() {
        return this.externalName.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    static Builder builder() {
        return new Builder();
    }

    private ImmutableFloatingRateName(String externalName, String indexName, FloatingRateType type, Integer fixingDateOffsetDays) {
        JodaBeanUtils.notEmpty((String)externalName, (String)"externalName");
        JodaBeanUtils.notEmpty((String)indexName, (String)"indexName");
        JodaBeanUtils.notNull((Object)((Object)type), (String)"type");
        this.externalName = externalName;
        this.indexName = indexName;
        this.type = type;
        this.fixingDateOffsetDays = fixingDateOffsetDays;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public FloatingRateType getType() {
        return this.type;
    }

    public OptionalInt getFixingDateOffsetDays() {
        return this.fixingDateOffsetDays != null ? OptionalInt.of(this.fixingDateOffsetDays) : OptionalInt.empty();
    }

    Builder toBuilder() {
        return new Builder(this);
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableFloatingRateName> {
        private String externalName;
        private String indexName;
        private FloatingRateType type;
        private Integer fixingDateOffsetDays;

        private Builder() {
        }

        private Builder(ImmutableFloatingRateName beanToCopy) {
            this.externalName = beanToCopy.getExternalName();
            this.indexName = beanToCopy.getIndexName();
            this.type = beanToCopy.getType();
            this.fixingDateOffsetDays = beanToCopy.fixingDateOffsetDays;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1386121994: {
                    return this.externalName;
                }
                case -807707011: {
                    return this.indexName;
                }
                case 3575610: {
                    return this.type;
                }
                case -594001179: {
                    return this.fixingDateOffsetDays;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1386121994: {
                    this.externalName = (String)newValue;
                    break;
                }
                case -807707011: {
                    this.indexName = (String)newValue;
                    break;
                }
                case 3575610: {
                    this.type = (FloatingRateType)((Object)newValue);
                    break;
                }
                case -594001179: {
                    this.fixingDateOffsetDays = (Integer)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableFloatingRateName build() {
            return new ImmutableFloatingRateName(this.externalName, this.indexName, this.type, this.fixingDateOffsetDays);
        }

        public Builder externalName(String externalName) {
            JodaBeanUtils.notEmpty((String)externalName, (String)"externalName");
            this.externalName = externalName;
            return this;
        }

        public Builder indexName(String indexName) {
            JodaBeanUtils.notEmpty((String)indexName, (String)"indexName");
            this.indexName = indexName;
            return this;
        }

        public Builder type(FloatingRateType type) {
            JodaBeanUtils.notNull((Object)((Object)type), (String)"type");
            this.type = type;
            return this;
        }

        public Builder fixingDateOffsetDays(Integer fixingDateOffsetDays) {
            this.fixingDateOffsetDays = fixingDateOffsetDays;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ImmutableFloatingRateName.Builder{");
            buf.append("externalName").append('=').append(JodaBeanUtils.toString((Object)this.externalName)).append(',').append(' ');
            buf.append("indexName").append('=').append(JodaBeanUtils.toString((Object)this.indexName)).append(',').append(' ');
            buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
            buf.append("fixingDateOffsetDays").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffsetDays));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> externalName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"externalName", ImmutableFloatingRateName.class, String.class);
        private final MetaProperty<String> indexName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"indexName", ImmutableFloatingRateName.class, String.class);
        private final MetaProperty<FloatingRateType> type = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"type", ImmutableFloatingRateName.class, FloatingRateType.class);
        private final MetaProperty<Integer> fixingDateOffsetDays = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDateOffsetDays", ImmutableFloatingRateName.class, Integer.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"externalName", "indexName", "type", "fixingDateOffsetDays"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1386121994: {
                    return this.externalName;
                }
                case -807707011: {
                    return this.indexName;
                }
                case 3575610: {
                    return this.type;
                }
                case -594001179: {
                    return this.fixingDateOffsetDays;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableFloatingRateName> beanType() {
            return ImmutableFloatingRateName.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> externalName() {
            return this.externalName;
        }

        public MetaProperty<String> indexName() {
            return this.indexName;
        }

        public MetaProperty<FloatingRateType> type() {
            return this.type;
        }

        public MetaProperty<Integer> fixingDateOffsetDays() {
            return this.fixingDateOffsetDays;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1386121994: {
                    return ((ImmutableFloatingRateName)bean).getExternalName();
                }
                case -807707011: {
                    return ((ImmutableFloatingRateName)bean).getIndexName();
                }
                case 3575610: {
                    return ((ImmutableFloatingRateName)bean).getType();
                }
                case -594001179: {
                    return ((ImmutableFloatingRateName)bean).fixingDateOffsetDays;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

