/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IndexObservation;
import com.opengamma.strata.basics.index.OvernightIndex;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class OvernightIndexObservation
implements IndexObservation,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final OvernightIndex index;
    @PropertyDefinition(validate="notNull")
    private final LocalDate fixingDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate publicationDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate effectiveDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate maturityDate;
    @PropertyDefinition(validate="notNull")
    private final double yearFraction;
    private static final long serialVersionUID = 1L;

    public static OvernightIndexObservation of(OvernightIndex index, LocalDate fixingDate, ReferenceData refData) {
        LocalDate publicationDate = index.calculatePublicationFromFixing(fixingDate, refData);
        LocalDate effectiveDate = index.calculateEffectiveFromFixing(fixingDate, refData);
        LocalDate maturityDate = index.calculateMaturityFromEffective(effectiveDate, refData);
        return OvernightIndexObservation.builder().index(index).fixingDate(fixingDate).publicationDate(publicationDate).effectiveDate(effectiveDate).maturityDate(maturityDate).yearFraction(index.getDayCount().yearFraction(effectiveDate, maturityDate)).build();
    }

    public Currency getCurrency() {
        return this.index.getCurrency();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            OvernightIndexObservation other = (OvernightIndexObservation)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.fixingDate, (Object)other.fixingDate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + this.index.hashCode();
        return hash * 31 + this.fixingDate.hashCode();
    }

    public String toString() {
        return new StringBuilder(64).append("OvernightIndexObservation[").append(this.index).append(" on ").append(this.fixingDate).append(']').toString();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private OvernightIndexObservation(OvernightIndex index, LocalDate fixingDate, LocalDate publicationDate, LocalDate effectiveDate, LocalDate maturityDate, double yearFraction) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)fixingDate, (String)"fixingDate");
        JodaBeanUtils.notNull((Object)publicationDate, (String)"publicationDate");
        JodaBeanUtils.notNull((Object)effectiveDate, (String)"effectiveDate");
        JodaBeanUtils.notNull((Object)maturityDate, (String)"maturityDate");
        JodaBeanUtils.notNull((Object)yearFraction, (String)"yearFraction");
        this.index = index;
        this.fixingDate = fixingDate;
        this.publicationDate = publicationDate;
        this.effectiveDate = effectiveDate;
        this.maturityDate = maturityDate;
        this.yearFraction = yearFraction;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public OvernightIndex getIndex() {
        return this.index;
    }

    public LocalDate getFixingDate() {
        return this.fixingDate;
    }

    public LocalDate getPublicationDate() {
        return this.publicationDate;
    }

    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public LocalDate getMaturityDate() {
        return this.maturityDate;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<OvernightIndexObservation> {
        private OvernightIndex index;
        private LocalDate fixingDate;
        private LocalDate publicationDate;
        private LocalDate effectiveDate;
        private LocalDate maturityDate;
        private double yearFraction;

        private Builder() {
        }

        private Builder(OvernightIndexObservation beanToCopy) {
            this.index = beanToCopy.getIndex();
            this.fixingDate = beanToCopy.getFixingDate();
            this.publicationDate = beanToCopy.getPublicationDate();
            this.effectiveDate = beanToCopy.getEffectiveDate();
            this.maturityDate = beanToCopy.getMaturityDate();
            this.yearFraction = beanToCopy.getYearFraction();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 1255202043: {
                    return this.fixingDate;
                }
                case 1470566394: {
                    return this.publicationDate;
                }
                case -930389515: {
                    return this.effectiveDate;
                }
                case -414641441: {
                    return this.maturityDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (OvernightIndex)newValue;
                    break;
                }
                case 1255202043: {
                    this.fixingDate = (LocalDate)newValue;
                    break;
                }
                case 1470566394: {
                    this.publicationDate = (LocalDate)newValue;
                    break;
                }
                case -930389515: {
                    this.effectiveDate = (LocalDate)newValue;
                    break;
                }
                case -414641441: {
                    this.maturityDate = (LocalDate)newValue;
                    break;
                }
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public OvernightIndexObservation build() {
            return new OvernightIndexObservation(this.index, this.fixingDate, this.publicationDate, this.effectiveDate, this.maturityDate, this.yearFraction);
        }

        public Builder index(OvernightIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder fixingDate(LocalDate fixingDate) {
            JodaBeanUtils.notNull((Object)fixingDate, (String)"fixingDate");
            this.fixingDate = fixingDate;
            return this;
        }

        public Builder publicationDate(LocalDate publicationDate) {
            JodaBeanUtils.notNull((Object)publicationDate, (String)"publicationDate");
            this.publicationDate = publicationDate;
            return this;
        }

        public Builder effectiveDate(LocalDate effectiveDate) {
            JodaBeanUtils.notNull((Object)effectiveDate, (String)"effectiveDate");
            this.effectiveDate = effectiveDate;
            return this;
        }

        public Builder maturityDate(LocalDate maturityDate) {
            JodaBeanUtils.notNull((Object)maturityDate, (String)"maturityDate");
            this.maturityDate = maturityDate;
            return this;
        }

        public Builder yearFraction(double yearFraction) {
            JodaBeanUtils.notNull((Object)yearFraction, (String)"yearFraction");
            this.yearFraction = yearFraction;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("OvernightIndexObservation.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("fixingDate").append('=').append(JodaBeanUtils.toString((Object)this.fixingDate)).append(',').append(' ');
            buf.append("publicationDate").append('=').append(JodaBeanUtils.toString((Object)this.publicationDate)).append(',').append(' ');
            buf.append("effectiveDate").append('=').append(JodaBeanUtils.toString((Object)this.effectiveDate)).append(',').append(' ');
            buf.append("maturityDate").append('=').append(JodaBeanUtils.toString((Object)this.maturityDate)).append(',').append(' ');
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<OvernightIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", OvernightIndexObservation.class, OvernightIndex.class);
        private final MetaProperty<LocalDate> fixingDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDate", OvernightIndexObservation.class, LocalDate.class);
        private final MetaProperty<LocalDate> publicationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"publicationDate", OvernightIndexObservation.class, LocalDate.class);
        private final MetaProperty<LocalDate> effectiveDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"effectiveDate", OvernightIndexObservation.class, LocalDate.class);
        private final MetaProperty<LocalDate> maturityDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"maturityDate", OvernightIndexObservation.class, LocalDate.class);
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", OvernightIndexObservation.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "fixingDate", "publicationDate", "effectiveDate", "maturityDate", "yearFraction"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 1255202043: {
                    return this.fixingDate;
                }
                case 1470566394: {
                    return this.publicationDate;
                }
                case -930389515: {
                    return this.effectiveDate;
                }
                case -414641441: {
                    return this.maturityDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends OvernightIndexObservation> beanType() {
            return OvernightIndexObservation.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<OvernightIndex> index() {
            return this.index;
        }

        public MetaProperty<LocalDate> fixingDate() {
            return this.fixingDate;
        }

        public MetaProperty<LocalDate> publicationDate() {
            return this.publicationDate;
        }

        public MetaProperty<LocalDate> effectiveDate() {
            return this.effectiveDate;
        }

        public MetaProperty<LocalDate> maturityDate() {
            return this.maturityDate;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((OvernightIndexObservation)bean).getIndex();
                }
                case 1255202043: {
                    return ((OvernightIndexObservation)bean).getFixingDate();
                }
                case 1470566394: {
                    return ((OvernightIndexObservation)bean).getPublicationDate();
                }
                case -930389515: {
                    return ((OvernightIndexObservation)bean).getEffectiveDate();
                }
                case -414641441: {
                    return ((OvernightIndexObservation)bean).getMaturityDate();
                }
                case -1731780257: {
                    return ((OvernightIndexObservation)bean).getYearFraction();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

