/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.schedule;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.NamedLookup;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Locale;

final class DayRollConventions
implements NamedLookup<RollConvention> {
    static final ImmutableMap<String, RollConvention> MAP;

    private DayRollConventions() {
    }

    public ImmutableMap<String, RollConvention> lookupAll() {
        return MAP;
    }

    static {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (RollConvention roll : Dom.CONVENTIONS) {
            mapBuilder.put((Object)roll.getName(), (Object)roll);
            mapBuilder.put((Object)roll.getName().toUpperCase(Locale.ENGLISH), (Object)roll);
        }
        for (RollConvention roll : Dow.CONVENTIONS) {
            mapBuilder.put((Object)roll.getName(), (Object)roll);
            mapBuilder.put((Object)roll.getName().toUpperCase(Locale.ENGLISH), (Object)roll);
        }
        MAP = mapBuilder.build();
    }

    static final class Dow
    implements RollConvention,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String NAMES = "DayMonDayTueDayWedDayThuDayFriDaySatDaySun";
        private static final RollConvention[] CONVENTIONS = new RollConvention[7];
        private final DayOfWeek day;
        private final String name;

        static RollConvention of(DayOfWeek dayOfWeek) {
            ArgChecker.notNull((Object)dayOfWeek, (String)"dayOfWeek");
            return CONVENTIONS[dayOfWeek.getValue() - 1];
        }

        private Object readResolve() {
            return Dow.of(this.day);
        }

        private Dow(DayOfWeek dayOfWeek, String name) {
            this.day = dayOfWeek;
            this.name = name;
        }

        @Override
        public LocalDate adjust(LocalDate date) {
            ArgChecker.notNull((Object)date, (String)"date");
            return date.with(TemporalAdjusters.nextOrSame(this.day));
        }

        @Override
        public boolean matches(LocalDate date) {
            ArgChecker.notNull((Object)date, (String)"date");
            return date.getDayOfWeek() == this.day;
        }

        @Override
        public LocalDate next(LocalDate date, Frequency periodicFrequency) {
            ArgChecker.notNull((Object)date, (String)"date");
            ArgChecker.notNull((Object)periodicFrequency, (String)"periodicFrequency");
            LocalDate calculated = date.plus(periodicFrequency);
            return calculated.with(TemporalAdjusters.nextOrSame(this.day));
        }

        @Override
        public LocalDate previous(LocalDate date, Frequency periodicFrequency) {
            ArgChecker.notNull((Object)date, (String)"date");
            ArgChecker.notNull((Object)periodicFrequency, (String)"periodicFrequency");
            LocalDate calculated = date.minus(periodicFrequency);
            return calculated.with(TemporalAdjusters.previousOrSame(this.day));
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            for (int i = 0; i < 7; ++i) {
                DayOfWeek dow = DayOfWeek.of(i + 1);
                String name = NAMES.substring(i * 6, (i + 1) * 6);
                Dow.CONVENTIONS[i] = new Dow(dow, name);
            }
        }
    }

    static final class Dom
    implements RollConvention,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final RollConvention[] CONVENTIONS = new RollConvention[30];
        private final int day;
        private final String name;

        static RollConvention of(int day) {
            if (day == 31) {
                return RollConventions.EOM;
            }
            if (day < 1 || day > 30) {
                throw new IllegalArgumentException("Invalid day-of-month: " + day);
            }
            return CONVENTIONS[day - 1];
        }

        private Dom(int day) {
            this.day = day;
            this.name = "Day" + day;
        }

        private Object readResolve() {
            return Dom.of(this.day);
        }

        @Override
        public int getDayOfMonth() {
            return this.day;
        }

        @Override
        public LocalDate adjust(LocalDate date) {
            ArgChecker.notNull((Object)date, (String)"date");
            if (this.day >= 29 && date.getMonthValue() == 2) {
                return date.withDayOfMonth(date.lengthOfMonth());
            }
            return date.withDayOfMonth(this.day);
        }

        @Override
        public boolean matches(LocalDate date) {
            ArgChecker.notNull((Object)date, (String)"date");
            return date.getDayOfMonth() == this.day || date.getMonthValue() == 2 && this.day >= date.lengthOfMonth() && date.getDayOfMonth() == date.lengthOfMonth();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            for (int i = 0; i < 30; ++i) {
                Dom.CONVENTIONS[i] = new Dom(i + 1);
            }
        }
    }
}

