/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.value;

import com.opengamma.strata.basics.value.HalfUpRounding;
import com.opengamma.strata.basics.value.NoRounding;
import java.math.BigDecimal;

public interface Rounding {
    public static Rounding none() {
        return NoRounding.INSTANCE;
    }

    public static Rounding ofDecimalPlaces(int decimalPlaces) {
        return HalfUpRounding.ofDecimalPlaces(decimalPlaces);
    }

    public static Rounding ofFractionalDecimalPlaces(int decimalPlaces, int fraction) {
        return HalfUpRounding.ofFractionalDecimalPlaces(decimalPlaces, fraction);
    }

    default public double round(double value) {
        return this.round(BigDecimal.valueOf(value)).doubleValue();
    }

    public BigDecimal round(BigDecimal var1);
}

