/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.value;

import com.opengamma.strata.basics.value.ValueAdjustmentType;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ValueAdjustment
implements ImmutableBean,
Serializable {
    public static final ValueAdjustment NONE = ValueAdjustment.ofDeltaAmount(0.0);
    @PropertyDefinition
    private final double modifyingValue;
    @PropertyDefinition(validate="notNull")
    private final ValueAdjustmentType type;
    private static final long serialVersionUID = 1L;

    public static ValueAdjustment ofReplace(double replacementValue) {
        return new ValueAdjustment(replacementValue, ValueAdjustmentType.REPLACE);
    }

    public static ValueAdjustment ofDeltaAmount(double deltaAmount) {
        return new ValueAdjustment(deltaAmount, ValueAdjustmentType.DELTA_AMOUNT);
    }

    public static ValueAdjustment ofDeltaMultiplier(double deltaMultiplier) {
        return new ValueAdjustment(deltaMultiplier, ValueAdjustmentType.DELTA_MULTIPLIER);
    }

    public static ValueAdjustment ofMultiplier(double multiplier) {
        return new ValueAdjustment(multiplier, ValueAdjustmentType.MULTIPLIER);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ValueAdjustment[result = ");
        switch (this.type) {
            case DELTA_AMOUNT: {
                if (this == NONE) {
                    buf.append("input");
                    break;
                }
                buf.append("input + ").append(this.modifyingValue);
                break;
            }
            case DELTA_MULTIPLIER: {
                buf.append("input + input * ").append(this.modifyingValue);
                break;
            }
            case MULTIPLIER: {
                buf.append("input * ").append(this.modifyingValue);
                break;
            }
            default: {
                buf.append(this.modifyingValue);
            }
        }
        buf.append(']');
        return buf.toString();
    }

    public double adjust(double baseValue) {
        return this.type.adjust(baseValue, this.modifyingValue);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ValueAdjustment(double modifyingValue, ValueAdjustmentType type) {
        JodaBeanUtils.notNull((Object)((Object)type), (String)"type");
        this.modifyingValue = modifyingValue;
        this.type = type;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getModifyingValue() {
        return this.modifyingValue;
    }

    public ValueAdjustmentType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ValueAdjustment other = (ValueAdjustment)obj;
            return JodaBeanUtils.equal((double)this.modifyingValue, (double)other.modifyingValue) && JodaBeanUtils.equal((Object)((Object)this.type), (Object)((Object)other.type));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.modifyingValue);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.type));
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ValueAdjustment> {
        private double modifyingValue;
        private ValueAdjustmentType type;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 503432553: {
                    return this.modifyingValue;
                }
                case 3575610: {
                    return this.type;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 503432553: {
                    this.modifyingValue = (Double)newValue;
                    break;
                }
                case 3575610: {
                    this.type = (ValueAdjustmentType)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ValueAdjustment build() {
            return new ValueAdjustment(this.modifyingValue, this.type);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ValueAdjustment.Builder{");
            buf.append("modifyingValue").append('=').append(JodaBeanUtils.toString((Object)this.modifyingValue)).append(',').append(' ');
            buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type)));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> modifyingValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"modifyingValue", ValueAdjustment.class, Double.TYPE);
        private final MetaProperty<ValueAdjustmentType> type = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"type", ValueAdjustment.class, ValueAdjustmentType.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"modifyingValue", "type"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 503432553: {
                    return this.modifyingValue;
                }
                case 3575610: {
                    return this.type;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ValueAdjustment> builder() {
            return new Builder();
        }

        public Class<? extends ValueAdjustment> beanType() {
            return ValueAdjustment.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> modifyingValue() {
            return this.modifyingValue;
        }

        public MetaProperty<ValueAdjustmentType> type() {
            return this.type;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 503432553: {
                    return ((ValueAdjustment)bean).getModifyingValue();
                }
                case 3575610: {
                    return ((ValueAdjustment)bean).getType();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

