/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.value;

import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum ValueAdjustmentType implements NamedEnum
{
    REPLACE{

        @Override
        public double adjust(double baseValue, double modifyingValue) {
            return modifyingValue;
        }
    }
    ,
    DELTA_AMOUNT{

        @Override
        public double adjust(double baseValue, double modifyingValue) {
            return baseValue + modifyingValue;
        }
    }
    ,
    DELTA_MULTIPLIER{

        @Override
        public double adjust(double baseValue, double modifyingValue) {
            return baseValue + baseValue * modifyingValue;
        }
    }
    ,
    MULTIPLIER{

        @Override
        public double adjust(double baseValue, double modifyingValue) {
            return baseValue * modifyingValue;
        }
    };

    private static final EnumNames<ValueAdjustmentType> NAMES;

    @FromString
    public static ValueAdjustmentType of(String name) {
        return (ValueAdjustmentType)NAMES.parse(name);
    }

    public abstract double adjust(double var1, double var3);

    @ToString
    public String toString() {
        return NAMES.format((Enum)this);
    }

    static {
        NAMES = EnumNames.of(ValueAdjustmentType.class);
    }
}

