/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.expression;

import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;

public class ComparisonResult
implements Mapper<Boolean> {
    private final Boolean result;
    @Deprecated
    private final Boolean emptyOperand;
    private final String error;

    public static ComparisonResult success() {
        return new ComparisonResult(true, false, null);
    }

    @Deprecated
    public static ComparisonResult successEmptyOperand(String error) {
        return new ComparisonResult(true, true, error);
    }

    public static ComparisonResult failure(String error) {
        return new ComparisonResult(false, false, error);
    }

    @Deprecated
    public static ComparisonResult failureEmptyOperand(String error) {
        return new ComparisonResult(false, true, error);
    }

    public static ComparisonResult ofEmpty() {
        return new ComparisonResult(null, null, null);
    }

    public static ComparisonResult ofNullSafe(Mapper<Boolean> result) {
        if (result.getMulti().isEmpty() || result.getMulti().stream().allMatch(Objects::isNull)) {
            return ComparisonResult.ofEmpty();
        }
        List filteredResults = result.getMulti().stream().filter(Objects::nonNull).collect(Collectors.toList());
        return new ComparisonResult(filteredResults.stream().allMatch(r -> r == true), false, null);
    }

    @Deprecated
    public static ComparisonResult of(Mapper<Boolean> result) {
        return new ComparisonResult(result.getMulti().stream().allMatch(r -> r == true), false, null);
    }

    private ComparisonResult(Boolean result, Boolean emptyOperand, String error) {
        this.result = result;
        this.emptyOperand = emptyOperand;
        this.error = error;
    }

    @Override
    public Boolean get() {
        return this.result;
    }

    @Override
    public Boolean getOrDefault(Boolean defaultValue) {
        return this.result == null ? defaultValue : this.result;
    }

    public String getError() {
        return this.error;
    }

    public boolean isEmptyOperand() {
        return this.result == null || this.emptyOperand != null && this.emptyOperand != false;
    }

    public ComparisonResult andNullSafe(ComparisonResult other) {
        return this.andNullSafe(this, other);
    }

    @Deprecated
    public ComparisonResult and(ComparisonResult other) {
        return this.and(this, other);
    }

    @Deprecated
    public ComparisonResult andIgnoreEmptyOperand(ComparisonResult other) {
        return this.combineIgnoreEmptyOperand(other, this::and);
    }

    private ComparisonResult andNullSafe(ComparisonResult r1, ComparisonResult r2) {
        if (r1.isEmptyOperand() && r2.isEmptyOperand()) {
            return ComparisonResult.ofEmpty();
        }
        boolean newResult = r1.getOrDefault(false) != false && r2.getOrDefault(false) != false;
        String newError = "";
        if (!r1.getOrDefault(false).booleanValue()) {
            String r1Value = r1.isEmptyOperand() ? "empty" : r1.getOrDefault(false).toString();
            newError = newError + (r1.error == null ? String.format("left of `and` operation is %s", r1Value) : r1.error);
        }
        if (!r2.getOrDefault(false).booleanValue()) {
            if (!r1.getOrDefault(false).booleanValue()) {
                newError = newError + " and ";
            }
            String r2Value = r2.isEmptyOperand() ? "empty" : r2.getOrDefault(false).toString();
            newError = newError + (r2.error == null ? String.format("right of `and` operation is %s", r2Value) : r2.error);
        }
        return new ComparisonResult(newResult, false, newError);
    }

    @Deprecated
    private ComparisonResult and(ComparisonResult r1, ComparisonResult r2) {
        boolean newResult = r1.result != false && r2.result != false;
        String newError = "";
        if (!r1.result.booleanValue()) {
            newError = newError + r1.error;
        }
        if (!r2.result.booleanValue()) {
            if (!r1.result.booleanValue()) {
                newError = newError + " and ";
            }
            newError = newError + r2.error;
        }
        return new ComparisonResult(newResult, false, newError);
    }

    public ComparisonResult orNullSafe(ComparisonResult other) {
        return this.orNullSafe(this, other);
    }

    @Deprecated
    public ComparisonResult or(ComparisonResult other) {
        return this.or(this, other);
    }

    @Deprecated
    public ComparisonResult orIgnoreEmptyOperand(ComparisonResult other) {
        return this.combineIgnoreEmptyOperand(other, this::or);
    }

    private ComparisonResult orNullSafe(ComparisonResult r1, ComparisonResult r2) {
        if (r1.isEmptyOperand() && r2.isEmptyOperand()) {
            return ComparisonResult.ofEmpty();
        }
        boolean newResult = r1.getOrDefault(false) != false || r2.getOrDefault(false) != false;
        String newError = "";
        newError = newError + r1.error;
        newError = newError + " and ";
        newError = newError + r2.error;
        return new ComparisonResult(newResult, false, newResult ? null : newError);
    }

    @Deprecated
    private ComparisonResult or(ComparisonResult r1, ComparisonResult r2) {
        boolean newResult = r1.result != false || r2.result != false;
        String newError = "";
        newError = newError + r1.error;
        newError = newError + " and ";
        newError = newError + r2.error;
        return new ComparisonResult(newResult, false, newResult ? null : newError);
    }

    @Deprecated
    private ComparisonResult combineIgnoreEmptyOperand(ComparisonResult other, BinaryOperator<ComparisonResult> combineFunc) {
        if (this.emptyOperand.booleanValue() && other.emptyOperand.booleanValue()) {
            return ComparisonResult.failureEmptyOperand(this.error + " and " + other.error);
        }
        if (this.emptyOperand.booleanValue()) {
            return other;
        }
        if (other.emptyOperand.booleanValue()) {
            return this;
        }
        return (ComparisonResult)combineFunc.apply(this, other);
    }

    @Override
    public List<Boolean> getMulti() {
        return Collections.singletonList(this.get());
    }

    @Override
    public Optional<?> getParent() {
        return Optional.empty();
    }

    @Override
    public List<?> getParentMulti() {
        return Collections.emptyList();
    }

    @Override
    public int resultCount() {
        return this.isEmptyOperand() ? 0 : 1;
    }

    public MapperS<Boolean> asMapper() {
        return this.isEmptyOperand() ? MapperS.ofNull() : MapperS.of(this.get());
    }

    @Override
    public List<Mapper.Path> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public List<Mapper.Path> getErrorPaths() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getErrors() {
        return Collections.singletonList(this.getError());
    }
}

