/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class DottedPath
implements Comparable<DottedPath> {
    protected final String[] segments;

    protected DottedPath(String ... segments) {
        this.segments = segments;
    }

    protected DottedPath(DottedPath other) {
        this(other.segments);
    }

    public String first() {
        return this.segments[0];
    }

    public DottedPath tail() {
        return new DottedPath(Arrays.copyOfRange(this.segments, 1, this.segments.length));
    }

    public String last() {
        return this.segments[this.segments.length - 1];
    }

    public static DottedPath of(String ... segments) {
        return new DottedPath(Arrays.copyOf(segments, segments.length));
    }

    public static DottedPath split(String str, String separator) {
        return new DottedPath(StringUtils.splitByWholeSeparator((String)str, (String)separator));
    }

    @JsonCreator
    public static DottedPath splitOnDots(String str) {
        return DottedPath.split(str, ".");
    }

    public static DottedPath splitOnForwardSlashes(String str) {
        return DottedPath.split(str, "/");
    }

    public DottedPath child(String newSegment) {
        String[] newSegments = Arrays.copyOf(this.segments, this.segments.length + 1);
        newSegments[newSegments.length - 1] = newSegment;
        return new DottedPath(newSegments);
    }

    public DottedPath parent() {
        return new DottedPath(Arrays.copyOf(this.segments, this.segments.length - 1));
    }

    public DottedPath concat(DottedPath second) {
        return new DottedPath((String[])ArrayUtils.addAll((Object[])this.segments, (Object[])second.segments));
    }

    public String withSeparator(CharSequence separator) {
        return String.join(separator, this.segments);
    }

    @JsonValue
    public String withDots() {
        return this.withSeparator(".");
    }

    public String withForwardSlashes() {
        return this.withSeparator("/");
    }

    public Path toPath() {
        String[] tail = Arrays.copyOfRange(this.segments, 1, this.segments.length);
        return Paths.get(this.segments[0], tail);
    }

    public Stream<String> stream() {
        return Arrays.stream(this.segments);
    }

    public boolean startsWith(DottedPath other) {
        if (this.segments.length < other.segments.length) {
            return false;
        }
        for (int i = 0; i < other.segments.length; ++i) {
            if (this.segments[i].equals(other.segments[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(DottedPath o) {
        for (int i = 0; i < this.segments.length && i < o.segments.length; ++i) {
            int c = this.segments[i].compareTo(o.segments[i]);
            if (c == 0) continue;
            return c;
        }
        return Integer.compare(this.segments.length, o.segments.length);
    }

    public String toString() {
        return this.withDots();
    }

    public int hashCode() {
        return Arrays.hashCode(this.segments);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DottedPath other = (DottedPath)object;
        return Arrays.equals(this.segments, other.segments);
    }
}

