/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.object;

import com.google.inject.ImplementedBy;
import com.regnosys.rosetta.config.RosettaGeneratorsConfiguration;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaPojoProperty;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import jakarta.inject.Inject;

@ImplementedBy(value=Default.class)
public interface IShouldPrune {
    public boolean shouldBePruned(JavaPojoInterface var1, JavaPojoProperty var2);

    public boolean mayBeEmpty(JavaPojoInterface var1, JavaPojoProperty var2);

    public static class Default
    implements IShouldPrune {
        @Inject
        private JavaTypeTranslator translator;
        @Inject
        private RosettaGeneratorsConfiguration config;

        @Override
        public boolean shouldBePruned(JavaPojoInterface pojo, JavaPojoProperty prop) {
            return !this.isPruningDisabledInConfig(pojo, prop) && this.translator.isRosettaModelObject(prop.getType());
        }

        @Override
        public boolean mayBeEmpty(JavaPojoInterface pojo, JavaPojoProperty prop) {
            return !this.isPruningDisabledInConfig(pojo, prop) && this.translator.isValueRosettaModelObject(prop.getType());
        }

        private boolean isPruningDisabledInConfig(JavaPojoInterface pojo, JavaPojoProperty prop) {
            return this.config.doNotPrune().stream().filter(ref -> ref.getType().equals(pojo.getCanonicalName().withDots())).filter(ref -> ref.getAttribute().equals(prop.getRuneName())).findAny().isPresent();
        }
    }
}

