/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.scoping;

import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.scoping.AbstractJavaScope;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import java.util.Optional;

public class JavaFileScope
extends AbstractJavaScope<AbstractJavaScope<?>> {
    private static final DottedPath JAVA_LANG = DottedPath.of((String[])new String[]{"java", "lang"});
    private final DottedPath packageName;

    public JavaFileScope(String fileName, DottedPath packageName) {
        super("File[" + fileName + "]", null);
        this.packageName = packageName;
    }

    public DottedPath getPackageName() {
        return this.packageName;
    }

    @Override
    public JavaFileScope getFileScope() {
        return this;
    }

    @Override
    public Optional<GeneratedIdentifier> getIdentifier(Object obj) {
        return super.getIdentifier(obj).or(() -> {
            JavaClass c;
            if (obj instanceof JavaClass && JAVA_LANG.equals((Object)(c = (JavaClass)obj).getPackageName()) && !this.isNameExplicitlyTaken(c.getSimpleName())) {
                return Optional.of(this.overwriteIdentifier(c, c.getSimpleName()));
            }
            return Optional.empty();
        });
    }

    @Override
    public boolean isNameTaken(String desiredName) {
        return this.isNameExplicitlyTaken(desiredName) || this.isNameImplicitlyTaken(desiredName);
    }

    private boolean isNameExplicitlyTaken(String desiredName) {
        return super.isNameTaken(desiredName);
    }

    private boolean isNameImplicitlyTaken(String desiredName) {
        try {
            Class.forName(JAVA_LANG.child(desiredName).withDots());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

