/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.google.inject.ImplementedBy;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ComparingFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.DefaultOperation;
import com.regnosys.rosetta.rosetta.expression.DistinctOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.FilterOperation;
import com.regnosys.rosetta.rosetta.expression.FirstOperation;
import com.regnosys.rosetta.rosetta.expression.FlattenOperation;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.JoinOperation;
import com.regnosys.rosetta.rosetta.expression.LastOperation;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.MapOperation;
import com.regnosys.rosetta.rosetta.expression.MaxOperation;
import com.regnosys.rosetta.rosetta.expression.MinOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.ReduceOperation;
import com.regnosys.rosetta.rosetta.expression.ReverseOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaCountOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaSuperCall;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation;
import com.regnosys.rosetta.rosetta.expression.SortOperation;
import com.regnosys.rosetta.rosetta.expression.SumOperation;
import com.regnosys.rosetta.rosetta.expression.SwitchCaseOrDefault;
import com.regnosys.rosetta.rosetta.expression.SwitchOperation;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToEnumOperation;
import com.regnosys.rosetta.rosetta.expression.ToIntOperation;
import com.regnosys.rosetta.rosetta.expression.ToNumberOperation;
import com.regnosys.rosetta.rosetta.expression.ToStringOperation;
import com.regnosys.rosetta.rosetta.expression.ToTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToZonedDateTimeOperation;
import com.regnosys.rosetta.rosetta.expression.WithMetaEntry;
import com.regnosys.rosetta.rosetta.expression.WithMetaOperation;
import com.regnosys.rosetta.rosetta.simple.AssignPathRoot;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.Segment;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RMetaAttribute;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.utils.RosettaExpressionSwitch;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ImplementedBy(value=Impl.class)
public interface ExpectedTypeProvider {
    public static final int INSIGNIFICANT_INDEX = -1;

    public RMetaAnnotatedType getExpectedTypeFromContainer(EObject var1);

    default public RMetaAnnotatedType getExpectedType(EObject owner, EReference reference) {
        return this.getExpectedType(owner, reference, -1);
    }

    public RMetaAnnotatedType getExpectedType(EObject var1, EReference var2, int var3);

    public static class Impl
    implements ExpectedTypeProvider {
        private static final Logger LOGGER = LoggerFactory.getLogger(Impl.class);
        private final RBuiltinTypeService builtins;
        private final RosettaTypeProvider typeProvider;
        private final TypeSystem typeSystem;
        private final ExpectedTypeSwitch expressionSwitch;

        @Inject
        public Impl(RBuiltinTypeService builtins, RosettaTypeProvider typeProvider, TypeSystem typeSystem) {
            this.builtins = builtins;
            this.typeProvider = typeProvider;
            this.typeSystem = typeSystem;
            this.expressionSwitch = new ExpectedTypeSwitch();
        }

        @Override
        public RMetaAnnotatedType getExpectedTypeFromContainer(EObject owner) {
            EObject container = owner.eContainer();
            EReference reference = owner.eContainmentFeature();
            if (container == null || reference == null) {
                return null;
            }
            if (reference.isMany()) {
                int index = ((List)container.eGet((EStructuralFeature)reference)).indexOf(owner);
                return this.getExpectedType(container, reference, index);
            }
            return this.getExpectedType(container, reference);
        }

        @Override
        public RMetaAnnotatedType getExpectedType(EObject owner, EReference reference, int index) {
            if (SimplePackage.Literals.OPERATION__EXPRESSION.equals((Object)reference) && owner instanceof Operation) {
                Operation op = (Operation)owner;
                if (op.getPath() == null) {
                    return this.typeProvider.getRTypeOfSymbol(op.getAssignRoot());
                }
                EList<Segment> path = op.pathAsSegmentList();
                return this.typeProvider.getRTypeOfFeature(((Segment)path.get(path.size() - 1)).getFeature(), null);
            }
            if (ExpressionPackage.Literals.CONSTRUCTOR_KEY_VALUE_PAIR__VALUE.equals((Object)reference) && owner instanceof ConstructorKeyValuePair) {
                ConstructorKeyValuePair pair = (ConstructorKeyValuePair)owner;
                return this.typeProvider.getRTypeOfFeature(pair.getKey(), null);
            }
            if (ExpressionPackage.Literals.WITH_META_ENTRY__VALUE.equals((Object)reference) && owner instanceof WithMetaEntry) {
                WithMetaEntry entry = (WithMetaEntry)owner;
                return this.typeProvider.getRTypeOfFeature(entry.getKey(), (EObject)reference);
            }
            if (owner instanceof RosettaExpression) {
                return this.expressionSwitch.doSwitch((RosettaExpression)owner, reference, index);
            }
            if (ExpressionPackage.Literals.INLINE_FUNCTION__BODY.equals((Object)reference)) {
                EObject operation = owner.eContainer();
                if (operation instanceof ReduceOperation) {
                    return this.getExpectedTypeFromContainer(operation);
                }
                if (operation instanceof FilterOperation) {
                    return this.builtins.BOOLEAN_WITH_NO_META;
                }
                if (operation instanceof MapOperation) {
                    return this.getExpectedTypeFromContainer(operation);
                }
                if (operation instanceof ThenOperation) {
                    return this.getExpectedTypeFromContainer(operation);
                }
                if (operation instanceof ComparingFunctionalOperation) {
                    return this.builtins.BOOLEAN_WITH_NO_META;
                }
                LOGGER.debug("Unexpected functional operation of type " + operation.getClass().getCanonicalName());
            } else if (owner instanceof SwitchCaseOrDefault) {
                SwitchCaseOrDefault switchCase = (SwitchCaseOrDefault)owner;
                if (ExpressionPackage.Literals.SWITCH_CASE_OR_DEFAULT__EXPRESSION.equals((Object)reference)) {
                    return this.getExpectedTypeFromContainer(switchCase.getSwitchOperation());
                }
            }
            return null;
        }

        private class ExpectedTypeSwitch
        extends RosettaExpressionSwitch<RMetaAnnotatedType, Context> {
            private ExpectedTypeSwitch() {
            }

            public RMetaAnnotatedType doSwitch(RosettaExpression expr, EReference reference, int index) {
                return (RMetaAnnotatedType)this.doSwitch(expr, new Context(reference, index));
            }

            private boolean leavesItemTypeUnchanged(RosettaExpression expr) {
                if (expr instanceof RosettaImplicitVariable) {
                    return true;
                }
                if (expr instanceof AsKeyOperation || expr instanceof FilterOperation || expr instanceof FlattenOperation || expr instanceof DistinctOperation || expr instanceof FirstOperation || expr instanceof LastOperation || expr instanceof MaxOperation || expr instanceof MinOperation || expr instanceof ReverseOperation || expr instanceof SortOperation || expr instanceof RosettaOnlyElement) {
                    return this.leavesItemTypeUnchanged(((RosettaUnaryOperation)expr).getArgument());
                }
                if (expr instanceof MapOperation || expr instanceof ThenOperation) {
                    RosettaFunctionalOperation f = (RosettaFunctionalOperation)expr;
                    return this.leavesItemTypeUnchanged(f.getFunction().getBody());
                }
                return false;
            }

            @Override
            protected RMetaAnnotatedType caseConstructorExpression(RosettaConstructorExpression expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseListLiteral(ListLiteral expr, Context context) {
                if (ExpressionPackage.Literals.LIST_LITERAL__ELEMENTS.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseConditionalExpression(RosettaConditionalExpression expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_CONDITIONAL_EXPRESSION__IF.equals((Object)context.reference)) {
                    return Impl.this.builtins.BOOLEAN_WITH_NO_META;
                }
                if (ExpressionPackage.Literals.ROSETTA_CONDITIONAL_EXPRESSION__IFTHEN.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                if (ExpressionPackage.Literals.ROSETTA_CONDITIONAL_EXPRESSION__ELSETHEN.equals((Object)context.reference)) {
                    RMetaAnnotatedType expectedType = Impl.this.getExpectedTypeFromContainer(expr);
                    if (expectedType != null) {
                        return expectedType;
                    }
                    return Impl.this.typeProvider.getRMetaAnnotatedType(expr.getIfthen());
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseFeatureCall(RosettaFeatureCall expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseDeepFeatureCall(RosettaDeepFeatureCall expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseBooleanLiteral(RosettaBooleanLiteral expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseIntLiteral(RosettaIntLiteral expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseNumberLiteral(RosettaNumberLiteral expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseStringLiteral(RosettaStringLiteral expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseOnlyExists(RosettaOnlyExistsExpression expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseImplicitVariable(RosettaImplicitVariable expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseSymbolReference(RosettaSymbolReference expr, Context context) {
                return this.caseCallableReference((Provider<RosettaSymbol>)((Provider)expr::getSymbol), context);
            }

            @Override
            protected RMetaAnnotatedType caseSuperCall(RosettaSuperCall expr, Context context) {
                return this.caseCallableReference((Provider<RosettaSymbol>)((Provider)expr::getSuperFunction), context);
            }

            private RMetaAnnotatedType caseCallableReference(Provider<RosettaSymbol> symbolProvider, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_CALLABLE_REFERENCE__RAW_ARGS.equals((Object)context.reference)) {
                    RosettaSymbol symbol = (RosettaSymbol)symbolProvider.get();
                    if (symbol instanceof Function) {
                        Function fun = (Function)symbol;
                        return Impl.this.typeProvider.getRTypeOfSymbol((AssignPathRoot)fun.getInputs().get(context.index));
                    }
                    if (symbol instanceof RosettaRule) {
                        RosettaRule rule = (RosettaRule)symbol;
                        return RMetaAnnotatedType.withNoMeta(Impl.this.typeSystem.getRuleInputType(rule));
                    }
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseAddOperation(ArithmeticOperation expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseSubtractOperation(ArithmeticOperation expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseMultiplyOperation(ArithmeticOperation expr, Context context) {
                return Impl.this.builtins.UNCONSTRAINED_NUMBER_WITH_NO_META;
            }

            @Override
            protected RMetaAnnotatedType caseDivideOperation(ArithmeticOperation expr, Context context) {
                return Impl.this.builtins.UNCONSTRAINED_STRING_WITH_NO_META;
            }

            @Override
            protected RMetaAnnotatedType caseJoinOperation(JoinOperation expr, Context context) {
                return Impl.this.builtins.UNCONSTRAINED_STRING_WITH_NO_META;
            }

            @Override
            protected RMetaAnnotatedType caseAndOperation(LogicalOperation expr, Context context) {
                return Impl.this.builtins.BOOLEAN_WITH_NO_META;
            }

            @Override
            protected RMetaAnnotatedType caseOrOperation(LogicalOperation expr, Context context) {
                return Impl.this.builtins.BOOLEAN_WITH_NO_META;
            }

            @Override
            protected RMetaAnnotatedType caseLessThanOperation(ComparisonOperation expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseLessThanOrEqualOperation(ComparisonOperation expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseGreaterThanOperation(ComparisonOperation expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseGreaterThanOrEqualOperation(ComparisonOperation expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseEqualsOperation(EqualityOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT.equals((Object)context.reference)) {
                    return Impl.this.typeProvider.getRMetaAnnotatedType(expr.getLeft());
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseNotEqualsOperation(EqualityOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT.equals((Object)context.reference)) {
                    return Impl.this.typeProvider.getRMetaAnnotatedType(expr.getLeft());
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseContainsOperation(RosettaContainsExpression expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT.equals((Object)context.reference)) {
                    return Impl.this.typeProvider.getRMetaAnnotatedType(expr.getLeft());
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseDisjointOperation(RosettaDisjointExpression expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT.equals((Object)context.reference)) {
                    return Impl.this.typeProvider.getRMetaAnnotatedType(expr.getLeft());
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseDefaultOperation(DefaultOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_BINARY_OPERATION__RIGHT.equals((Object)context.reference)) {
                    return Impl.this.typeProvider.getRMetaAnnotatedType(expr.getLeft());
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseAsKeyOperation(AsKeyOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseChoiceOperation(ChoiceOperation expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseOneOfOperation(OneOfOperation expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseAbsentOperation(RosettaAbsentExpression expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseCountOperation(RosettaCountOperation expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseExistsOperation(RosettaExistsExpression expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseDistinctOperation(DistinctOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseFirstOperation(FirstOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseFlattenOperation(FlattenOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseLastOperation(LastOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseReverseOperation(ReverseOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseOnlyElementOperation(RosettaOnlyElement expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseSumOperation(SumOperation expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseToStringOperation(ToStringOperation expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseToNumberOperation(ToNumberOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.builtins.UNCONSTRAINED_STRING_WITH_NO_META;
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseToIntOperation(ToIntOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.builtins.UNCONSTRAINED_STRING_WITH_NO_META;
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseToTimeOperation(ToTimeOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.builtins.UNCONSTRAINED_STRING_WITH_NO_META;
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseToEnumOperation(ToEnumOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.builtins.UNCONSTRAINED_STRING_WITH_NO_META;
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseToDateOperation(ToDateOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.builtins.UNCONSTRAINED_STRING_WITH_NO_META;
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseToDateTimeOperation(ToDateTimeOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.builtins.UNCONSTRAINED_STRING_WITH_NO_META;
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseToZonedDateTimeOperation(ToZonedDateTimeOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.builtins.UNCONSTRAINED_STRING_WITH_NO_META;
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseFilterOperation(FilterOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseMapOperation(MapOperation expr, Context context) {
                InlineFunction f = expr.getFunction();
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference) && f != null && this.leavesItemTypeUnchanged(f.getBody())) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseMaxOperation(MaxOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseMinOperation(MinOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseReduceOperation(ReduceOperation expr, Context context) {
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseSortOperation(SortOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseThenOperation(ThenOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference) && this.leavesItemTypeUnchanged(expr.getFunction().getBody())) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseSwitchOperation(SwitchOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference) && expr.getCases().stream().allMatch(c -> this.leavesItemTypeUnchanged(c.getExpression()))) {
                    return Impl.this.getExpectedTypeFromContainer(expr);
                }
                return null;
            }

            @Override
            protected RMetaAnnotatedType caseWithMetaOperation(WithMetaOperation expr, Context context) {
                if (ExpressionPackage.Literals.ROSETTA_UNARY_OPERATION__ARGUMENT.equals((Object)context.reference)) {
                    Set withMetaKeys = expr.getEntries().stream().map(e -> e.getKey().getName()).collect(Collectors.toSet());
                    RMetaAnnotatedType expectedType = Impl.this.getExpectedTypeFromContainer(expr);
                    List<RMetaAttribute> metaAttributes = expectedType.getMetaAttributes().stream().filter(a -> !withMetaKeys.contains(a.getName())).collect(Collectors.toList());
                    return RMetaAnnotatedType.withMeta(expectedType.getRType(), metaAttributes);
                }
                return null;
            }
        }

        private record Context(EReference reference, int index) {
        }
    }
}

