/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.google.common.collect.Streams;
import com.regnosys.rosetta.rosetta.simple.Choice;
import com.regnosys.rosetta.rosetta.simple.ChoiceOption;
import com.regnosys.rosetta.types.RChoiceOption;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RObject;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.utils.ModelIdProvider;
import com.rosetta.model.lib.ModelSymbolId;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RChoiceType
extends RType
implements RObject {
    private final Choice choice;
    private ModelSymbolId symbolId = null;
    private List<RChoiceOption> ownOptions = null;
    private RDataType dataTypeView = null;
    private final ModelIdProvider modelIdProvider;
    private final RosettaTypeProvider typeProvider;
    private final RObjectFactory rObjectFactory;

    public RChoiceType(Choice choice, ModelIdProvider modelIdProvider, RosettaTypeProvider typeProvider, RObjectFactory rObjectFactory) {
        this.choice = choice;
        this.modelIdProvider = modelIdProvider;
        this.typeProvider = typeProvider;
        this.rObjectFactory = rObjectFactory;
    }

    @Deprecated
    public RDataType asRDataType() {
        if (this.dataTypeView == null) {
            this.dataTypeView = this.rObjectFactory.buildRDataType(this.choice);
        }
        return this.dataTypeView;
    }

    @Override
    public Choice getEObject() {
        return this.choice;
    }

    public ModelSymbolId getSymbolId() {
        if (this.symbolId == null) {
            this.symbolId = this.modelIdProvider.getSymbolId(this.choice);
        }
        return this.symbolId;
    }

    public List<RChoiceOption> getOwnOptions() {
        if (this.ownOptions == null) {
            this.ownOptions = this.choice.getOptions().stream().map(o -> new RChoiceOption((ChoiceOption)o, this, this.typeProvider)).collect(Collectors.toList());
        }
        return this.ownOptions;
    }

    public List<RChoiceOption> getAllOptions() {
        return this.doGetAllOptions(new HashSet<RChoiceType>()).collect(Collectors.toList());
    }

    private Stream<RChoiceOption> doGetAllOptions(Set<RChoiceType> visited) {
        if (visited.add(this)) {
            return this.getOwnOptions().stream().flatMap(o -> {
                if (o.getType().getRType() instanceof RChoiceType) {
                    RChoiceType nested = (RChoiceType)o.getType().getRType();
                    return Streams.concat((Stream[])new Stream[]{Stream.of(o), nested.doGetAllOptions(visited)});
                }
                return Stream.of(o);
            });
        }
        return Stream.empty();
    }

    public int hashCode() {
        return 31 + (this.choice == null ? 0 : this.choice.hashCode());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RChoiceType other = (RChoiceType)object;
        return Objects.equals(this.choice, other.choice);
    }
}

