/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.TypeSystem;
import jakarta.inject.Inject;
import java.util.List;

public class CsvUtil {
    @Inject
    private TypeSystem typeSystem;

    public boolean isTypeTabular(RType type) {
        if (!(type instanceof RDataType)) {
            return false;
        }
        RDataType dataType = (RDataType)type;
        return this.getNonSimpleAttributes(dataType).isEmpty();
    }

    public List<RAttribute> getNonSimpleAttributes(RDataType dataType) {
        return dataType.getAllAttributes().stream().filter(attr -> !this.isSimpleAttribute((RAttribute)attr)).toList();
    }

    private boolean isSimpleAttribute(RAttribute attr) {
        if (attr.isMulti()) {
            return false;
        }
        RType baseType = this.typeSystem.stripFromTypeAliases(attr.getRMetaAnnotatedType().getRType());
        return !(baseType instanceof RDataType) && !(baseType instanceof RChoiceType);
    }
}

