/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.google.common.collect.HashMultimap;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaScope;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import com.regnosys.rosetta.validation.CycleValidationHelper;
import jakarta.inject.Inject;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;

public class FunctionExtensionValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private CycleValidationHelper cycleValidationHelper;

    @Check
    public void checkFunctionExtensionMustBeInScopedFile(Function function) {
        if (function.getSuperFunction() == null) {
            return;
        }
        RosettaModel model = function.getModel();
        if (model != null && model.getScope() == null) {
            this.error("You can only extend a function in a file with a scope", function, (EStructuralFeature)SimplePackage.Literals.FUNCTION__SUPER_FUNCTION);
        }
    }

    @Check
    public void checkFunctionInScopeIsExtendedAtMostOnce(RosettaModel model) {
        RosettaScope scope = model.getScope();
        if (scope == null) {
            return;
        }
        HashMultimap functionExtensions = HashMultimap.create();
        for (RosettaRootElement elem : model.getElements()) {
            Function function;
            if (!(elem instanceof Function) || (function = (Function)elem).getSuperFunction() == null) continue;
            functionExtensions.put((Object)function.getSuperFunction(), (Object)function);
        }
        for (Function function : functionExtensions.keySet()) {
            Collection extensions = functionExtensions.get((Object)function);
            if (extensions.size() <= 1) continue;
            for (Function extension : extensions) {
                this.error("Function '" + function.getName() + "' is extended multiple times in scope " + scope.getName(), extension, (EStructuralFeature)SimplePackage.Literals.FUNCTION__SUPER_FUNCTION);
            }
        }
    }

    @Check
    public void checkCyclicExtensions(Function func) {
        this.cycleValidationHelper.detectCycle(func, Function::getSuperFunction, "extends", pathMsg -> this.error("Cyclic extension: " + pathMsg, func, (EStructuralFeature)SimplePackage.Literals.FUNCTION__SUPER_FUNCTION));
    }

    @Check
    public void checkInputAndOutputsOfFunctionExtensionAreTheSameAsOriginal(Function function) {
        Function original = function.getSuperFunction();
        if (original == null) {
            return;
        }
        if (function.getInputs().size() < original.getInputs().size()) {
            this.error("Function " + function.getName() + " does not define all inputs of the original function " + original.getName(), function, (EStructuralFeature)SimplePackage.Literals.FUNCTION__SUPER_FUNCTION, "RosettaIssueCodes.changedExtendedFunctionParameters", new String[0]);
        }
        for (int i = 0; i < function.getInputs().size(); ++i) {
            if (i >= original.getInputs().size()) {
                this.error("Too many inputs. The original function " + original.getName() + " only defines " + original.getInputs().size() + " inputs.", function, (EStructuralFeature)SimplePackage.Literals.FUNCTION__INPUTS, i, "RosettaIssueCodes.changedExtendedFunctionParameters", new String[0]);
                continue;
            }
            this.checkEqual((Attribute)function.getInputs().get(i), (Attribute)original.getInputs().get(i), "input", function, SimplePackage.Literals.FUNCTION__INPUTS, i);
        }
        this.checkEqual(function.getOutput(), original.getOutput(), "output", function, SimplePackage.Literals.FUNCTION__OUTPUT, -1);
    }

    private void checkEqual(Attribute toCheck, Attribute expected, String description, Function function, EReference feature, int index) {
        if (toCheck == null || expected == null) {
            return;
        }
        if (!EcoreUtil2.equals((EObject)toCheck, (EObject)expected)) {
            this.error(StringUtils.capitalize((String)description) + " " + toCheck.getName() + " does not match the original " + description + " in " + function.getSuperFunction().getName(), function, (EStructuralFeature)feature, index, "RosettaIssueCodes.changedExtendedFunctionParameters", new String[0]);
        }
    }
}

