/*
 * Decompiled with CFR 0.152.
 */
package org.finos.rune.mapper.processor.pruner;

import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.finos.rune.mapper.processor.collector.KeyLookupService;
import org.finos.rune.mapper.processor.pruner.PruningStrategy;

public class ReferencePruningStrategy
implements PruningStrategy {
    private final KeyLookupService keyLookupService;

    public ReferencePruningStrategy(KeyLookupService keyLookupService) {
        this.keyLookupService = keyLookupService;
    }

    @Override
    public void prune(RosettaModelObjectBuilder builder) {
        if (!(builder instanceof ReferenceWithMeta.ReferenceWithMetaBuilder)) {
            return;
        }
        ReferenceWithMeta.ReferenceWithMetaBuilder referenceWithMetaBuilder = (ReferenceWithMeta.ReferenceWithMetaBuilder)builder;
        Class referenceValueType = referenceWithMetaBuilder.getValueType();
        HashSet<Object> referencedObjects = new HashSet<Object>();
        String reference = referenceWithMetaBuilder.getReference() != null ? referenceWithMetaBuilder.getReference().getReference() : null;
        this.addReferencedObject(referencedObjects, reference, KeyLookupService.KeyType.ADDRESS, referenceValueType);
        if (this.isReferencedObjectAlreadyIncluded(referencedObjects, referenceWithMetaBuilder.getExternalReference(), KeyLookupService.KeyType.EXTERNAL_KEY, referenceValueType)) {
            referenceWithMetaBuilder.setExternalReference(null);
        } else {
            this.addReferencedObject(referencedObjects, referenceWithMetaBuilder.getExternalReference(), KeyLookupService.KeyType.EXTERNAL_KEY, referenceValueType);
        }
        if (this.isReferencedObjectAlreadyIncluded(referencedObjects, referenceWithMetaBuilder.getGlobalReference(), KeyLookupService.KeyType.GLOBAL_KEY, referenceValueType)) {
            referenceWithMetaBuilder.setGlobalReference(null);
        }
    }

    private void addReferencedObject(Set<Object> referencedObjects, String reference, KeyLookupService.KeyType keyType, Class<?> valueType) {
        Optional<Object> referencedObject = this.lookupReferencedObject(keyType, valueType, reference);
        referencedObject.ifPresent(referencedObjects::add);
    }

    private boolean isReferencedObjectAlreadyIncluded(Set<Object> referencedObjects, String reference, KeyLookupService.KeyType keyType, Class<?> valueType) {
        Optional<Object> referencedObject = this.lookupReferencedObject(keyType, valueType, reference);
        return referencedObject.isPresent() && referencedObjects.contains(referencedObject.get());
    }

    private Optional<Object> lookupReferencedObject(KeyLookupService.KeyType keyType, Class<?> valueType, String reference) {
        return Optional.ofNullable(reference != null ? this.keyLookupService.getReferencedObject(keyType, valueType, reference) : null);
    }
}

