/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.meta.ProductBaseMeta;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ProductBase", builder=ProductBaseBuilderImpl.class, version="5.30.0")
@RuneDataType(value="ProductBase", model="cdm", builder=ProductBaseBuilderImpl.class, version="5.30.0")
public interface ProductBase
extends RosettaModelObject {
    public static final ProductBaseMeta metaData = new ProductBaseMeta();

    public List<? extends ProductTaxonomy> getProductTaxonomy();

    public List<? extends ReferenceWithMetaProductIdentifier> getProductIdentifier();

    public ProductBase build();

    public ProductBaseBuilder toBuilder();

    public static ProductBaseBuilder builder() {
        return new ProductBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends ProductBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ProductBase> getType() {
        return ProductBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productTaxonomy"), processor, ProductTaxonomy.class, this.getProductTaxonomy(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productIdentifier"), processor, ReferenceWithMetaProductIdentifier.class, this.getProductIdentifier(), new AttributeMeta[0]);
    }

    public static class ProductBaseBuilderImpl
    implements ProductBaseBuilder {
        protected List<ProductTaxonomy.ProductTaxonomyBuilder> productTaxonomy = new ArrayList<ProductTaxonomy.ProductTaxonomyBuilder>();
        protected List<ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder> productIdentifier = new ArrayList<ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder>();

        @Override
        @RosettaAttribute(value="productTaxonomy")
        @RuneAttribute(value="productTaxonomy")
        public List<? extends ProductTaxonomy.ProductTaxonomyBuilder> getProductTaxonomy() {
            return this.productTaxonomy;
        }

        @Override
        public ProductTaxonomy.ProductTaxonomyBuilder getOrCreateProductTaxonomy(int index) {
            if (this.productTaxonomy == null) {
                this.productTaxonomy = new ArrayList<ProductTaxonomy.ProductTaxonomyBuilder>();
            }
            return (ProductTaxonomy.ProductTaxonomyBuilder)this.getIndex(this.productTaxonomy, index, () -> {
                ProductTaxonomy.ProductTaxonomyBuilder newProductTaxonomy = ProductTaxonomy.builder();
                return newProductTaxonomy;
            });
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        @RuneAttribute(value="productIdentifier")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder> getProductIdentifier() {
            return this.productIdentifier;
        }

        @Override
        public ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder getOrCreateProductIdentifier(int index) {
            if (this.productIdentifier == null) {
                this.productIdentifier = new ArrayList<ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder>();
            }
            return (ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder)this.getIndex(this.productIdentifier, index, () -> {
                ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder newProductIdentifier = ReferenceWithMetaProductIdentifier.builder();
                return newProductIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="productTaxonomy")
        @RuneAttribute(value="productTaxonomy")
        public ProductBaseBuilder addProductTaxonomy(ProductTaxonomy _productTaxonomy) {
            if (_productTaxonomy != null) {
                this.productTaxonomy.add(_productTaxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public ProductBaseBuilder addProductTaxonomy(ProductTaxonomy _productTaxonomy, int idx) {
            this.getIndex(this.productTaxonomy, idx, () -> _productTaxonomy.toBuilder());
            return this;
        }

        @Override
        public ProductBaseBuilder addProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            if (productTaxonomys != null) {
                for (ProductTaxonomy productTaxonomy : productTaxonomys) {
                    this.productTaxonomy.add(productTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productTaxonomy")
        public ProductBaseBuilder setProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            this.productTaxonomy = productTaxonomys == null ? new ArrayList<ProductTaxonomy.ProductTaxonomyBuilder>() : (List)productTaxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        @RuneAttribute(value="productIdentifier")
        @RuneScopedAttributeReference
        public ProductBaseBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier _productIdentifier) {
            if (_productIdentifier != null) {
                this.productIdentifier.add(_productIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ProductBaseBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier _productIdentifier, int idx) {
            this.getIndex(this.productIdentifier, idx, () -> _productIdentifier.toBuilder());
            return this;
        }

        @Override
        public ProductBaseBuilder addProductIdentifierValue(ProductIdentifier _productIdentifier) {
            this.getOrCreateProductIdentifier(-1).setValue(_productIdentifier.toBuilder());
            return this;
        }

        @Override
        public ProductBaseBuilder addProductIdentifierValue(ProductIdentifier _productIdentifier, int idx) {
            this.getOrCreateProductIdentifier(idx).setValue(_productIdentifier.toBuilder());
            return this;
        }

        @Override
        public ProductBaseBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ReferenceWithMetaProductIdentifier referenceWithMetaProductIdentifier : productIdentifiers) {
                    this.productIdentifier.add(referenceWithMetaProductIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productIdentifier")
        @RuneScopedAttributeReference
        public ProductBaseBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            this.productIdentifier = productIdentifiers == null ? new ArrayList<ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder>() : (List)productIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ProductBaseBuilder addProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ProductIdentifier productIdentifier : productIdentifiers) {
                    this.addProductIdentifierValue(productIdentifier);
                }
            }
            return this;
        }

        @Override
        public ProductBaseBuilder setProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            this.productIdentifier.clear();
            if (productIdentifiers != null) {
                productIdentifiers.forEach(this::addProductIdentifierValue);
            }
            return this;
        }

        @Override
        public ProductBase build() {
            return new ProductBaseImpl(this);
        }

        @Override
        public ProductBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public ProductBaseBuilder prune() {
            this.productTaxonomy = this.productTaxonomy.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.productIdentifier = this.productIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getProductTaxonomy() != null && this.getProductTaxonomy().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getProductIdentifier() != null && this.getProductIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ProductBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ProductBaseBuilder o = (ProductBaseBuilder)other;
            merger.mergeRosetta(this.getProductTaxonomy(), o.getProductTaxonomy(), this::getOrCreateProductTaxonomy);
            merger.mergeRosetta(this.getProductIdentifier(), o.getProductIdentifier(), this::getOrCreateProductIdentifier);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProductBase _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.productTaxonomy, _that.getProductTaxonomy())) {
                return false;
            }
            return ListEquals.listEquals(this.productIdentifier, _that.getProductIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.productTaxonomy != null ? this.productTaxonomy.hashCode() : 0);
            _result = 31 * _result + (this.productIdentifier != null ? this.productIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProductBaseBuilder {productTaxonomy=" + this.productTaxonomy + ", productIdentifier=" + this.productIdentifier + '}';
        }
    }

    public static interface ProductBaseBuilder
    extends ProductBase,
    RosettaModelObjectBuilder {
        public ProductTaxonomy.ProductTaxonomyBuilder getOrCreateProductTaxonomy(int var1);

        public List<? extends ProductTaxonomy.ProductTaxonomyBuilder> getProductTaxonomy();

        public ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder getOrCreateProductIdentifier(int var1);

        public List<? extends ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder> getProductIdentifier();

        public ProductBaseBuilder addProductTaxonomy(ProductTaxonomy var1);

        public ProductBaseBuilder addProductTaxonomy(ProductTaxonomy var1, int var2);

        public ProductBaseBuilder addProductTaxonomy(List<? extends ProductTaxonomy> var1);

        public ProductBaseBuilder setProductTaxonomy(List<? extends ProductTaxonomy> var1);

        public ProductBaseBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1);

        public ProductBaseBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1, int var2);

        public ProductBaseBuilder addProductIdentifierValue(ProductIdentifier var1);

        public ProductBaseBuilder addProductIdentifierValue(ProductIdentifier var1, int var2);

        public ProductBaseBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        public ProductBaseBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        public ProductBaseBuilder addProductIdentifierValue(List<? extends ProductIdentifier> var1);

        public ProductBaseBuilder setProductIdentifierValue(List<? extends ProductIdentifier> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productTaxonomy"), processor, ProductTaxonomy.ProductTaxonomyBuilder.class, this.getProductTaxonomy(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productIdentifier"), processor, ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder.class, this.getProductIdentifier(), new AttributeMeta[0]);
        }

        public ProductBaseBuilder prune();
    }

    public static class ProductBaseImpl
    implements ProductBase {
        private final List<? extends ProductTaxonomy> productTaxonomy;
        private final List<? extends ReferenceWithMetaProductIdentifier> productIdentifier;

        protected ProductBaseImpl(ProductBaseBuilder builder) {
            this.productTaxonomy = Optional.ofNullable(builder.getProductTaxonomy()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.productIdentifier = Optional.ofNullable(builder.getProductIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="productTaxonomy")
        @RuneAttribute(value="productTaxonomy")
        public List<? extends ProductTaxonomy> getProductTaxonomy() {
            return this.productTaxonomy;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        @RuneAttribute(value="productIdentifier")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaProductIdentifier> getProductIdentifier() {
            return this.productIdentifier;
        }

        @Override
        public ProductBase build() {
            return this;
        }

        @Override
        public ProductBaseBuilder toBuilder() {
            ProductBaseBuilder builder = ProductBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ProductBaseBuilder builder) {
            Optional.ofNullable(this.getProductTaxonomy()).ifPresent(builder::setProductTaxonomy);
            Optional.ofNullable(this.getProductIdentifier()).ifPresent(builder::setProductIdentifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProductBase _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.productTaxonomy, _that.getProductTaxonomy())) {
                return false;
            }
            return ListEquals.listEquals(this.productIdentifier, _that.getProductIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.productTaxonomy != null ? this.productTaxonomy.hashCode() : 0);
            _result = 31 * _result + (this.productIdentifier != null ? this.productIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProductBase {productTaxonomy=" + this.productTaxonomy + ", productIdentifier=" + this.productIdentifier + '}';
        }
    }
}

