/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.processor;

import cdm.legaldocumentation.contract.processor.PartyMappingProcessor;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NovationPartyMappingProcessor
extends PartyMappingProcessor {
    public NovationPartyMappingProcessor(RosettaPath rosettaPath, List<Path> synonymPaths, MappingContext context) {
        super(rosettaPath, synonymPaths, context, new NovationPartyReferenceTranslator(rosettaPath, context.getMappings()));
    }

    private static class NovationPartyReferenceTranslator
    implements Function<String, Optional<String>> {
        private static final Logger LOGGER = LoggerFactory.getLogger(NovationPartyReferenceTranslator.class);
        private final Path modelPath;
        private final List<Mapping> mappings;
        private final boolean isContractFormationAfterTrade;
        private final Map<String, String> cache = new HashMap<String, String>();

        NovationPartyReferenceTranslator(RosettaPath rosettaPath, List<Mapping> mappings) {
            this.modelPath = PathUtils.toPath((RosettaPath)rosettaPath);
            this.mappings = mappings;
            this.isContractFormationAfterTrade = Path.parse((String)"WorkflowStep.businessEvent.primitives.contractFormation.after").nameStartMatches(this.modelPath);
        }

        @Override
        public Optional<String> apply(String party) {
            return this.isContractFormationAfterTrade ? Optional.ofNullable(this.cache.computeIfAbsent(party, this::translate)) : Optional.empty();
        }

        private String translate(String party) {
            Optional<Mapping> transferor = NovationPartyReferenceTranslator.getNonNullMapping(this.mappings, Path.parse((String)"*.novation.transferor.href", (boolean)true));
            Optional<Mapping> transferee = NovationPartyReferenceTranslator.getNonNullMapping(this.mappings, Path.parse((String)"*.novation.transferee.href", (boolean)true));
            if (transferor.isPresent() && transferee.isPresent() && transferor.get().getXmlValue().equals(party)) {
                MappingProcessorUtils.updateMappingSuccess((Mapping)transferee.get(), (Path)this.modelPath);
                MappingProcessorUtils.updateMappingSuccess((Mapping)transferor.get(), (Path)this.modelPath);
                String translatedParty = (String)transferee.get().getXmlValue();
                LOGGER.info("Translated party reference {} to {}", (Object)party, (Object)translatedParty);
                return translatedParty;
            }
            return null;
        }

        private static Optional<Mapping> getNonNullMapping(List<Mapping> mappings, Path synonymPath) {
            return mappings.stream().filter(m -> synonymPath.nameStartMatches(m.getXmlPath(), true)).filter(m -> m.getXmlValue() != null).findFirst();
        }
    }
}

