/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.workflow;

import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.event.common.CorporateActionTypeEnum;
import cdm.event.common.EventIntentEnum;
import cdm.event.common.Instruction;
import cdm.event.workflow.meta.EventInstructionMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="EventInstruction", builder=EventInstructionBuilderImpl.class, version="5.30.0")
@RuneDataType(value="EventInstruction", model="cdm", builder=EventInstructionBuilderImpl.class, version="5.30.0")
public interface EventInstruction
extends RosettaModelObject {
    public static final EventInstructionMeta metaData = new EventInstructionMeta();

    public EventIntentEnum getIntent();

    public CorporateActionTypeEnum getCorporateActionIntent();

    public Date getEventDate();

    public Date getEffectiveDate();

    public IdentifiedList getPackageInformation();

    public List<? extends Instruction> getInstruction();

    public EventInstruction build();

    public EventInstructionBuilder toBuilder();

    public static EventInstructionBuilder builder() {
        return new EventInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends EventInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EventInstruction> getType() {
        return EventInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("intent"), EventIntentEnum.class, (Object)this.getIntent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateActionIntent"), CorporateActionTypeEnum.class, (Object)this.getCorporateActionIntent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageInformation"), processor, IdentifiedList.class, this.getPackageInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instruction"), processor, Instruction.class, this.getInstruction(), new AttributeMeta[0]);
    }

    public static class EventInstructionBuilderImpl
    implements EventInstructionBuilder {
        protected EventIntentEnum intent;
        protected CorporateActionTypeEnum corporateActionIntent;
        protected Date eventDate;
        protected Date effectiveDate;
        protected IdentifiedList.IdentifiedListBuilder packageInformation;
        protected List<Instruction.InstructionBuilder> instruction = new ArrayList<Instruction.InstructionBuilder>();

        @Override
        @RosettaAttribute(value="intent")
        @RuneAttribute(value="intent")
        public EventIntentEnum getIntent() {
            return this.intent;
        }

        @Override
        @RosettaAttribute(value="corporateActionIntent")
        @RuneAttribute(value="corporateActionIntent")
        public CorporateActionTypeEnum getCorporateActionIntent() {
            return this.corporateActionIntent;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        @RuneAttribute(value="packageInformation")
        public IdentifiedList.IdentifiedListBuilder getPackageInformation() {
            return this.packageInformation;
        }

        @Override
        public IdentifiedList.IdentifiedListBuilder getOrCreatePackageInformation() {
            IdentifiedList.IdentifiedListBuilder result = this.packageInformation != null ? this.packageInformation : (this.packageInformation = IdentifiedList.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="instruction")
        @RuneAttribute(value="instruction")
        public List<? extends Instruction.InstructionBuilder> getInstruction() {
            return this.instruction;
        }

        @Override
        public Instruction.InstructionBuilder getOrCreateInstruction(int index) {
            if (this.instruction == null) {
                this.instruction = new ArrayList<Instruction.InstructionBuilder>();
            }
            return (Instruction.InstructionBuilder)this.getIndex(this.instruction, index, () -> {
                Instruction.InstructionBuilder newInstruction = Instruction.builder();
                return newInstruction;
            });
        }

        @Override
        @RosettaAttribute(value="intent")
        @RuneAttribute(value="intent")
        public EventInstructionBuilder setIntent(EventIntentEnum _intent) {
            this.intent = _intent == null ? null : _intent;
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateActionIntent")
        @RuneAttribute(value="corporateActionIntent")
        public EventInstructionBuilder setCorporateActionIntent(CorporateActionTypeEnum _corporateActionIntent) {
            this.corporateActionIntent = _corporateActionIntent == null ? null : _corporateActionIntent;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public EventInstructionBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public EventInstructionBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        @RuneAttribute(value="packageInformation")
        public EventInstructionBuilder setPackageInformation(IdentifiedList _packageInformation) {
            this.packageInformation = _packageInformation == null ? null : _packageInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="instruction")
        @RuneAttribute(value="instruction")
        public EventInstructionBuilder addInstruction(Instruction _instruction) {
            if (_instruction != null) {
                this.instruction.add(_instruction.toBuilder());
            }
            return this;
        }

        @Override
        public EventInstructionBuilder addInstruction(Instruction _instruction, int idx) {
            this.getIndex(this.instruction, idx, () -> _instruction.toBuilder());
            return this;
        }

        @Override
        public EventInstructionBuilder addInstruction(List<? extends Instruction> instructions) {
            if (instructions != null) {
                for (Instruction instruction : instructions) {
                    this.instruction.add(instruction.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instruction")
        public EventInstructionBuilder setInstruction(List<? extends Instruction> instructions) {
            this.instruction = instructions == null ? new ArrayList<Instruction.InstructionBuilder>() : (List)instructions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public EventInstruction build() {
            return new EventInstructionImpl(this);
        }

        @Override
        public EventInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public EventInstructionBuilder prune() {
            if (this.packageInformation != null && !this.packageInformation.prune().hasData()) {
                this.packageInformation = null;
            }
            this.instruction = this.instruction.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getIntent() != null) {
                return true;
            }
            if (this.getCorporateActionIntent() != null) {
                return true;
            }
            if (this.getEventDate() != null) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getPackageInformation() != null && this.getPackageInformation().hasData()) {
                return true;
            }
            return this.getInstruction() != null && this.getInstruction().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public EventInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EventInstructionBuilder o = (EventInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageInformation(), (RosettaModelObjectBuilder)o.getPackageInformation(), this::setPackageInformation);
            merger.mergeRosetta(this.getInstruction(), o.getInstruction(), this::getOrCreateInstruction);
            merger.mergeBasic((Object)this.getIntent(), (Object)o.getIntent(), this::setIntent, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCorporateActionIntent(), (Object)o.getCorporateActionIntent(), this::setCorporateActionIntent, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventDate(), (Object)o.getEventDate(), this::setEventDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EventInstruction _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.intent, (Object)_that.getIntent())) {
                return false;
            }
            if (!Objects.equals((Object)this.corporateActionIntent, (Object)_that.getCorporateActionIntent())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.packageInformation, _that.getPackageInformation())) {
                return false;
            }
            return ListEquals.listEquals(this.instruction, _that.getInstruction());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.intent != null ? ((Object)((Object)this.intent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.corporateActionIntent != null ? ((Object)((Object)this.corporateActionIntent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.packageInformation != null ? this.packageInformation.hashCode() : 0);
            _result = 31 * _result + (this.instruction != null ? this.instruction.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EventInstructionBuilder {intent=" + (Object)((Object)this.intent) + ", corporateActionIntent=" + (Object)((Object)this.corporateActionIntent) + ", eventDate=" + this.eventDate + ", effectiveDate=" + this.effectiveDate + ", packageInformation=" + this.packageInformation + ", instruction=" + this.instruction + '}';
        }
    }

    public static interface EventInstructionBuilder
    extends EventInstruction,
    RosettaModelObjectBuilder {
        public IdentifiedList.IdentifiedListBuilder getOrCreatePackageInformation();

        @Override
        public IdentifiedList.IdentifiedListBuilder getPackageInformation();

        public Instruction.InstructionBuilder getOrCreateInstruction(int var1);

        public List<? extends Instruction.InstructionBuilder> getInstruction();

        public EventInstructionBuilder setIntent(EventIntentEnum var1);

        public EventInstructionBuilder setCorporateActionIntent(CorporateActionTypeEnum var1);

        public EventInstructionBuilder setEventDate(Date var1);

        public EventInstructionBuilder setEffectiveDate(Date var1);

        public EventInstructionBuilder setPackageInformation(IdentifiedList var1);

        public EventInstructionBuilder addInstruction(Instruction var1);

        public EventInstructionBuilder addInstruction(Instruction var1, int var2);

        public EventInstructionBuilder addInstruction(List<? extends Instruction> var1);

        public EventInstructionBuilder setInstruction(List<? extends Instruction> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("intent"), EventIntentEnum.class, (Object)this.getIntent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateActionIntent"), CorporateActionTypeEnum.class, (Object)this.getCorporateActionIntent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageInformation"), processor, IdentifiedList.IdentifiedListBuilder.class, this.getPackageInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instruction"), processor, Instruction.InstructionBuilder.class, this.getInstruction(), new AttributeMeta[0]);
        }

        public EventInstructionBuilder prune();
    }

    public static class EventInstructionImpl
    implements EventInstruction {
        private final EventIntentEnum intent;
        private final CorporateActionTypeEnum corporateActionIntent;
        private final Date eventDate;
        private final Date effectiveDate;
        private final IdentifiedList packageInformation;
        private final List<? extends Instruction> instruction;

        protected EventInstructionImpl(EventInstructionBuilder builder) {
            this.intent = builder.getIntent();
            this.corporateActionIntent = builder.getCorporateActionIntent();
            this.eventDate = builder.getEventDate();
            this.effectiveDate = builder.getEffectiveDate();
            this.packageInformation = Optional.ofNullable(builder.getPackageInformation()).map(f -> f.build()).orElse(null);
            this.instruction = Optional.ofNullable(builder.getInstruction()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="intent")
        @RuneAttribute(value="intent")
        public EventIntentEnum getIntent() {
            return this.intent;
        }

        @Override
        @RosettaAttribute(value="corporateActionIntent")
        @RuneAttribute(value="corporateActionIntent")
        public CorporateActionTypeEnum getCorporateActionIntent() {
            return this.corporateActionIntent;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        @RuneAttribute(value="packageInformation")
        public IdentifiedList getPackageInformation() {
            return this.packageInformation;
        }

        @Override
        @RosettaAttribute(value="instruction")
        @RuneAttribute(value="instruction")
        public List<? extends Instruction> getInstruction() {
            return this.instruction;
        }

        @Override
        public EventInstruction build() {
            return this;
        }

        @Override
        public EventInstructionBuilder toBuilder() {
            EventInstructionBuilder builder = EventInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EventInstructionBuilder builder) {
            Optional.ofNullable(this.getIntent()).ifPresent(builder::setIntent);
            Optional.ofNullable(this.getCorporateActionIntent()).ifPresent(builder::setCorporateActionIntent);
            Optional.ofNullable(this.getEventDate()).ifPresent(builder::setEventDate);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getPackageInformation()).ifPresent(builder::setPackageInformation);
            Optional.ofNullable(this.getInstruction()).ifPresent(builder::setInstruction);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EventInstruction _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.intent, (Object)_that.getIntent())) {
                return false;
            }
            if (!Objects.equals((Object)this.corporateActionIntent, (Object)_that.getCorporateActionIntent())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.packageInformation, _that.getPackageInformation())) {
                return false;
            }
            return ListEquals.listEquals(this.instruction, _that.getInstruction());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.intent != null ? ((Object)((Object)this.intent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.corporateActionIntent != null ? ((Object)((Object)this.corporateActionIntent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.packageInformation != null ? this.packageInformation.hashCode() : 0);
            _result = 31 * _result + (this.instruction != null ? this.instruction.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EventInstruction {intent=" + (Object)((Object)this.intent) + ", corporateActionIntent=" + (Object)((Object)this.corporateActionIntent) + ", eventDate=" + this.eventDate + ", effectiveDate=" + this.effectiveDate + ", packageInformation=" + this.packageInformation + ", instruction=" + this.instruction + '}';
        }
    }
}

