/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.product.asset.BasketReferenceInformation;
import cdm.product.asset.CreditIndexReferenceInformation;
import cdm.product.asset.ReferenceInformation;
import cdm.product.asset.meta.GeneralTermsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="GeneralTerms", builder=GeneralTermsBuilderImpl.class, version="5.30.0")
@RuneDataType(value="GeneralTerms", model="cdm", builder=GeneralTermsBuilderImpl.class, version="5.30.0")
public interface GeneralTerms
extends RosettaModelObject {
    public static final GeneralTermsMeta metaData = new GeneralTermsMeta();

    public ReferenceInformation getReferenceInformation();

    public CreditIndexReferenceInformation getIndexReferenceInformation();

    public BasketReferenceInformation getBasketReferenceInformation();

    public List<? extends FieldWithMetaString> getAdditionalTerm();

    public Boolean getSubstitution();

    public Boolean getModifiedEquityDelivery();

    public GeneralTerms build();

    public GeneralTermsBuilder toBuilder();

    public static GeneralTermsBuilder builder() {
        return new GeneralTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends GeneralTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends GeneralTerms> getType() {
        return GeneralTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("referenceInformation"), processor, ReferenceInformation.class, this.getReferenceInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexReferenceInformation"), processor, CreditIndexReferenceInformation.class, this.getIndexReferenceInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketReferenceInformation"), processor, BasketReferenceInformation.class, this.getBasketReferenceInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalTerm"), processor, FieldWithMetaString.class, this.getAdditionalTerm(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("substitution"), Boolean.class, (Object)this.getSubstitution(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("modifiedEquityDelivery"), Boolean.class, (Object)this.getModifiedEquityDelivery(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class GeneralTermsBuilderImpl
    implements GeneralTermsBuilder {
        protected ReferenceInformation.ReferenceInformationBuilder referenceInformation;
        protected CreditIndexReferenceInformation.CreditIndexReferenceInformationBuilder indexReferenceInformation;
        protected BasketReferenceInformation.BasketReferenceInformationBuilder basketReferenceInformation;
        protected List<FieldWithMetaString.FieldWithMetaStringBuilder> additionalTerm = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
        protected Boolean substitution;
        protected Boolean modifiedEquityDelivery;

        @Override
        @RosettaAttribute(value="referenceInformation")
        @RuneAttribute(value="referenceInformation")
        public ReferenceInformation.ReferenceInformationBuilder getReferenceInformation() {
            return this.referenceInformation;
        }

        @Override
        public ReferenceInformation.ReferenceInformationBuilder getOrCreateReferenceInformation() {
            ReferenceInformation.ReferenceInformationBuilder result = this.referenceInformation != null ? this.referenceInformation : (this.referenceInformation = ReferenceInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="indexReferenceInformation")
        @RuneAttribute(value="indexReferenceInformation")
        public CreditIndexReferenceInformation.CreditIndexReferenceInformationBuilder getIndexReferenceInformation() {
            return this.indexReferenceInformation;
        }

        @Override
        public CreditIndexReferenceInformation.CreditIndexReferenceInformationBuilder getOrCreateIndexReferenceInformation() {
            CreditIndexReferenceInformation.CreditIndexReferenceInformationBuilder result = this.indexReferenceInformation != null ? this.indexReferenceInformation : (this.indexReferenceInformation = CreditIndexReferenceInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="basketReferenceInformation")
        @RuneAttribute(value="basketReferenceInformation")
        public BasketReferenceInformation.BasketReferenceInformationBuilder getBasketReferenceInformation() {
            return this.basketReferenceInformation;
        }

        @Override
        public BasketReferenceInformation.BasketReferenceInformationBuilder getOrCreateBasketReferenceInformation() {
            BasketReferenceInformation.BasketReferenceInformationBuilder result = this.basketReferenceInformation != null ? this.basketReferenceInformation : (this.basketReferenceInformation = BasketReferenceInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalTerm")
        @RuneAttribute(value="additionalTerm")
        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getAdditionalTerm() {
            return this.additionalTerm;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateAdditionalTerm(int index) {
            if (this.additionalTerm == null) {
                this.additionalTerm = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
            }
            return (FieldWithMetaString.FieldWithMetaStringBuilder)this.getIndex(this.additionalTerm, index, () -> {
                FieldWithMetaString.FieldWithMetaStringBuilder newAdditionalTerm = FieldWithMetaString.builder();
                return newAdditionalTerm;
            });
        }

        @Override
        @RosettaAttribute(value="substitution")
        @RuneAttribute(value="substitution")
        public Boolean getSubstitution() {
            return this.substitution;
        }

        @Override
        @RosettaAttribute(value="modifiedEquityDelivery")
        @RuneAttribute(value="modifiedEquityDelivery")
        public Boolean getModifiedEquityDelivery() {
            return this.modifiedEquityDelivery;
        }

        @Override
        @RosettaAttribute(value="referenceInformation")
        @RuneAttribute(value="referenceInformation")
        public GeneralTermsBuilder setReferenceInformation(ReferenceInformation _referenceInformation) {
            this.referenceInformation = _referenceInformation == null ? null : _referenceInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="indexReferenceInformation")
        @RuneAttribute(value="indexReferenceInformation")
        public GeneralTermsBuilder setIndexReferenceInformation(CreditIndexReferenceInformation _indexReferenceInformation) {
            this.indexReferenceInformation = _indexReferenceInformation == null ? null : _indexReferenceInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="basketReferenceInformation")
        @RuneAttribute(value="basketReferenceInformation")
        public GeneralTermsBuilder setBasketReferenceInformation(BasketReferenceInformation _basketReferenceInformation) {
            this.basketReferenceInformation = _basketReferenceInformation == null ? null : _basketReferenceInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalTerm")
        @RuneAttribute(value="additionalTerm")
        public GeneralTermsBuilder addAdditionalTerm(FieldWithMetaString _additionalTerm) {
            if (_additionalTerm != null) {
                this.additionalTerm.add(_additionalTerm.toBuilder());
            }
            return this;
        }

        @Override
        public GeneralTermsBuilder addAdditionalTerm(FieldWithMetaString _additionalTerm, int idx) {
            this.getIndex(this.additionalTerm, idx, () -> _additionalTerm.toBuilder());
            return this;
        }

        @Override
        public GeneralTermsBuilder addAdditionalTermValue(String _additionalTerm) {
            this.getOrCreateAdditionalTerm(-1).setValue(_additionalTerm);
            return this;
        }

        @Override
        public GeneralTermsBuilder addAdditionalTermValue(String _additionalTerm, int idx) {
            this.getOrCreateAdditionalTerm(idx).setValue(_additionalTerm);
            return this;
        }

        @Override
        public GeneralTermsBuilder addAdditionalTerm(List<? extends FieldWithMetaString> additionalTerms) {
            if (additionalTerms != null) {
                for (FieldWithMetaString fieldWithMetaString : additionalTerms) {
                    this.additionalTerm.add(fieldWithMetaString.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalTerm")
        public GeneralTermsBuilder setAdditionalTerm(List<? extends FieldWithMetaString> additionalTerms) {
            this.additionalTerm = additionalTerms == null ? new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>() : (List)additionalTerms.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public GeneralTermsBuilder addAdditionalTermValue(List<? extends String> additionalTerms) {
            if (additionalTerms != null) {
                for (String string : additionalTerms) {
                    this.addAdditionalTermValue(string);
                }
            }
            return this;
        }

        @Override
        public GeneralTermsBuilder setAdditionalTermValue(List<? extends String> additionalTerms) {
            this.additionalTerm.clear();
            if (additionalTerms != null) {
                additionalTerms.forEach(this::addAdditionalTermValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="substitution")
        @RuneAttribute(value="substitution")
        public GeneralTermsBuilder setSubstitution(Boolean _substitution) {
            this.substitution = _substitution == null ? null : _substitution;
            return this;
        }

        @Override
        @RosettaAttribute(value="modifiedEquityDelivery")
        @RuneAttribute(value="modifiedEquityDelivery")
        public GeneralTermsBuilder setModifiedEquityDelivery(Boolean _modifiedEquityDelivery) {
            this.modifiedEquityDelivery = _modifiedEquityDelivery == null ? null : _modifiedEquityDelivery;
            return this;
        }

        @Override
        public GeneralTerms build() {
            return new GeneralTermsImpl(this);
        }

        @Override
        public GeneralTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public GeneralTermsBuilder prune() {
            if (this.referenceInformation != null && !this.referenceInformation.prune().hasData()) {
                this.referenceInformation = null;
            }
            if (this.indexReferenceInformation != null && !this.indexReferenceInformation.prune().hasData()) {
                this.indexReferenceInformation = null;
            }
            if (this.basketReferenceInformation != null && !this.basketReferenceInformation.prune().hasData()) {
                this.basketReferenceInformation = null;
            }
            this.additionalTerm = this.additionalTerm.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getReferenceInformation() != null && this.getReferenceInformation().hasData()) {
                return true;
            }
            if (this.getIndexReferenceInformation() != null && this.getIndexReferenceInformation().hasData()) {
                return true;
            }
            if (this.getBasketReferenceInformation() != null && this.getBasketReferenceInformation().hasData()) {
                return true;
            }
            if (this.getAdditionalTerm() != null && !this.getAdditionalTerm().isEmpty()) {
                return true;
            }
            if (this.getSubstitution() != null) {
                return true;
            }
            return this.getModifiedEquityDelivery() != null;
        }

        public GeneralTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            GeneralTermsBuilder o = (GeneralTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceInformation(), (RosettaModelObjectBuilder)o.getReferenceInformation(), this::setReferenceInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndexReferenceInformation(), (RosettaModelObjectBuilder)o.getIndexReferenceInformation(), this::setIndexReferenceInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasketReferenceInformation(), (RosettaModelObjectBuilder)o.getBasketReferenceInformation(), this::setBasketReferenceInformation);
            merger.mergeRosetta(this.getAdditionalTerm(), o.getAdditionalTerm(), this::getOrCreateAdditionalTerm);
            merger.mergeBasic((Object)this.getSubstitution(), (Object)o.getSubstitution(), this::setSubstitution, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getModifiedEquityDelivery(), (Object)o.getModifiedEquityDelivery(), this::setModifiedEquityDelivery, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            GeneralTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.referenceInformation, _that.getReferenceInformation())) {
                return false;
            }
            if (!Objects.equals(this.indexReferenceInformation, _that.getIndexReferenceInformation())) {
                return false;
            }
            if (!Objects.equals(this.basketReferenceInformation, _that.getBasketReferenceInformation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalTerm, _that.getAdditionalTerm())) {
                return false;
            }
            if (!Objects.equals(this.substitution, _that.getSubstitution())) {
                return false;
            }
            return Objects.equals(this.modifiedEquityDelivery, _that.getModifiedEquityDelivery());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.referenceInformation != null ? this.referenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.indexReferenceInformation != null ? this.indexReferenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.basketReferenceInformation != null ? this.basketReferenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.additionalTerm != null ? this.additionalTerm.hashCode() : 0);
            _result = 31 * _result + (this.substitution != null ? this.substitution.hashCode() : 0);
            _result = 31 * _result + (this.modifiedEquityDelivery != null ? this.modifiedEquityDelivery.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "GeneralTermsBuilder {referenceInformation=" + this.referenceInformation + ", indexReferenceInformation=" + this.indexReferenceInformation + ", basketReferenceInformation=" + this.basketReferenceInformation + ", additionalTerm=" + this.additionalTerm + ", substitution=" + this.substitution + ", modifiedEquityDelivery=" + this.modifiedEquityDelivery + '}';
        }
    }

    public static interface GeneralTermsBuilder
    extends GeneralTerms,
    RosettaModelObjectBuilder {
        public ReferenceInformation.ReferenceInformationBuilder getOrCreateReferenceInformation();

        @Override
        public ReferenceInformation.ReferenceInformationBuilder getReferenceInformation();

        public CreditIndexReferenceInformation.CreditIndexReferenceInformationBuilder getOrCreateIndexReferenceInformation();

        @Override
        public CreditIndexReferenceInformation.CreditIndexReferenceInformationBuilder getIndexReferenceInformation();

        public BasketReferenceInformation.BasketReferenceInformationBuilder getOrCreateBasketReferenceInformation();

        @Override
        public BasketReferenceInformation.BasketReferenceInformationBuilder getBasketReferenceInformation();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateAdditionalTerm(int var1);

        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getAdditionalTerm();

        public GeneralTermsBuilder setReferenceInformation(ReferenceInformation var1);

        public GeneralTermsBuilder setIndexReferenceInformation(CreditIndexReferenceInformation var1);

        public GeneralTermsBuilder setBasketReferenceInformation(BasketReferenceInformation var1);

        public GeneralTermsBuilder addAdditionalTerm(FieldWithMetaString var1);

        public GeneralTermsBuilder addAdditionalTerm(FieldWithMetaString var1, int var2);

        public GeneralTermsBuilder addAdditionalTermValue(String var1);

        public GeneralTermsBuilder addAdditionalTermValue(String var1, int var2);

        public GeneralTermsBuilder addAdditionalTerm(List<? extends FieldWithMetaString> var1);

        public GeneralTermsBuilder setAdditionalTerm(List<? extends FieldWithMetaString> var1);

        public GeneralTermsBuilder addAdditionalTermValue(List<? extends String> var1);

        public GeneralTermsBuilder setAdditionalTermValue(List<? extends String> var1);

        public GeneralTermsBuilder setSubstitution(Boolean var1);

        public GeneralTermsBuilder setModifiedEquityDelivery(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("referenceInformation"), processor, ReferenceInformation.ReferenceInformationBuilder.class, this.getReferenceInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexReferenceInformation"), processor, CreditIndexReferenceInformation.CreditIndexReferenceInformationBuilder.class, this.getIndexReferenceInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketReferenceInformation"), processor, BasketReferenceInformation.BasketReferenceInformationBuilder.class, this.getBasketReferenceInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalTerm"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getAdditionalTerm(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("substitution"), Boolean.class, (Object)this.getSubstitution(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("modifiedEquityDelivery"), Boolean.class, (Object)this.getModifiedEquityDelivery(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public GeneralTermsBuilder prune();
    }

    public static class GeneralTermsImpl
    implements GeneralTerms {
        private final ReferenceInformation referenceInformation;
        private final CreditIndexReferenceInformation indexReferenceInformation;
        private final BasketReferenceInformation basketReferenceInformation;
        private final List<? extends FieldWithMetaString> additionalTerm;
        private final Boolean substitution;
        private final Boolean modifiedEquityDelivery;

        protected GeneralTermsImpl(GeneralTermsBuilder builder) {
            this.referenceInformation = Optional.ofNullable(builder.getReferenceInformation()).map(f -> f.build()).orElse(null);
            this.indexReferenceInformation = Optional.ofNullable(builder.getIndexReferenceInformation()).map(f -> f.build()).orElse(null);
            this.basketReferenceInformation = Optional.ofNullable(builder.getBasketReferenceInformation()).map(f -> f.build()).orElse(null);
            this.additionalTerm = Optional.ofNullable(builder.getAdditionalTerm()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.substitution = builder.getSubstitution();
            this.modifiedEquityDelivery = builder.getModifiedEquityDelivery();
        }

        @Override
        @RosettaAttribute(value="referenceInformation")
        @RuneAttribute(value="referenceInformation")
        public ReferenceInformation getReferenceInformation() {
            return this.referenceInformation;
        }

        @Override
        @RosettaAttribute(value="indexReferenceInformation")
        @RuneAttribute(value="indexReferenceInformation")
        public CreditIndexReferenceInformation getIndexReferenceInformation() {
            return this.indexReferenceInformation;
        }

        @Override
        @RosettaAttribute(value="basketReferenceInformation")
        @RuneAttribute(value="basketReferenceInformation")
        public BasketReferenceInformation getBasketReferenceInformation() {
            return this.basketReferenceInformation;
        }

        @Override
        @RosettaAttribute(value="additionalTerm")
        @RuneAttribute(value="additionalTerm")
        public List<? extends FieldWithMetaString> getAdditionalTerm() {
            return this.additionalTerm;
        }

        @Override
        @RosettaAttribute(value="substitution")
        @RuneAttribute(value="substitution")
        public Boolean getSubstitution() {
            return this.substitution;
        }

        @Override
        @RosettaAttribute(value="modifiedEquityDelivery")
        @RuneAttribute(value="modifiedEquityDelivery")
        public Boolean getModifiedEquityDelivery() {
            return this.modifiedEquityDelivery;
        }

        @Override
        public GeneralTerms build() {
            return this;
        }

        @Override
        public GeneralTermsBuilder toBuilder() {
            GeneralTermsBuilder builder = GeneralTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(GeneralTermsBuilder builder) {
            Optional.ofNullable(this.getReferenceInformation()).ifPresent(builder::setReferenceInformation);
            Optional.ofNullable(this.getIndexReferenceInformation()).ifPresent(builder::setIndexReferenceInformation);
            Optional.ofNullable(this.getBasketReferenceInformation()).ifPresent(builder::setBasketReferenceInformation);
            Optional.ofNullable(this.getAdditionalTerm()).ifPresent(builder::setAdditionalTerm);
            Optional.ofNullable(this.getSubstitution()).ifPresent(builder::setSubstitution);
            Optional.ofNullable(this.getModifiedEquityDelivery()).ifPresent(builder::setModifiedEquityDelivery);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            GeneralTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.referenceInformation, _that.getReferenceInformation())) {
                return false;
            }
            if (!Objects.equals(this.indexReferenceInformation, _that.getIndexReferenceInformation())) {
                return false;
            }
            if (!Objects.equals(this.basketReferenceInformation, _that.getBasketReferenceInformation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalTerm, _that.getAdditionalTerm())) {
                return false;
            }
            if (!Objects.equals(this.substitution, _that.getSubstitution())) {
                return false;
            }
            return Objects.equals(this.modifiedEquityDelivery, _that.getModifiedEquityDelivery());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.referenceInformation != null ? this.referenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.indexReferenceInformation != null ? this.indexReferenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.basketReferenceInformation != null ? this.basketReferenceInformation.hashCode() : 0);
            _result = 31 * _result + (this.additionalTerm != null ? this.additionalTerm.hashCode() : 0);
            _result = 31 * _result + (this.substitution != null ? this.substitution.hashCode() : 0);
            _result = 31 * _result + (this.modifiedEquityDelivery != null ? this.modifiedEquityDelivery.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "GeneralTerms {referenceInformation=" + this.referenceInformation + ", indexReferenceInformation=" + this.indexReferenceInformation + ", basketReferenceInformation=" + this.basketReferenceInformation + ", additionalTerm=" + this.additionalTerm + ", substitution=" + this.substitution + ", modifiedEquityDelivery=" + this.modifiedEquityDelivery + '}';
        }
    }
}

