/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.observable.asset.fro.functions.IndexValueObservation;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FloatingRate;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.asset.floatingrate.functions.DetermineFixingDate;
import cdm.product.asset.floatingrate.functions.DetermineResetDate;
import cdm.product.common.schedule.CalculationPeriodBase;
import cdm.product.common.schedule.ResetDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=EvaluateScreenRateDefault.class)
public abstract class EvaluateScreenRate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected DetermineFixingDate determineFixingDate;
    @Inject
    protected DetermineResetDate determineResetDate;
    @Inject
    protected IndexValueObservation indexValueObservation;

    public FloatingRateSettingDetails evaluate(FloatingRate rateDef, ResetDates resetDates, CalculationPeriodBase calculationPeriod) {
        FloatingRateSettingDetails details;
        FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder detailsBuilder = this.doEvaluate(rateDef, resetDates, calculationPeriod);
        if (detailsBuilder == null) {
            details = null;
        } else {
            details = detailsBuilder.build();
            this.objectValidator.validate(FloatingRateSettingDetails.class, (RosettaModelObject)details);
        }
        return details;
    }

    protected abstract FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(FloatingRate var1, ResetDates var2, CalculationPeriodBase var3);

    protected abstract MapperS<Date> resetDate(FloatingRate var1, ResetDates var2, CalculationPeriodBase var3);

    protected abstract MapperS<Date> fixingDate(FloatingRate var1, ResetDates var2, CalculationPeriodBase var3);

    protected abstract MapperS<BigDecimal> observedRate(FloatingRate var1, ResetDates var2, CalculationPeriodBase var3);

    public static class EvaluateScreenRateDefault
    extends EvaluateScreenRate {
        @Override
        protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(FloatingRate rateDef, ResetDates resetDates, CalculationPeriodBase calculationPeriod) {
            FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder details = FloatingRateSettingDetails.builder();
            return this.assignOutput(details, rateDef, resetDates, calculationPeriod);
        }

        protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder assignOutput(FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder details, FloatingRate rateDef, ResetDates resetDates, CalculationPeriodBase calculationPeriod) {
            details.setResetDate((Date)this.resetDate(rateDef, resetDates, calculationPeriod).get());
            details.setObservationDate((Date)this.fixingDate(rateDef, resetDates, calculationPeriod).get());
            details.setFloatingRate((BigDecimal)this.observedRate(rateDef, resetDates, calculationPeriod).get());
            return Optional.ofNullable(details).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<Date> resetDate(FloatingRate rateDef, ResetDates resetDates, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.determineResetDate.evaluate(resetDates, calculationPeriod));
        }

        @Override
        protected MapperS<Date> fixingDate(FloatingRate rateDef, ResetDates resetDates, CalculationPeriodBase calculationPeriod) {
            return MapperS.of((Object)this.determineFixingDate.evaluate(resetDates, (Date)this.resetDate(rateDef, resetDates, calculationPeriod).get()));
        }

        @Override
        protected MapperS<BigDecimal> observedRate(FloatingRate rateDef, ResetDates resetDates, CalculationPeriodBase calculationPeriod) {
            ReferenceWithMetaFloatingRateOption referenceWithMetaFloatingRateOption = (ReferenceWithMetaFloatingRateOption)MapperS.of((Object)rateDef).map("getRateOption", floatingRate -> floatingRate.getRateOption()).get();
            return MapperS.of((Object)this.indexValueObservation.evaluate((Date)this.fixingDate(rateDef, resetDates, calculationPeriod).get(), referenceWithMetaFloatingRateOption == null ? null : referenceWithMetaFloatingRateOption.getValue()));
        }
    }
}

