/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.base.math.DatedValue;
import cdm.base.math.Schedule;
import cdm.product.common.schedule.meta.AmountScheduleMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AmountSchedule", builder=AmountScheduleBuilderImpl.class, version="5.30.0")
@RuneDataType(value="AmountSchedule", model="cdm", builder=AmountScheduleBuilderImpl.class, version="5.30.0")
public interface AmountSchedule
extends Schedule {
    public static final AmountScheduleMeta metaData = new AmountScheduleMeta();

    public List<? extends FieldWithMetaString> getCurrency();

    @Override
    public AmountSchedule build();

    @Override
    public AmountScheduleBuilder toBuilder();

    public static AmountScheduleBuilder builder() {
        return new AmountScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends AmountSchedule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AmountSchedule> getType() {
        return AmountSchedule.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("datedValue"), processor, DatedValue.class, this.getDatedValue(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, FieldWithMetaString.class, this.getCurrency(), new AttributeMeta[0]);
    }

    public static class AmountScheduleBuilderImpl
    extends Schedule.ScheduleBuilderImpl
    implements AmountScheduleBuilder {
        protected List<FieldWithMetaString.FieldWithMetaStringBuilder> currency = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getCurrency() {
            return this.currency;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCurrency(int index) {
            if (this.currency == null) {
                this.currency = new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>();
            }
            return (FieldWithMetaString.FieldWithMetaStringBuilder)this.getIndex(this.currency, index, () -> {
                FieldWithMetaString.FieldWithMetaStringBuilder newCurrency = FieldWithMetaString.builder();
                return newCurrency;
            });
        }

        @Override
        @RosettaAttribute(value="value", isRequired=true)
        @RuneAttribute(value="value", isRequired=true)
        public AmountScheduleBuilder setValue(BigDecimal _value) {
            this.value = _value == null ? null : _value;
            return this;
        }

        @Override
        @RosettaAttribute(value="datedValue")
        @RuneAttribute(value="datedValue")
        public AmountScheduleBuilder addDatedValue(DatedValue _datedValue) {
            if (_datedValue != null) {
                this.datedValue.add(_datedValue.toBuilder());
            }
            return this;
        }

        @Override
        public AmountScheduleBuilder addDatedValue(DatedValue _datedValue, int idx) {
            this.getIndex(this.datedValue, idx, () -> _datedValue.toBuilder());
            return this;
        }

        @Override
        public AmountScheduleBuilder addDatedValue(List<? extends DatedValue> datedValues) {
            if (datedValues != null) {
                for (DatedValue datedValue : datedValues) {
                    this.datedValue.add(datedValue.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="datedValue")
        public AmountScheduleBuilder setDatedValue(List<? extends DatedValue> datedValues) {
            this.datedValue = datedValues == null ? new ArrayList() : (List)datedValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public AmountScheduleBuilder addCurrency(FieldWithMetaString _currency) {
            if (_currency != null) {
                this.currency.add(_currency.toBuilder());
            }
            return this;
        }

        @Override
        public AmountScheduleBuilder addCurrency(FieldWithMetaString _currency, int idx) {
            this.getIndex(this.currency, idx, () -> _currency.toBuilder());
            return this;
        }

        @Override
        public AmountScheduleBuilder addCurrencyValue(String _currency) {
            this.getOrCreateCurrency(-1).setValue(_currency);
            return this;
        }

        @Override
        public AmountScheduleBuilder addCurrencyValue(String _currency, int idx) {
            this.getOrCreateCurrency(idx).setValue(_currency);
            return this;
        }

        @Override
        public AmountScheduleBuilder addCurrency(List<? extends FieldWithMetaString> currencys) {
            if (currencys != null) {
                for (FieldWithMetaString fieldWithMetaString : currencys) {
                    this.currency.add(fieldWithMetaString.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="currency")
        public AmountScheduleBuilder setCurrency(List<? extends FieldWithMetaString> currencys) {
            this.currency = currencys == null ? new ArrayList<FieldWithMetaString.FieldWithMetaStringBuilder>() : (List)currencys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AmountScheduleBuilder addCurrencyValue(List<? extends String> currencys) {
            if (currencys != null) {
                for (String string : currencys) {
                    this.addCurrencyValue(string);
                }
            }
            return this;
        }

        @Override
        public AmountScheduleBuilder setCurrencyValue(List<? extends String> currencys) {
            this.currency.clear();
            if (currencys != null) {
                currencys.forEach(this::addCurrencyValue);
            }
            return this;
        }

        @Override
        public AmountSchedule build() {
            return new AmountScheduleImpl(this);
        }

        @Override
        public AmountScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public AmountScheduleBuilder prune() {
            super.prune();
            this.currency = this.currency.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getCurrency() != null && !this.getCurrency().isEmpty();
        }

        @Override
        public AmountScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AmountScheduleBuilder o = (AmountScheduleBuilder)other;
            merger.mergeRosetta(this.getCurrency(), o.getCurrency(), this::getOrCreateCurrency);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AmountSchedule _that = (AmountSchedule)this.getType().cast(o);
            return ListEquals.listEquals(this.currency, _that.getCurrency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AmountScheduleBuilder {currency=" + this.currency + '}' + " " + super.toString();
        }
    }

    public static interface AmountScheduleBuilder
    extends AmountSchedule,
    Schedule.ScheduleBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCurrency(int var1);

        public List<? extends FieldWithMetaString.FieldWithMetaStringBuilder> getCurrency();

        @Override
        public AmountScheduleBuilder setValue(BigDecimal var1);

        @Override
        public AmountScheduleBuilder addDatedValue(DatedValue var1);

        @Override
        public AmountScheduleBuilder addDatedValue(DatedValue var1, int var2);

        @Override
        public AmountScheduleBuilder addDatedValue(List<? extends DatedValue> var1);

        @Override
        public AmountScheduleBuilder setDatedValue(List<? extends DatedValue> var1);

        public AmountScheduleBuilder addCurrency(FieldWithMetaString var1);

        public AmountScheduleBuilder addCurrency(FieldWithMetaString var1, int var2);

        public AmountScheduleBuilder addCurrencyValue(String var1);

        public AmountScheduleBuilder addCurrencyValue(String var1, int var2);

        public AmountScheduleBuilder addCurrency(List<? extends FieldWithMetaString> var1);

        public AmountScheduleBuilder setCurrency(List<? extends FieldWithMetaString> var1);

        public AmountScheduleBuilder addCurrencyValue(List<? extends String> var1);

        public AmountScheduleBuilder setCurrencyValue(List<? extends String> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("datedValue"), processor, DatedValue.DatedValueBuilder.class, this.getDatedValue(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getCurrency(), new AttributeMeta[0]);
        }

        @Override
        public AmountScheduleBuilder prune();
    }

    public static class AmountScheduleImpl
    extends Schedule.ScheduleImpl
    implements AmountSchedule {
        private final List<? extends FieldWithMetaString> currency;

        protected AmountScheduleImpl(AmountScheduleBuilder builder) {
            super(builder);
            this.currency = Optional.ofNullable(builder.getCurrency()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public List<? extends FieldWithMetaString> getCurrency() {
            return this.currency;
        }

        @Override
        public AmountSchedule build() {
            return this;
        }

        @Override
        public AmountScheduleBuilder toBuilder() {
            AmountScheduleBuilder builder = AmountSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AmountScheduleBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AmountSchedule _that = (AmountSchedule)this.getType().cast(o);
            return ListEquals.listEquals(this.currency, _that.getCurrency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AmountSchedule {currency=" + this.currency + '}' + " " + super.toString();
        }
    }
}

