/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule.functions;

import cdm.product.common.schedule.CalculationPeriodData;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.functions.AdjustableDateUtils;
import cdm.product.common.schedule.functions.CalculationPeriod;
import cdm.product.common.schedule.functions.CdmToStrataMapper;
import com.google.common.collect.Iterables;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.rosetta.model.lib.records.Date;
import java.time.LocalDate;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculationPeriodImpl
extends CalculationPeriod {
    private static Logger LOGGER = LoggerFactory.getLogger(CalculationPeriod.class);
    private final BiPredicate<Date, SchedulePeriod> STARTDATE_EQ_OR_AFTER = (date, period) -> this.toLocalDate((Date)date).isEqual(period.getStartDate()) || this.toLocalDate((Date)date).isAfter(period.getStartDate());

    @Override
    protected CalculationPeriodData.CalculationPeriodDataBuilder doEvaluate(CalculationPeriodDates calculationPeriodDates, Date date) {
        CalculationPeriodData.CalculationPeriodDataBuilder builder = CalculationPeriodData.builder();
        Date adjustedStartDate = AdjustableDateUtils.adjustDate(calculationPeriodDates.getEffectiveDate());
        Date adjustedEndDate = AdjustableDateUtils.adjustDate(calculationPeriodDates.getTerminationDate());
        if (adjustedStartDate == null) {
            LOGGER.warn("Can not build CalculationPeriodData as no adjusted start date specified.");
            return builder;
        }
        if (adjustedEndDate == null) {
            LOGGER.warn("Can not build CalculationPeriodData as no adjusted end date specified.");
            return builder;
        }
        Optional<SchedulePeriod> optionalSchedulePeriod = this.getSchedulePeriod(calculationPeriodDates, date, adjustedStartDate.toLocalDate(), adjustedEndDate.toLocalDate());
        if (!optionalSchedulePeriod.isPresent()) {
            LOGGER.warn("Can not build CalculationPeriodData as no targetPeriod could be found.");
            return builder;
        }
        SchedulePeriod targetPeriod = optionalSchedulePeriod.get();
        int daysThatAreInLeapYear = this.getDaysThatAreInLeapYear(targetPeriod);
        return builder.setStartDate(Date.of((LocalDate)targetPeriod.getStartDate())).setEndDate(Date.of((LocalDate)targetPeriod.getEndDate())).setDaysInLeapYearPeriod(daysThatAreInLeapYear).setDaysInPeriod((int)ChronoUnit.DAYS.between(targetPeriod.getStartDate(), targetPeriod.getEndDate())).setIsFirstPeriod(false).setIsLastPeriod(false);
    }

    private int getDaysThatAreInLeapYear(SchedulePeriod targetPeriod) {
        int daysThatAreInLeapYear = 0;
        LocalDate startDate = targetPeriod.getStartDate();
        while (startDate.isBefore(targetPeriod.getEndDate())) {
            if (IsoChronology.INSTANCE.isLeapYear(startDate.getYear())) {
                ++daysThatAreInLeapYear;
            }
            startDate = startDate.plusDays(1L);
        }
        return daysThatAreInLeapYear;
    }

    private Optional<SchedulePeriod> getSchedulePeriod(CalculationPeriodDates calculationPeriodDates, Date date, LocalDate adjustedStartDate, LocalDate adjustedEndDate) {
        Schedule schedule = this.getSchedule(calculationPeriodDates, adjustedStartDate, adjustedEndDate);
        if (this.toLocalDate(date).isEqual(schedule.getEndDate())) {
            return Optional.ofNullable((SchedulePeriod)Iterables.getLast((Iterable)schedule.getPeriods()));
        }
        List targetPeriods = schedule.getPeriods().stream().filter(period -> this.STARTDATE_EQ_OR_AFTER.test(date, (SchedulePeriod)period) && this.toLocalDate(date).isBefore(period.getEndDate())).collect(Collectors.toList());
        if (targetPeriods.size() != 1) {
            LOGGER.warn("Date " + date.toString() + " not within schedule " + schedule.getPeriods());
            return Optional.empty();
        }
        return Optional.of((SchedulePeriod)Iterables.getOnlyElement(targetPeriods));
    }

    private Schedule getSchedule(CalculationPeriodDates calculationPeriodDates, LocalDate adjustedStartDate, LocalDate adjustedEndDate) {
        PeriodicSchedule periodicSchedule = PeriodicSchedule.of((LocalDate)adjustedStartDate, (LocalDate)adjustedEndDate, (Frequency)CdmToStrataMapper.getFrequency(calculationPeriodDates), (BusinessDayAdjustment)BusinessDayAdjustment.NONE, (StubConvention)StubConvention.NONE, (RollConvention)CdmToStrataMapper.getRollConvention(calculationPeriodDates));
        Schedule schedule = periodicSchedule.createSchedule(ReferenceData.minimal());
        return schedule;
    }

    private LocalDate toLocalDate(Date date) {
        return LocalDate.of(date.getYear(), date.getMonth(), date.getDay());
    }
}

