/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.asset.CorrelationReturnTerms;
import cdm.product.asset.DividendReturnTerms;
import cdm.product.asset.PriceReturnTerms;
import cdm.product.asset.VarianceReturnTerms;
import cdm.product.asset.VolatilityReturnTerms;
import cdm.product.template.Product;
import cdm.product.template.ReturnTerms;
import cdm.product.template.meta.PortfolioReturnTermsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PortfolioReturnTerms", builder=PortfolioReturnTermsBuilderImpl.class, version="5.30.0")
@RuneDataType(value="PortfolioReturnTerms", model="cdm", builder=PortfolioReturnTermsBuilderImpl.class, version="5.30.0")
public interface PortfolioReturnTerms
extends ReturnTerms {
    public static final PortfolioReturnTermsMeta metaData = new PortfolioReturnTermsMeta();

    public PayerReceiver getPayerReceiver();

    public Product getUnderlier();

    public List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> getQuantity();

    public List<? extends ReferenceWithMetaPriceSchedule> getInitialValuationPrice();

    public List<? extends ReferenceWithMetaPriceSchedule> getInterimValuationPrice();

    public List<? extends ReferenceWithMetaPriceSchedule> getFinalValuationPrice();

    @Override
    public PortfolioReturnTerms build();

    @Override
    public PortfolioReturnTermsBuilder toBuilder();

    public static PortfolioReturnTermsBuilder builder() {
        return new PortfolioReturnTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends PortfolioReturnTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PortfolioReturnTerms> getType() {
        return PortfolioReturnTerms.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("priceReturnTerms"), processor, PriceReturnTerms.class, this.getPriceReturnTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendReturnTerms"), processor, DividendReturnTerms.class, this.getDividendReturnTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("varianceReturnTerms"), processor, VarianceReturnTerms.class, this.getVarianceReturnTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("volatilityReturnTerms"), processor, VolatilityReturnTerms.class, this.getVolatilityReturnTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationReturnTerms"), processor, CorrelationReturnTerms.class, this.getCorrelationReturnTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlier"), processor, Product.class, this.getUnderlier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quantity"), processor, ReferenceWithMetaNonNegativeQuantitySchedule.class, this.getQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("initialValuationPrice"), processor, ReferenceWithMetaPriceSchedule.class, this.getInitialValuationPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interimValuationPrice"), processor, ReferenceWithMetaPriceSchedule.class, this.getInterimValuationPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalValuationPrice"), processor, ReferenceWithMetaPriceSchedule.class, this.getFinalValuationPrice(), new AttributeMeta[0]);
    }

    public static class PortfolioReturnTermsBuilderImpl
    extends ReturnTerms.ReturnTermsBuilderImpl
    implements PortfolioReturnTermsBuilder {
        protected PayerReceiver.PayerReceiverBuilder payerReceiver;
        protected Product.ProductBuilder underlier;
        protected List<ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder> quantity = new ArrayList<ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder>();
        protected List<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> initialValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
        protected List<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> interimValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
        protected List<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> finalValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public PayerReceiver.PayerReceiverBuilder getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        public PayerReceiver.PayerReceiverBuilder getOrCreatePayerReceiver() {
            PayerReceiver.PayerReceiverBuilder result = this.payerReceiver != null ? this.payerReceiver : (this.payerReceiver = PayerReceiver.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public Product.ProductBuilder getUnderlier() {
            return this.underlier;
        }

        @Override
        public Product.ProductBuilder getOrCreateUnderlier() {
            Product.ProductBuilder result = this.underlier != null ? this.underlier : (this.underlier = Product.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder> getQuantity() {
            return this.quantity;
        }

        @Override
        public ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder getOrCreateQuantity(int index) {
            if (this.quantity == null) {
                this.quantity = new ArrayList<ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder>();
            }
            return (ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder)this.getIndex(this.quantity, index, () -> {
                ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder newQuantity = ReferenceWithMetaNonNegativeQuantitySchedule.builder();
                return newQuantity;
            });
        }

        @Override
        @RosettaAttribute(value="initialValuationPrice")
        @RuneAttribute(value="initialValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getInitialValuationPrice() {
            return this.initialValuationPrice;
        }

        @Override
        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateInitialValuationPrice(int index) {
            if (this.initialValuationPrice == null) {
                this.initialValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
            }
            return (ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder)this.getIndex(this.initialValuationPrice, index, () -> {
                ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder newInitialValuationPrice = ReferenceWithMetaPriceSchedule.builder();
                return newInitialValuationPrice;
            });
        }

        @Override
        @RosettaAttribute(value="interimValuationPrice")
        @RuneAttribute(value="interimValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getInterimValuationPrice() {
            return this.interimValuationPrice;
        }

        @Override
        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateInterimValuationPrice(int index) {
            if (this.interimValuationPrice == null) {
                this.interimValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
            }
            return (ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder)this.getIndex(this.interimValuationPrice, index, () -> {
                ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder newInterimValuationPrice = ReferenceWithMetaPriceSchedule.builder();
                return newInterimValuationPrice;
            });
        }

        @Override
        @RosettaAttribute(value="finalValuationPrice")
        @RuneAttribute(value="finalValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getFinalValuationPrice() {
            return this.finalValuationPrice;
        }

        @Override
        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateFinalValuationPrice(int index) {
            if (this.finalValuationPrice == null) {
                this.finalValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
            }
            return (ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder)this.getIndex(this.finalValuationPrice, index, () -> {
                ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder newFinalValuationPrice = ReferenceWithMetaPriceSchedule.builder();
                return newFinalValuationPrice;
            });
        }

        @Override
        @RosettaAttribute(value="priceReturnTerms")
        @RuneAttribute(value="priceReturnTerms")
        public PortfolioReturnTermsBuilder setPriceReturnTerms(PriceReturnTerms _priceReturnTerms) {
            this.priceReturnTerms = _priceReturnTerms == null ? null : _priceReturnTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendReturnTerms")
        @RuneAttribute(value="dividendReturnTerms")
        public PortfolioReturnTermsBuilder setDividendReturnTerms(DividendReturnTerms _dividendReturnTerms) {
            this.dividendReturnTerms = _dividendReturnTerms == null ? null : _dividendReturnTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="varianceReturnTerms")
        @RuneAttribute(value="varianceReturnTerms")
        public PortfolioReturnTermsBuilder setVarianceReturnTerms(VarianceReturnTerms _varianceReturnTerms) {
            this.varianceReturnTerms = _varianceReturnTerms == null ? null : _varianceReturnTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="volatilityReturnTerms")
        @RuneAttribute(value="volatilityReturnTerms")
        public PortfolioReturnTermsBuilder setVolatilityReturnTerms(VolatilityReturnTerms _volatilityReturnTerms) {
            this.volatilityReturnTerms = _volatilityReturnTerms == null ? null : _volatilityReturnTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationReturnTerms")
        @RuneAttribute(value="correlationReturnTerms")
        public PortfolioReturnTermsBuilder setCorrelationReturnTerms(CorrelationReturnTerms _correlationReturnTerms) {
            this.correlationReturnTerms = _correlationReturnTerms == null ? null : _correlationReturnTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public PortfolioReturnTermsBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public PortfolioReturnTermsBuilder setUnderlier(Product _underlier) {
            this.underlier = _underlier == null ? null : _underlier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        @RuneScopedAttributeReference
        public PortfolioReturnTermsBuilder addQuantity(ReferenceWithMetaNonNegativeQuantitySchedule _quantity) {
            if (_quantity != null) {
                this.quantity.add(_quantity.toBuilder());
            }
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addQuantity(ReferenceWithMetaNonNegativeQuantitySchedule _quantity, int idx) {
            this.getIndex(this.quantity, idx, () -> _quantity.toBuilder());
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addQuantityValue(NonNegativeQuantitySchedule _quantity) {
            this.getOrCreateQuantity(-1).setValue(_quantity.toBuilder());
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addQuantityValue(NonNegativeQuantitySchedule _quantity, int idx) {
            this.getOrCreateQuantity(idx).setValue(_quantity.toBuilder());
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addQuantity(List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantitys) {
            if (quantitys != null) {
                for (ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule : quantitys) {
                    this.quantity.add(referenceWithMetaNonNegativeQuantitySchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="quantity")
        @RuneScopedAttributeReference
        public PortfolioReturnTermsBuilder setQuantity(List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantitys) {
            this.quantity = quantitys == null ? new ArrayList<ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder>() : (List)quantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addQuantityValue(List<? extends NonNegativeQuantitySchedule> quantitys) {
            if (quantitys != null) {
                for (NonNegativeQuantitySchedule nonNegativeQuantitySchedule : quantitys) {
                    this.addQuantityValue(nonNegativeQuantitySchedule);
                }
            }
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder setQuantityValue(List<? extends NonNegativeQuantitySchedule> quantitys) {
            this.quantity.clear();
            if (quantitys != null) {
                quantitys.forEach(this::addQuantityValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="initialValuationPrice")
        @RuneAttribute(value="initialValuationPrice")
        @RuneScopedAttributeReference
        public PortfolioReturnTermsBuilder addInitialValuationPrice(ReferenceWithMetaPriceSchedule _initialValuationPrice) {
            if (_initialValuationPrice != null) {
                this.initialValuationPrice.add(_initialValuationPrice.toBuilder());
            }
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addInitialValuationPrice(ReferenceWithMetaPriceSchedule _initialValuationPrice, int idx) {
            this.getIndex(this.initialValuationPrice, idx, () -> _initialValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addInitialValuationPriceValue(PriceSchedule _initialValuationPrice) {
            this.getOrCreateInitialValuationPrice(-1).setValue(_initialValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addInitialValuationPriceValue(PriceSchedule _initialValuationPrice, int idx) {
            this.getOrCreateInitialValuationPrice(idx).setValue(_initialValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addInitialValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> initialValuationPrices) {
            if (initialValuationPrices != null) {
                for (ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule : initialValuationPrices) {
                    this.initialValuationPrice.add(referenceWithMetaPriceSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="initialValuationPrice")
        @RuneScopedAttributeReference
        public PortfolioReturnTermsBuilder setInitialValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> initialValuationPrices) {
            this.initialValuationPrice = initialValuationPrices == null ? new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>() : (List)initialValuationPrices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addInitialValuationPriceValue(List<? extends PriceSchedule> initialValuationPrices) {
            if (initialValuationPrices != null) {
                for (PriceSchedule priceSchedule : initialValuationPrices) {
                    this.addInitialValuationPriceValue(priceSchedule);
                }
            }
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder setInitialValuationPriceValue(List<? extends PriceSchedule> initialValuationPrices) {
            this.initialValuationPrice.clear();
            if (initialValuationPrices != null) {
                initialValuationPrices.forEach(this::addInitialValuationPriceValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="interimValuationPrice")
        @RuneAttribute(value="interimValuationPrice")
        @RuneScopedAttributeReference
        public PortfolioReturnTermsBuilder addInterimValuationPrice(ReferenceWithMetaPriceSchedule _interimValuationPrice) {
            if (_interimValuationPrice != null) {
                this.interimValuationPrice.add(_interimValuationPrice.toBuilder());
            }
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addInterimValuationPrice(ReferenceWithMetaPriceSchedule _interimValuationPrice, int idx) {
            this.getIndex(this.interimValuationPrice, idx, () -> _interimValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addInterimValuationPriceValue(PriceSchedule _interimValuationPrice) {
            this.getOrCreateInterimValuationPrice(-1).setValue(_interimValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addInterimValuationPriceValue(PriceSchedule _interimValuationPrice, int idx) {
            this.getOrCreateInterimValuationPrice(idx).setValue(_interimValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addInterimValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> interimValuationPrices) {
            if (interimValuationPrices != null) {
                for (ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule : interimValuationPrices) {
                    this.interimValuationPrice.add(referenceWithMetaPriceSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="interimValuationPrice")
        @RuneScopedAttributeReference
        public PortfolioReturnTermsBuilder setInterimValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> interimValuationPrices) {
            this.interimValuationPrice = interimValuationPrices == null ? new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>() : (List)interimValuationPrices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addInterimValuationPriceValue(List<? extends PriceSchedule> interimValuationPrices) {
            if (interimValuationPrices != null) {
                for (PriceSchedule priceSchedule : interimValuationPrices) {
                    this.addInterimValuationPriceValue(priceSchedule);
                }
            }
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder setInterimValuationPriceValue(List<? extends PriceSchedule> interimValuationPrices) {
            this.interimValuationPrice.clear();
            if (interimValuationPrices != null) {
                interimValuationPrices.forEach(this::addInterimValuationPriceValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="finalValuationPrice")
        @RuneAttribute(value="finalValuationPrice")
        @RuneScopedAttributeReference
        public PortfolioReturnTermsBuilder addFinalValuationPrice(ReferenceWithMetaPriceSchedule _finalValuationPrice) {
            if (_finalValuationPrice != null) {
                this.finalValuationPrice.add(_finalValuationPrice.toBuilder());
            }
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addFinalValuationPrice(ReferenceWithMetaPriceSchedule _finalValuationPrice, int idx) {
            this.getIndex(this.finalValuationPrice, idx, () -> _finalValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addFinalValuationPriceValue(PriceSchedule _finalValuationPrice) {
            this.getOrCreateFinalValuationPrice(-1).setValue(_finalValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addFinalValuationPriceValue(PriceSchedule _finalValuationPrice, int idx) {
            this.getOrCreateFinalValuationPrice(idx).setValue(_finalValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addFinalValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> finalValuationPrices) {
            if (finalValuationPrices != null) {
                for (ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule : finalValuationPrices) {
                    this.finalValuationPrice.add(referenceWithMetaPriceSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="finalValuationPrice")
        @RuneScopedAttributeReference
        public PortfolioReturnTermsBuilder setFinalValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> finalValuationPrices) {
            this.finalValuationPrice = finalValuationPrices == null ? new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>() : (List)finalValuationPrices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder addFinalValuationPriceValue(List<? extends PriceSchedule> finalValuationPrices) {
            if (finalValuationPrices != null) {
                for (PriceSchedule priceSchedule : finalValuationPrices) {
                    this.addFinalValuationPriceValue(priceSchedule);
                }
            }
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder setFinalValuationPriceValue(List<? extends PriceSchedule> finalValuationPrices) {
            this.finalValuationPrice.clear();
            if (finalValuationPrices != null) {
                finalValuationPrices.forEach(this::addFinalValuationPriceValue);
            }
            return this;
        }

        @Override
        public PortfolioReturnTerms build() {
            return new PortfolioReturnTermsImpl(this);
        }

        @Override
        public PortfolioReturnTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder prune() {
            super.prune();
            if (this.payerReceiver != null && !this.payerReceiver.prune().hasData()) {
                this.payerReceiver = null;
            }
            if (this.underlier != null && !this.underlier.prune().hasData()) {
                this.underlier = null;
            }
            this.quantity = this.quantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.initialValuationPrice = this.initialValuationPrice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.interimValuationPrice = this.interimValuationPrice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.finalValuationPrice = this.finalValuationPrice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPayerReceiver() != null && this.getPayerReceiver().hasData()) {
                return true;
            }
            if (this.getUnderlier() != null && this.getUnderlier().hasData()) {
                return true;
            }
            if (this.getQuantity() != null && this.getQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getInitialValuationPrice() != null && this.getInitialValuationPrice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getInterimValuationPrice() != null && this.getInterimValuationPrice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getFinalValuationPrice() != null && this.getFinalValuationPrice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public PortfolioReturnTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PortfolioReturnTermsBuilder o = (PortfolioReturnTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiver(), (RosettaModelObjectBuilder)o.getPayerReceiver(), this::setPayerReceiver);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlier(), (RosettaModelObjectBuilder)o.getUnderlier(), this::setUnderlier);
            merger.mergeRosetta(this.getQuantity(), o.getQuantity(), this::getOrCreateQuantity);
            merger.mergeRosetta(this.getInitialValuationPrice(), o.getInitialValuationPrice(), this::getOrCreateInitialValuationPrice);
            merger.mergeRosetta(this.getInterimValuationPrice(), o.getInterimValuationPrice(), this::getOrCreateInterimValuationPrice);
            merger.mergeRosetta(this.getFinalValuationPrice(), o.getFinalValuationPrice(), this::getOrCreateFinalValuationPrice);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PortfolioReturnTerms _that = (PortfolioReturnTerms)this.getType().cast(o);
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!ListEquals.listEquals(this.initialValuationPrice, _that.getInitialValuationPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.interimValuationPrice, _that.getInterimValuationPrice())) {
                return false;
            }
            return ListEquals.listEquals(this.finalValuationPrice, _that.getFinalValuationPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.initialValuationPrice != null ? this.initialValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.interimValuationPrice != null ? this.interimValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.finalValuationPrice != null ? this.finalValuationPrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PortfolioReturnTermsBuilder {payerReceiver=" + this.payerReceiver + ", underlier=" + this.underlier + ", quantity=" + this.quantity + ", initialValuationPrice=" + this.initialValuationPrice + ", interimValuationPrice=" + this.interimValuationPrice + ", finalValuationPrice=" + this.finalValuationPrice + '}' + " " + super.toString();
        }
    }

    public static interface PortfolioReturnTermsBuilder
    extends PortfolioReturnTerms,
    ReturnTerms.ReturnTermsBuilder {
        public PayerReceiver.PayerReceiverBuilder getOrCreatePayerReceiver();

        @Override
        public PayerReceiver.PayerReceiverBuilder getPayerReceiver();

        public Product.ProductBuilder getOrCreateUnderlier();

        @Override
        public Product.ProductBuilder getUnderlier();

        public ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder getOrCreateQuantity(int var1);

        public List<? extends ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder> getQuantity();

        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateInitialValuationPrice(int var1);

        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getInitialValuationPrice();

        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateInterimValuationPrice(int var1);

        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getInterimValuationPrice();

        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateFinalValuationPrice(int var1);

        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getFinalValuationPrice();

        @Override
        public PortfolioReturnTermsBuilder setPriceReturnTerms(PriceReturnTerms var1);

        @Override
        public PortfolioReturnTermsBuilder setDividendReturnTerms(DividendReturnTerms var1);

        @Override
        public PortfolioReturnTermsBuilder setVarianceReturnTerms(VarianceReturnTerms var1);

        @Override
        public PortfolioReturnTermsBuilder setVolatilityReturnTerms(VolatilityReturnTerms var1);

        @Override
        public PortfolioReturnTermsBuilder setCorrelationReturnTerms(CorrelationReturnTerms var1);

        public PortfolioReturnTermsBuilder setPayerReceiver(PayerReceiver var1);

        public PortfolioReturnTermsBuilder setUnderlier(Product var1);

        public PortfolioReturnTermsBuilder addQuantity(ReferenceWithMetaNonNegativeQuantitySchedule var1);

        public PortfolioReturnTermsBuilder addQuantity(ReferenceWithMetaNonNegativeQuantitySchedule var1, int var2);

        public PortfolioReturnTermsBuilder addQuantityValue(NonNegativeQuantitySchedule var1);

        public PortfolioReturnTermsBuilder addQuantityValue(NonNegativeQuantitySchedule var1, int var2);

        public PortfolioReturnTermsBuilder addQuantity(List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> var1);

        public PortfolioReturnTermsBuilder setQuantity(List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> var1);

        public PortfolioReturnTermsBuilder addQuantityValue(List<? extends NonNegativeQuantitySchedule> var1);

        public PortfolioReturnTermsBuilder setQuantityValue(List<? extends NonNegativeQuantitySchedule> var1);

        public PortfolioReturnTermsBuilder addInitialValuationPrice(ReferenceWithMetaPriceSchedule var1);

        public PortfolioReturnTermsBuilder addInitialValuationPrice(ReferenceWithMetaPriceSchedule var1, int var2);

        public PortfolioReturnTermsBuilder addInitialValuationPriceValue(PriceSchedule var1);

        public PortfolioReturnTermsBuilder addInitialValuationPriceValue(PriceSchedule var1, int var2);

        public PortfolioReturnTermsBuilder addInitialValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public PortfolioReturnTermsBuilder setInitialValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public PortfolioReturnTermsBuilder addInitialValuationPriceValue(List<? extends PriceSchedule> var1);

        public PortfolioReturnTermsBuilder setInitialValuationPriceValue(List<? extends PriceSchedule> var1);

        public PortfolioReturnTermsBuilder addInterimValuationPrice(ReferenceWithMetaPriceSchedule var1);

        public PortfolioReturnTermsBuilder addInterimValuationPrice(ReferenceWithMetaPriceSchedule var1, int var2);

        public PortfolioReturnTermsBuilder addInterimValuationPriceValue(PriceSchedule var1);

        public PortfolioReturnTermsBuilder addInterimValuationPriceValue(PriceSchedule var1, int var2);

        public PortfolioReturnTermsBuilder addInterimValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public PortfolioReturnTermsBuilder setInterimValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public PortfolioReturnTermsBuilder addInterimValuationPriceValue(List<? extends PriceSchedule> var1);

        public PortfolioReturnTermsBuilder setInterimValuationPriceValue(List<? extends PriceSchedule> var1);

        public PortfolioReturnTermsBuilder addFinalValuationPrice(ReferenceWithMetaPriceSchedule var1);

        public PortfolioReturnTermsBuilder addFinalValuationPrice(ReferenceWithMetaPriceSchedule var1, int var2);

        public PortfolioReturnTermsBuilder addFinalValuationPriceValue(PriceSchedule var1);

        public PortfolioReturnTermsBuilder addFinalValuationPriceValue(PriceSchedule var1, int var2);

        public PortfolioReturnTermsBuilder addFinalValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public PortfolioReturnTermsBuilder setFinalValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public PortfolioReturnTermsBuilder addFinalValuationPriceValue(List<? extends PriceSchedule> var1);

        public PortfolioReturnTermsBuilder setFinalValuationPriceValue(List<? extends PriceSchedule> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("priceReturnTerms"), processor, PriceReturnTerms.PriceReturnTermsBuilder.class, (RosettaModelObjectBuilder)this.getPriceReturnTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendReturnTerms"), processor, DividendReturnTerms.DividendReturnTermsBuilder.class, (RosettaModelObjectBuilder)this.getDividendReturnTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("varianceReturnTerms"), processor, VarianceReturnTerms.VarianceReturnTermsBuilder.class, (RosettaModelObjectBuilder)this.getVarianceReturnTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("volatilityReturnTerms"), processor, VolatilityReturnTerms.VolatilityReturnTermsBuilder.class, (RosettaModelObjectBuilder)this.getVolatilityReturnTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationReturnTerms"), processor, CorrelationReturnTerms.CorrelationReturnTermsBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationReturnTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlier"), processor, Product.ProductBuilder.class, this.getUnderlier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quantity"), processor, ReferenceWithMetaNonNegativeQuantitySchedule.ReferenceWithMetaNonNegativeQuantityScheduleBuilder.class, this.getQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("initialValuationPrice"), processor, ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder.class, this.getInitialValuationPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interimValuationPrice"), processor, ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder.class, this.getInterimValuationPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalValuationPrice"), processor, ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder.class, this.getFinalValuationPrice(), new AttributeMeta[0]);
        }

        @Override
        public PortfolioReturnTermsBuilder prune();
    }

    public static class PortfolioReturnTermsImpl
    extends ReturnTerms.ReturnTermsImpl
    implements PortfolioReturnTerms {
        private final PayerReceiver payerReceiver;
        private final Product underlier;
        private final List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity;
        private final List<? extends ReferenceWithMetaPriceSchedule> initialValuationPrice;
        private final List<? extends ReferenceWithMetaPriceSchedule> interimValuationPrice;
        private final List<? extends ReferenceWithMetaPriceSchedule> finalValuationPrice;

        protected PortfolioReturnTermsImpl(PortfolioReturnTermsBuilder builder) {
            super(builder);
            this.payerReceiver = Optional.ofNullable(builder.getPayerReceiver()).map(f -> f.build()).orElse(null);
            this.underlier = Optional.ofNullable(builder.getUnderlier()).map(f -> f.build()).orElse(null);
            this.quantity = Optional.ofNullable(builder.getQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.initialValuationPrice = Optional.ofNullable(builder.getInitialValuationPrice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.interimValuationPrice = Optional.ofNullable(builder.getInterimValuationPrice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.finalValuationPrice = Optional.ofNullable(builder.getFinalValuationPrice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public PayerReceiver getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public Product getUnderlier() {
            return this.underlier;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaNonNegativeQuantitySchedule> getQuantity() {
            return this.quantity;
        }

        @Override
        @RosettaAttribute(value="initialValuationPrice")
        @RuneAttribute(value="initialValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule> getInitialValuationPrice() {
            return this.initialValuationPrice;
        }

        @Override
        @RosettaAttribute(value="interimValuationPrice")
        @RuneAttribute(value="interimValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule> getInterimValuationPrice() {
            return this.interimValuationPrice;
        }

        @Override
        @RosettaAttribute(value="finalValuationPrice")
        @RuneAttribute(value="finalValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule> getFinalValuationPrice() {
            return this.finalValuationPrice;
        }

        @Override
        public PortfolioReturnTerms build() {
            return this;
        }

        @Override
        public PortfolioReturnTermsBuilder toBuilder() {
            PortfolioReturnTermsBuilder builder = PortfolioReturnTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PortfolioReturnTermsBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPayerReceiver()).ifPresent(builder::setPayerReceiver);
            Optional.ofNullable(this.getUnderlier()).ifPresent(builder::setUnderlier);
            Optional.ofNullable(this.getQuantity()).ifPresent(builder::setQuantity);
            Optional.ofNullable(this.getInitialValuationPrice()).ifPresent(builder::setInitialValuationPrice);
            Optional.ofNullable(this.getInterimValuationPrice()).ifPresent(builder::setInterimValuationPrice);
            Optional.ofNullable(this.getFinalValuationPrice()).ifPresent(builder::setFinalValuationPrice);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PortfolioReturnTerms _that = (PortfolioReturnTerms)this.getType().cast(o);
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!ListEquals.listEquals(this.initialValuationPrice, _that.getInitialValuationPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.interimValuationPrice, _that.getInterimValuationPrice())) {
                return false;
            }
            return ListEquals.listEquals(this.finalValuationPrice, _that.getFinalValuationPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.initialValuationPrice != null ? this.initialValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.interimValuationPrice != null ? this.interimValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.finalValuationPrice != null ? this.finalValuationPrice.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PortfolioReturnTerms {payerReceiver=" + this.payerReceiver + ", underlier=" + this.underlier + ", quantity=" + this.quantity + ", initialValuationPrice=" + this.initialValuationPrice + ", interimValuationPrice=" + this.interimValuationPrice + ", finalValuationPrice=" + this.finalValuationPrice + '}' + " " + super.toString();
        }
    }
}

