/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PartyIdentifierFormatEnum;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import iso20022.auth030.jfsa.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.jfsa.AmountAndDirection106__2;
import iso20022.auth030.jfsa.GenericIdentification175__1;
import iso20022.auth030.jfsa.NaturalPersonIdentification2__1;
import iso20022.auth030.jfsa.OrganisationIdentification15Choice__2;
import iso20022.auth030.jfsa.OtherPayment5__1;
import iso20022.auth030.jfsa.PartyIdentification236Choice__1;
import iso20022.auth030.jfsa.PaymentType4Code;
import iso20022.auth030.jfsa.PaymentType5Choice__1;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetOthrPmtDefault.class)
public abstract class GetOthrPmt
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends OtherPayment5__1> evaluate(JFSATransactionReport drrReport) {
        List othrPmt;
        List<OtherPayment5__1.OtherPayment5__1Builder> othrPmtBuilder = this.doEvaluate(drrReport);
        if (othrPmtBuilder == null) {
            othrPmt = null;
        } else {
            othrPmt = othrPmtBuilder.stream().map(OtherPayment5__1::build).collect(Collectors.toList());
            this.objectValidator.validate(OtherPayment5__1.class, othrPmt);
        }
        return othrPmt;
    }

    protected abstract List<OtherPayment5__1.OtherPayment5__1Builder> doEvaluate(JFSATransactionReport var1);

    public static class GetOthrPmtDefault
    extends GetOthrPmt {
        @Override
        protected List<OtherPayment5__1.OtherPayment5__1Builder> doEvaluate(JFSATransactionReport drrReport) {
            ArrayList<OtherPayment5__1.OtherPayment5__1Builder> othrPmt = new ArrayList<OtherPayment5__1.OtherPayment5__1Builder>();
            return this.assignOutput(othrPmt, drrReport);
        }

        protected List<OtherPayment5__1.OtherPayment5__1Builder> assignOutput(List<OtherPayment5__1.OtherPayment5__1Builder> othrPmt, JFSATransactionReport drrReport) {
            othrPmt.addAll(this.toBuilder(MapperS.of((Object)drrReport).mapC("getOtherPayment", jFSATransactionReport -> jFSATransactionReport.getOtherPayment()).mapItem(item -> {
                OrganisationIdentification15Choice__2 ifThenElseResult0 = null;
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getPayerFormat", otherPayment -> otherPayment.getPayerFormat()), (Mapper)MapperS.of((Object)((Object)PartyIdentifierFormatEnum.LEI)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult0 = OrganisationIdentification15Choice__2.builder().setLei((String)item.map("getPayer", otherPayment -> otherPayment.getPayer()).get()).build();
                }
                NaturalPersonIdentification2__1 ifThenElseResult1 = null;
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getPayerFormat", otherPayment -> otherPayment.getPayerFormat()), (Mapper)MapperS.of((Object)((Object)PartyIdentifierFormatEnum.LEI_AND_PERSON)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult1 = NaturalPersonIdentification2__1.builder().setId(GenericIdentification175__1.builder().setId((String)item.map("getPayer", otherPayment -> otherPayment.getPayer()).get()).build()).build();
                }
                OrganisationIdentification15Choice__2 ifThenElseResult2 = null;
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getReceiverFormat", otherPayment -> otherPayment.getReceiverFormat()), (Mapper)MapperS.of((Object)((Object)PartyIdentifierFormatEnum.LEI)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult2 = OrganisationIdentification15Choice__2.builder().setLei((String)item.map("getReceiver", otherPayment -> otherPayment.getReceiver()).get()).build();
                }
                NaturalPersonIdentification2__1 ifThenElseResult3 = null;
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getReceiverFormat", otherPayment -> otherPayment.getReceiverFormat()), (Mapper)MapperS.of((Object)((Object)PartyIdentifierFormatEnum.LEI_AND_PERSON)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult3 = NaturalPersonIdentification2__1.builder().setId(GenericIdentification175__1.builder().setId((String)item.map("getReceiver", otherPayment -> otherPayment.getReceiver()).get()).build()).build();
                }
                return MapperS.of((Object)OtherPayment5__1.builder().setPmtTp(PaymentType5Choice__1.builder().setTp((PaymentType4Code)item.map("getPaymentType", otherPayment -> otherPayment.getPaymentType()).checkedMap("to-enum", e -> PaymentType4Code.valueOf((String)e.name()), IllegalArgumentException.class).get()).build()).setPmtAmt(AmountAndDirection106__2.builder().setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)item.map("getAmount", otherPayment -> otherPayment.getAmount()).get()).setCcy((String)item.map("getCurrency", otherPayment -> otherPayment.getCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).build()).setPmtDt((Date)item.map("getDate", otherPayment -> otherPayment.getDate()).get()).setPmtPyer(PartyIdentification236Choice__1.builder().setLgl(ifThenElseResult0).setNtrl(ifThenElseResult1).build()).setPmtRcvr(PartyIdentification236Choice__1.builder().setLgl(ifThenElseResult2).setNtrl(ifThenElseResult3).build()).build());
            }).getMulti()));
            return Optional.ofNullable(othrPmt).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

