/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.asic.rewrite.margin.meta.ASICMarginReportMeta;
import drr.regulation.common.MarginActionEnum;
import drr.standards.iso.CollateralisationType3Code__1;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ASICMarginReport", builder=ASICMarginReportBuilderImpl.class, version="6.21.2")
@RuneDataType(value="ASICMarginReport", model="drr", builder=ASICMarginReportBuilderImpl.class, version="6.21.2")
public interface ASICMarginReport
extends RosettaModelObject {
    public static final ASICMarginReportMeta metaData = new ASICMarginReportMeta();

    public String getUniqueTransactionIdentifier();

    public String getUniqueTransactionIdentifierProprietary();

    public String getReportingEntity();

    public String getCounterparty1();

    public String getSmallScaleBuySideEntityIndicator();

    public String getCounterparty2();

    public ZonedDateTime getCollateralTimestamp();

    public CollateralisationType3Code__1 getCollateralisationCategory();

    public Boolean getCollateralPortfolioIndicator();

    public Boolean getPortfolioContainingNonReportedComponentIndicator();

    public String getInitialMarginCollateralPortfolioCode();

    public String getCollateralPortfolioCodeVM();

    public BigDecimal getInitialMarginPostedByTheReportingEntityPreHaircut();

    public BigDecimal getInitialMarginPostedByTheReportingEntityPostHaircut();

    public ISOCurrencyCodeEnum getCurrencyofInitialMarginPosted();

    public BigDecimal getInitialMarginCollectedByTheReportingEntityPreHaircut();

    public BigDecimal getInitialMarginCollectedByTheReportingEntityPostHaircut();

    public ISOCurrencyCodeEnum getCurrencyofInitialMarginCollected();

    public BigDecimal getVariationMarginPostedByTheReportingEntityPreHaircut();

    public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted();

    public BigDecimal getVariationMarginCollectedByTheReportingEntityPreHaircut();

    public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected();

    public MarginActionEnum getActionType();

    public ZonedDateTime getReportingTimestamp();

    public String getReportSubmittingEntityID();

    public Boolean getCounterpartyIdentifierType();

    public String getTechnicalRecordId();

    public String getExecutionAgentOfCounterparty1();

    public ASICMarginReport build();

    public ASICMarginReportBuilder toBuilder();

    public static ASICMarginReportBuilder builder() {
        return new ASICMarginReportBuilderImpl();
    }

    default public RosettaMetaData<? extends ASICMarginReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ASICMarginReport> getType() {
        return ASICMarginReport.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingEntity"), String.class, (Object)this.getReportingEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, (Object)this.getSmallScaleBuySideEntityIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, (Object)this.getCollateralisationCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("portfolioContainingNonReportedComponentIndicator"), Boolean.class, (Object)this.getPortfolioContainingNonReportedComponentIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioCodeVM"), String.class, (Object)this.getCollateralPortfolioCodeVM(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingEntityPreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheReportingEntityPreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingEntityPostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheReportingEntityPostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyofInitialMarginPosted"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyofInitialMarginPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingEntityPreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByTheReportingEntityPreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingEntityPostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByTheReportingEntityPostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyofInitialMarginCollected"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyofInitialMarginCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingEntityPreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheReportingEntityPreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfVariationMarginPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingEntityPreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheReportingEntityPreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfVariationMarginCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterpartyIdentifierType"), Boolean.class, (Object)this.getCounterpartyIdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, (Object)this.getExecutionAgentOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ASICMarginReportBuilderImpl
    implements ASICMarginReportBuilder {
        protected String uniqueTransactionIdentifier;
        protected String uniqueTransactionIdentifierProprietary;
        protected String reportingEntity;
        protected String counterparty1;
        protected String smallScaleBuySideEntityIndicator;
        protected String counterparty2;
        protected ZonedDateTime collateralTimestamp;
        protected CollateralisationType3Code__1 collateralisationCategory;
        protected Boolean collateralPortfolioIndicator;
        protected Boolean portfolioContainingNonReportedComponentIndicator;
        protected String initialMarginCollateralPortfolioCode;
        protected String collateralPortfolioCodeVM;
        protected BigDecimal initialMarginPostedByTheReportingEntityPreHaircut;
        protected BigDecimal initialMarginPostedByTheReportingEntityPostHaircut;
        protected ISOCurrencyCodeEnum currencyofInitialMarginPosted;
        protected BigDecimal initialMarginCollectedByTheReportingEntityPreHaircut;
        protected BigDecimal initialMarginCollectedByTheReportingEntityPostHaircut;
        protected ISOCurrencyCodeEnum currencyofInitialMarginCollected;
        protected BigDecimal variationMarginPostedByTheReportingEntityPreHaircut;
        protected ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
        protected BigDecimal variationMarginCollectedByTheReportingEntityPreHaircut;
        protected ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
        protected MarginActionEnum actionType;
        protected ZonedDateTime reportingTimestamp;
        protected String reportSubmittingEntityID;
        protected Boolean counterpartyIdentifierType;
        protected String technicalRecordId;
        protected String executionAgentOfCounterparty1;

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="reportingEntity", isRequired=true)
        @RuneAttribute(value="reportingEntity", isRequired=true)
        public String getReportingEntity() {
            return this.reportingEntity;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
        @RuneAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
        public String getSmallScaleBuySideEntityIndicator() {
            return this.smallScaleBuySideEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="collateralTimestamp")
        @RuneAttribute(value="collateralTimestamp")
        public ZonedDateTime getCollateralTimestamp() {
            return this.collateralTimestamp;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public CollateralisationType3Code__1 getCollateralisationCategory() {
            return this.collateralisationCategory;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportedComponentIndicator")
        @RuneAttribute(value="portfolioContainingNonReportedComponentIndicator")
        public Boolean getPortfolioContainingNonReportedComponentIndicator() {
            return this.portfolioContainingNonReportedComponentIndicator;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCodeVM")
        @RuneAttribute(value="collateralPortfolioCodeVM")
        public String getCollateralPortfolioCodeVM() {
            return this.collateralPortfolioCodeVM;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingEntityPreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingEntityPreHaircut")
        public BigDecimal getInitialMarginPostedByTheReportingEntityPreHaircut() {
            return this.initialMarginPostedByTheReportingEntityPreHaircut;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingEntityPostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingEntityPostHaircut")
        public BigDecimal getInitialMarginPostedByTheReportingEntityPostHaircut() {
            return this.initialMarginPostedByTheReportingEntityPostHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyofInitialMarginPosted")
        @RuneAttribute(value="currencyofInitialMarginPosted")
        public ISOCurrencyCodeEnum getCurrencyofInitialMarginPosted() {
            return this.currencyofInitialMarginPosted;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByTheReportingEntityPreHaircut")
        @RuneAttribute(value="initialMarginCollectedByTheReportingEntityPreHaircut")
        public BigDecimal getInitialMarginCollectedByTheReportingEntityPreHaircut() {
            return this.initialMarginCollectedByTheReportingEntityPreHaircut;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByTheReportingEntityPostHaircut")
        @RuneAttribute(value="initialMarginCollectedByTheReportingEntityPostHaircut")
        public BigDecimal getInitialMarginCollectedByTheReportingEntityPostHaircut() {
            return this.initialMarginCollectedByTheReportingEntityPostHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyofInitialMarginCollected")
        @RuneAttribute(value="currencyofInitialMarginCollected")
        public ISOCurrencyCodeEnum getCurrencyofInitialMarginCollected() {
            return this.currencyofInitialMarginCollected;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheReportingEntityPreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheReportingEntityPreHaircut")
        public BigDecimal getVariationMarginPostedByTheReportingEntityPreHaircut() {
            return this.variationMarginPostedByTheReportingEntityPreHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginPosted")
        @RuneAttribute(value="currencyOfVariationMarginPosted")
        public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
            return this.currencyOfVariationMarginPosted;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheReportingEntityPreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheReportingEntityPreHaircut")
        public BigDecimal getVariationMarginCollectedByTheReportingEntityPreHaircut() {
            return this.variationMarginCollectedByTheReportingEntityPreHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginCollected")
        @RuneAttribute(value="currencyOfVariationMarginCollected")
        public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
            return this.currencyOfVariationMarginCollected;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public MarginActionEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="counterpartyIdentifierType", isRequired=true)
        @RuneAttribute(value="counterpartyIdentifierType", isRequired=true)
        public Boolean getCounterpartyIdentifierType() {
            return this.counterpartyIdentifierType;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty1", isRequired=true)
        @RuneAttribute(value="executionAgentOfCounterparty1", isRequired=true)
        public String getExecutionAgentOfCounterparty1() {
            return this.executionAgentOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public ASICMarginReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public ASICMarginReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingEntity", isRequired=true)
        @RuneAttribute(value="reportingEntity", isRequired=true)
        public ASICMarginReportBuilder setReportingEntity(String _reportingEntity) {
            this.reportingEntity = _reportingEntity == null ? null : _reportingEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public ASICMarginReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
        @RuneAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
        public ASICMarginReportBuilder setSmallScaleBuySideEntityIndicator(String _smallScaleBuySideEntityIndicator) {
            this.smallScaleBuySideEntityIndicator = _smallScaleBuySideEntityIndicator == null ? null : _smallScaleBuySideEntityIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public ASICMarginReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralTimestamp")
        @RuneAttribute(value="collateralTimestamp")
        public ASICMarginReportBuilder setCollateralTimestamp(ZonedDateTime _collateralTimestamp) {
            this.collateralTimestamp = _collateralTimestamp == null ? null : _collateralTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public ASICMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 _collateralisationCategory) {
            this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public ASICMarginReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportedComponentIndicator")
        @RuneAttribute(value="portfolioContainingNonReportedComponentIndicator")
        public ASICMarginReportBuilder setPortfolioContainingNonReportedComponentIndicator(Boolean _portfolioContainingNonReportedComponentIndicator) {
            this.portfolioContainingNonReportedComponentIndicator = _portfolioContainingNonReportedComponentIndicator == null ? null : _portfolioContainingNonReportedComponentIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public ASICMarginReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCodeVM")
        @RuneAttribute(value="collateralPortfolioCodeVM")
        public ASICMarginReportBuilder setCollateralPortfolioCodeVM(String _collateralPortfolioCodeVM) {
            this.collateralPortfolioCodeVM = _collateralPortfolioCodeVM == null ? null : _collateralPortfolioCodeVM;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingEntityPreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingEntityPreHaircut")
        public ASICMarginReportBuilder setInitialMarginPostedByTheReportingEntityPreHaircut(BigDecimal _initialMarginPostedByTheReportingEntityPreHaircut) {
            this.initialMarginPostedByTheReportingEntityPreHaircut = _initialMarginPostedByTheReportingEntityPreHaircut == null ? null : _initialMarginPostedByTheReportingEntityPreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingEntityPostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingEntityPostHaircut")
        public ASICMarginReportBuilder setInitialMarginPostedByTheReportingEntityPostHaircut(BigDecimal _initialMarginPostedByTheReportingEntityPostHaircut) {
            this.initialMarginPostedByTheReportingEntityPostHaircut = _initialMarginPostedByTheReportingEntityPostHaircut == null ? null : _initialMarginPostedByTheReportingEntityPostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyofInitialMarginPosted")
        @RuneAttribute(value="currencyofInitialMarginPosted")
        public ASICMarginReportBuilder setCurrencyofInitialMarginPosted(ISOCurrencyCodeEnum _currencyofInitialMarginPosted) {
            this.currencyofInitialMarginPosted = _currencyofInitialMarginPosted == null ? null : _currencyofInitialMarginPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByTheReportingEntityPreHaircut")
        @RuneAttribute(value="initialMarginCollectedByTheReportingEntityPreHaircut")
        public ASICMarginReportBuilder setInitialMarginCollectedByTheReportingEntityPreHaircut(BigDecimal _initialMarginCollectedByTheReportingEntityPreHaircut) {
            this.initialMarginCollectedByTheReportingEntityPreHaircut = _initialMarginCollectedByTheReportingEntityPreHaircut == null ? null : _initialMarginCollectedByTheReportingEntityPreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByTheReportingEntityPostHaircut")
        @RuneAttribute(value="initialMarginCollectedByTheReportingEntityPostHaircut")
        public ASICMarginReportBuilder setInitialMarginCollectedByTheReportingEntityPostHaircut(BigDecimal _initialMarginCollectedByTheReportingEntityPostHaircut) {
            this.initialMarginCollectedByTheReportingEntityPostHaircut = _initialMarginCollectedByTheReportingEntityPostHaircut == null ? null : _initialMarginCollectedByTheReportingEntityPostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyofInitialMarginCollected")
        @RuneAttribute(value="currencyofInitialMarginCollected")
        public ASICMarginReportBuilder setCurrencyofInitialMarginCollected(ISOCurrencyCodeEnum _currencyofInitialMarginCollected) {
            this.currencyofInitialMarginCollected = _currencyofInitialMarginCollected == null ? null : _currencyofInitialMarginCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheReportingEntityPreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheReportingEntityPreHaircut")
        public ASICMarginReportBuilder setVariationMarginPostedByTheReportingEntityPreHaircut(BigDecimal _variationMarginPostedByTheReportingEntityPreHaircut) {
            this.variationMarginPostedByTheReportingEntityPreHaircut = _variationMarginPostedByTheReportingEntityPreHaircut == null ? null : _variationMarginPostedByTheReportingEntityPreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginPosted")
        @RuneAttribute(value="currencyOfVariationMarginPosted")
        public ASICMarginReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum _currencyOfVariationMarginPosted) {
            this.currencyOfVariationMarginPosted = _currencyOfVariationMarginPosted == null ? null : _currencyOfVariationMarginPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheReportingEntityPreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheReportingEntityPreHaircut")
        public ASICMarginReportBuilder setVariationMarginCollectedByTheReportingEntityPreHaircut(BigDecimal _variationMarginCollectedByTheReportingEntityPreHaircut) {
            this.variationMarginCollectedByTheReportingEntityPreHaircut = _variationMarginCollectedByTheReportingEntityPreHaircut == null ? null : _variationMarginCollectedByTheReportingEntityPreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginCollected")
        @RuneAttribute(value="currencyOfVariationMarginCollected")
        public ASICMarginReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum _currencyOfVariationMarginCollected) {
            this.currencyOfVariationMarginCollected = _currencyOfVariationMarginCollected == null ? null : _currencyOfVariationMarginCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public ASICMarginReportBuilder setActionType(MarginActionEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ASICMarginReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public ASICMarginReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterpartyIdentifierType", isRequired=true)
        @RuneAttribute(value="counterpartyIdentifierType", isRequired=true)
        public ASICMarginReportBuilder setCounterpartyIdentifierType(Boolean _counterpartyIdentifierType) {
            this.counterpartyIdentifierType = _counterpartyIdentifierType == null ? null : _counterpartyIdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public ASICMarginReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty1", isRequired=true)
        @RuneAttribute(value="executionAgentOfCounterparty1", isRequired=true)
        public ASICMarginReportBuilder setExecutionAgentOfCounterparty1(String _executionAgentOfCounterparty1) {
            this.executionAgentOfCounterparty1 = _executionAgentOfCounterparty1 == null ? null : _executionAgentOfCounterparty1;
            return this;
        }

        @Override
        public ASICMarginReport build() {
            return new ASICMarginReportImpl(this);
        }

        @Override
        public ASICMarginReportBuilder toBuilder() {
            return this;
        }

        @Override
        public ASICMarginReportBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getUniqueTransactionIdentifier() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifierProprietary() != null) {
                return true;
            }
            if (this.getReportingEntity() != null) {
                return true;
            }
            if (this.getCounterparty1() != null) {
                return true;
            }
            if (this.getSmallScaleBuySideEntityIndicator() != null) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCollateralTimestamp() != null) {
                return true;
            }
            if (this.getCollateralisationCategory() != null) {
                return true;
            }
            if (this.getCollateralPortfolioIndicator() != null) {
                return true;
            }
            if (this.getPortfolioContainingNonReportedComponentIndicator() != null) {
                return true;
            }
            if (this.getInitialMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getCollateralPortfolioCodeVM() != null) {
                return true;
            }
            if (this.getInitialMarginPostedByTheReportingEntityPreHaircut() != null) {
                return true;
            }
            if (this.getInitialMarginPostedByTheReportingEntityPostHaircut() != null) {
                return true;
            }
            if (this.getCurrencyofInitialMarginPosted() != null) {
                return true;
            }
            if (this.getInitialMarginCollectedByTheReportingEntityPreHaircut() != null) {
                return true;
            }
            if (this.getInitialMarginCollectedByTheReportingEntityPostHaircut() != null) {
                return true;
            }
            if (this.getCurrencyofInitialMarginCollected() != null) {
                return true;
            }
            if (this.getVariationMarginPostedByTheReportingEntityPreHaircut() != null) {
                return true;
            }
            if (this.getCurrencyOfVariationMarginPosted() != null) {
                return true;
            }
            if (this.getVariationMarginCollectedByTheReportingEntityPreHaircut() != null) {
                return true;
            }
            if (this.getCurrencyOfVariationMarginCollected() != null) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getReportingTimestamp() != null) {
                return true;
            }
            if (this.getReportSubmittingEntityID() != null) {
                return true;
            }
            if (this.getCounterpartyIdentifierType() != null) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            return this.getExecutionAgentOfCounterparty1() != null;
        }

        public ASICMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ASICMarginReportBuilder o = (ASICMarginReportBuilder)other;
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifier(), (Object)o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifierProprietary(), (Object)o.getUniqueTransactionIdentifierProprietary(), this::setUniqueTransactionIdentifierProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingEntity(), (Object)o.getReportingEntity(), this::setReportingEntity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty1(), (Object)o.getCounterparty1(), this::setCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSmallScaleBuySideEntityIndicator(), (Object)o.getSmallScaleBuySideEntityIndicator(), this::setSmallScaleBuySideEntityIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralTimestamp(), (Object)o.getCollateralTimestamp(), this::setCollateralTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralisationCategory(), (Object)o.getCollateralisationCategory(), this::setCollateralisationCategory, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralPortfolioIndicator(), (Object)o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPortfolioContainingNonReportedComponentIndicator(), (Object)o.getPortfolioContainingNonReportedComponentIndicator(), this::setPortfolioContainingNonReportedComponentIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollateralPortfolioCode(), (Object)o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralPortfolioCodeVM(), (Object)o.getCollateralPortfolioCodeVM(), this::setCollateralPortfolioCodeVM, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginPostedByTheReportingEntityPreHaircut(), (Object)o.getInitialMarginPostedByTheReportingEntityPreHaircut(), this::setInitialMarginPostedByTheReportingEntityPreHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginPostedByTheReportingEntityPostHaircut(), (Object)o.getInitialMarginPostedByTheReportingEntityPostHaircut(), this::setInitialMarginPostedByTheReportingEntityPostHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyofInitialMarginPosted(), (Object)o.getCurrencyofInitialMarginPosted(), this::setCurrencyofInitialMarginPosted, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollectedByTheReportingEntityPreHaircut(), (Object)o.getInitialMarginCollectedByTheReportingEntityPreHaircut(), this::setInitialMarginCollectedByTheReportingEntityPreHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollectedByTheReportingEntityPostHaircut(), (Object)o.getInitialMarginCollectedByTheReportingEntityPostHaircut(), this::setInitialMarginCollectedByTheReportingEntityPostHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyofInitialMarginCollected(), (Object)o.getCurrencyofInitialMarginCollected(), this::setCurrencyofInitialMarginCollected, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginPostedByTheReportingEntityPreHaircut(), (Object)o.getVariationMarginPostedByTheReportingEntityPreHaircut(), this::setVariationMarginPostedByTheReportingEntityPreHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyOfVariationMarginPosted(), (Object)o.getCurrencyOfVariationMarginPosted(), this::setCurrencyOfVariationMarginPosted, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollectedByTheReportingEntityPreHaircut(), (Object)o.getVariationMarginCollectedByTheReportingEntityPreHaircut(), this::setVariationMarginCollectedByTheReportingEntityPreHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyOfVariationMarginCollected(), (Object)o.getCurrencyOfVariationMarginCollected(), this::setCurrencyOfVariationMarginCollected, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingTimestamp(), (Object)o.getReportingTimestamp(), this::setReportingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportSubmittingEntityID(), (Object)o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterpartyIdentifierType(), (Object)o.getCounterpartyIdentifierType(), this::setCounterpartyIdentifierType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfCounterparty1(), (Object)o.getExecutionAgentOfCounterparty1(), this::setExecutionAgentOfCounterparty1, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ASICMarginReport _that = this.getType().cast(o);
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.reportingEntity, _that.getReportingEntity())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.collateralTimestamp, _that.getCollateralTimestamp())) {
                return false;
            }
            if (!Objects.equals((Object)this.collateralisationCategory, (Object)_that.getCollateralisationCategory())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.portfolioContainingNonReportedComponentIndicator, _that.getPortfolioContainingNonReportedComponentIndicator())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioCodeVM, _that.getCollateralPortfolioCodeVM())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginPostedByTheReportingEntityPreHaircut, _that.getInitialMarginPostedByTheReportingEntityPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginPostedByTheReportingEntityPostHaircut, _that.getInitialMarginPostedByTheReportingEntityPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyofInitialMarginPosted, _that.getCurrencyofInitialMarginPosted())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollectedByTheReportingEntityPreHaircut, _that.getInitialMarginCollectedByTheReportingEntityPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollectedByTheReportingEntityPostHaircut, _that.getInitialMarginCollectedByTheReportingEntityPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyofInitialMarginCollected, _that.getCurrencyofInitialMarginCollected())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginPostedByTheReportingEntityPreHaircut, _that.getVariationMarginPostedByTheReportingEntityPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollectedByTheReportingEntityPreHaircut, _that.getVariationMarginCollectedByTheReportingEntityPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.counterpartyIdentifierType, _that.getCounterpartyIdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            return Objects.equals(this.executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.reportingEntity != null ? this.reportingEntity.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.smallScaleBuySideEntityIndicator != null ? this.smallScaleBuySideEntityIndicator.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.collateralTimestamp != null ? this.collateralTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.collateralisationCategory != null ? ((Object)((Object)this.collateralisationCategory)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.portfolioContainingNonReportedComponentIndicator != null ? this.portfolioContainingNonReportedComponentIndicator.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioCodeVM != null ? this.collateralPortfolioCodeVM.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginPostedByTheReportingEntityPreHaircut != null ? this.initialMarginPostedByTheReportingEntityPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginPostedByTheReportingEntityPostHaircut != null ? this.initialMarginPostedByTheReportingEntityPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyofInitialMarginPosted != null ? this.currencyofInitialMarginPosted.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollectedByTheReportingEntityPreHaircut != null ? this.initialMarginCollectedByTheReportingEntityPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollectedByTheReportingEntityPostHaircut != null ? this.initialMarginCollectedByTheReportingEntityPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyofInitialMarginCollected != null ? this.currencyofInitialMarginCollected.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginPostedByTheReportingEntityPreHaircut != null ? this.variationMarginPostedByTheReportingEntityPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfVariationMarginPosted != null ? this.currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollectedByTheReportingEntityPreHaircut != null ? this.variationMarginCollectedByTheReportingEntityPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfVariationMarginCollected != null ? this.currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.counterpartyIdentifierType != null ? this.counterpartyIdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfCounterparty1 != null ? this.executionAgentOfCounterparty1.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ASICMarginReportBuilder {uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", reportingEntity=" + this.reportingEntity + ", counterparty1=" + this.counterparty1 + ", smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", counterparty2=" + this.counterparty2 + ", collateralTimestamp=" + String.valueOf(this.collateralTimestamp) + ", collateralisationCategory=" + String.valueOf((Object)this.collateralisationCategory) + ", collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", portfolioContainingNonReportedComponentIndicator=" + this.portfolioContainingNonReportedComponentIndicator + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", collateralPortfolioCodeVM=" + this.collateralPortfolioCodeVM + ", initialMarginPostedByTheReportingEntityPreHaircut=" + String.valueOf(this.initialMarginPostedByTheReportingEntityPreHaircut) + ", initialMarginPostedByTheReportingEntityPostHaircut=" + String.valueOf(this.initialMarginPostedByTheReportingEntityPostHaircut) + ", currencyofInitialMarginPosted=" + String.valueOf(this.currencyofInitialMarginPosted) + ", initialMarginCollectedByTheReportingEntityPreHaircut=" + String.valueOf(this.initialMarginCollectedByTheReportingEntityPreHaircut) + ", initialMarginCollectedByTheReportingEntityPostHaircut=" + String.valueOf(this.initialMarginCollectedByTheReportingEntityPostHaircut) + ", currencyofInitialMarginCollected=" + String.valueOf(this.currencyofInitialMarginCollected) + ", variationMarginPostedByTheReportingEntityPreHaircut=" + String.valueOf(this.variationMarginPostedByTheReportingEntityPreHaircut) + ", currencyOfVariationMarginPosted=" + String.valueOf(this.currencyOfVariationMarginPosted) + ", variationMarginCollectedByTheReportingEntityPreHaircut=" + String.valueOf(this.variationMarginCollectedByTheReportingEntityPreHaircut) + ", currencyOfVariationMarginCollected=" + String.valueOf(this.currencyOfVariationMarginCollected) + ", actionType=" + String.valueOf((Object)this.actionType) + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", counterpartyIdentifierType=" + this.counterpartyIdentifierType + ", technicalRecordId=" + this.technicalRecordId + ", executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 + "}";
        }
    }

    public static interface ASICMarginReportBuilder
    extends ASICMarginReport,
    RosettaModelObjectBuilder {
        public ASICMarginReportBuilder setUniqueTransactionIdentifier(String var1);

        public ASICMarginReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        public ASICMarginReportBuilder setReportingEntity(String var1);

        public ASICMarginReportBuilder setCounterparty1(String var1);

        public ASICMarginReportBuilder setSmallScaleBuySideEntityIndicator(String var1);

        public ASICMarginReportBuilder setCounterparty2(String var1);

        public ASICMarginReportBuilder setCollateralTimestamp(ZonedDateTime var1);

        public ASICMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 var1);

        public ASICMarginReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        public ASICMarginReportBuilder setPortfolioContainingNonReportedComponentIndicator(Boolean var1);

        public ASICMarginReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        public ASICMarginReportBuilder setCollateralPortfolioCodeVM(String var1);

        public ASICMarginReportBuilder setInitialMarginPostedByTheReportingEntityPreHaircut(BigDecimal var1);

        public ASICMarginReportBuilder setInitialMarginPostedByTheReportingEntityPostHaircut(BigDecimal var1);

        public ASICMarginReportBuilder setCurrencyofInitialMarginPosted(ISOCurrencyCodeEnum var1);

        public ASICMarginReportBuilder setInitialMarginCollectedByTheReportingEntityPreHaircut(BigDecimal var1);

        public ASICMarginReportBuilder setInitialMarginCollectedByTheReportingEntityPostHaircut(BigDecimal var1);

        public ASICMarginReportBuilder setCurrencyofInitialMarginCollected(ISOCurrencyCodeEnum var1);

        public ASICMarginReportBuilder setVariationMarginPostedByTheReportingEntityPreHaircut(BigDecimal var1);

        public ASICMarginReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum var1);

        public ASICMarginReportBuilder setVariationMarginCollectedByTheReportingEntityPreHaircut(BigDecimal var1);

        public ASICMarginReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum var1);

        public ASICMarginReportBuilder setActionType(MarginActionEnum var1);

        public ASICMarginReportBuilder setReportingTimestamp(ZonedDateTime var1);

        public ASICMarginReportBuilder setReportSubmittingEntityID(String var1);

        public ASICMarginReportBuilder setCounterpartyIdentifierType(Boolean var1);

        public ASICMarginReportBuilder setTechnicalRecordId(String var1);

        public ASICMarginReportBuilder setExecutionAgentOfCounterparty1(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingEntity"), String.class, (Object)this.getReportingEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, (Object)this.getSmallScaleBuySideEntityIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, (Object)this.getCollateralisationCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("portfolioContainingNonReportedComponentIndicator"), Boolean.class, (Object)this.getPortfolioContainingNonReportedComponentIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioCodeVM"), String.class, (Object)this.getCollateralPortfolioCodeVM(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingEntityPreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheReportingEntityPreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingEntityPostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheReportingEntityPostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyofInitialMarginPosted"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyofInitialMarginPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingEntityPreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByTheReportingEntityPreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingEntityPostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByTheReportingEntityPostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyofInitialMarginCollected"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyofInitialMarginCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingEntityPreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheReportingEntityPreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfVariationMarginPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingEntityPreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheReportingEntityPreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfVariationMarginCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterpartyIdentifierType"), Boolean.class, (Object)this.getCounterpartyIdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, (Object)this.getExecutionAgentOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ASICMarginReportBuilder prune();
    }

    public static class ASICMarginReportImpl
    implements ASICMarginReport {
        private final String uniqueTransactionIdentifier;
        private final String uniqueTransactionIdentifierProprietary;
        private final String reportingEntity;
        private final String counterparty1;
        private final String smallScaleBuySideEntityIndicator;
        private final String counterparty2;
        private final ZonedDateTime collateralTimestamp;
        private final CollateralisationType3Code__1 collateralisationCategory;
        private final Boolean collateralPortfolioIndicator;
        private final Boolean portfolioContainingNonReportedComponentIndicator;
        private final String initialMarginCollateralPortfolioCode;
        private final String collateralPortfolioCodeVM;
        private final BigDecimal initialMarginPostedByTheReportingEntityPreHaircut;
        private final BigDecimal initialMarginPostedByTheReportingEntityPostHaircut;
        private final ISOCurrencyCodeEnum currencyofInitialMarginPosted;
        private final BigDecimal initialMarginCollectedByTheReportingEntityPreHaircut;
        private final BigDecimal initialMarginCollectedByTheReportingEntityPostHaircut;
        private final ISOCurrencyCodeEnum currencyofInitialMarginCollected;
        private final BigDecimal variationMarginPostedByTheReportingEntityPreHaircut;
        private final ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
        private final BigDecimal variationMarginCollectedByTheReportingEntityPreHaircut;
        private final ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
        private final MarginActionEnum actionType;
        private final ZonedDateTime reportingTimestamp;
        private final String reportSubmittingEntityID;
        private final Boolean counterpartyIdentifierType;
        private final String technicalRecordId;
        private final String executionAgentOfCounterparty1;

        protected ASICMarginReportImpl(ASICMarginReportBuilder builder) {
            this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
            this.uniqueTransactionIdentifierProprietary = builder.getUniqueTransactionIdentifierProprietary();
            this.reportingEntity = builder.getReportingEntity();
            this.counterparty1 = builder.getCounterparty1();
            this.smallScaleBuySideEntityIndicator = builder.getSmallScaleBuySideEntityIndicator();
            this.counterparty2 = builder.getCounterparty2();
            this.collateralTimestamp = builder.getCollateralTimestamp();
            this.collateralisationCategory = builder.getCollateralisationCategory();
            this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
            this.portfolioContainingNonReportedComponentIndicator = builder.getPortfolioContainingNonReportedComponentIndicator();
            this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
            this.collateralPortfolioCodeVM = builder.getCollateralPortfolioCodeVM();
            this.initialMarginPostedByTheReportingEntityPreHaircut = builder.getInitialMarginPostedByTheReportingEntityPreHaircut();
            this.initialMarginPostedByTheReportingEntityPostHaircut = builder.getInitialMarginPostedByTheReportingEntityPostHaircut();
            this.currencyofInitialMarginPosted = builder.getCurrencyofInitialMarginPosted();
            this.initialMarginCollectedByTheReportingEntityPreHaircut = builder.getInitialMarginCollectedByTheReportingEntityPreHaircut();
            this.initialMarginCollectedByTheReportingEntityPostHaircut = builder.getInitialMarginCollectedByTheReportingEntityPostHaircut();
            this.currencyofInitialMarginCollected = builder.getCurrencyofInitialMarginCollected();
            this.variationMarginPostedByTheReportingEntityPreHaircut = builder.getVariationMarginPostedByTheReportingEntityPreHaircut();
            this.currencyOfVariationMarginPosted = builder.getCurrencyOfVariationMarginPosted();
            this.variationMarginCollectedByTheReportingEntityPreHaircut = builder.getVariationMarginCollectedByTheReportingEntityPreHaircut();
            this.currencyOfVariationMarginCollected = builder.getCurrencyOfVariationMarginCollected();
            this.actionType = builder.getActionType();
            this.reportingTimestamp = builder.getReportingTimestamp();
            this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
            this.counterpartyIdentifierType = builder.getCounterpartyIdentifierType();
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.executionAgentOfCounterparty1 = builder.getExecutionAgentOfCounterparty1();
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="reportingEntity", isRequired=true)
        @RuneAttribute(value="reportingEntity", isRequired=true)
        public String getReportingEntity() {
            return this.reportingEntity;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
        @RuneAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
        public String getSmallScaleBuySideEntityIndicator() {
            return this.smallScaleBuySideEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="collateralTimestamp")
        @RuneAttribute(value="collateralTimestamp")
        public ZonedDateTime getCollateralTimestamp() {
            return this.collateralTimestamp;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public CollateralisationType3Code__1 getCollateralisationCategory() {
            return this.collateralisationCategory;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportedComponentIndicator")
        @RuneAttribute(value="portfolioContainingNonReportedComponentIndicator")
        public Boolean getPortfolioContainingNonReportedComponentIndicator() {
            return this.portfolioContainingNonReportedComponentIndicator;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCodeVM")
        @RuneAttribute(value="collateralPortfolioCodeVM")
        public String getCollateralPortfolioCodeVM() {
            return this.collateralPortfolioCodeVM;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingEntityPreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingEntityPreHaircut")
        public BigDecimal getInitialMarginPostedByTheReportingEntityPreHaircut() {
            return this.initialMarginPostedByTheReportingEntityPreHaircut;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingEntityPostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingEntityPostHaircut")
        public BigDecimal getInitialMarginPostedByTheReportingEntityPostHaircut() {
            return this.initialMarginPostedByTheReportingEntityPostHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyofInitialMarginPosted")
        @RuneAttribute(value="currencyofInitialMarginPosted")
        public ISOCurrencyCodeEnum getCurrencyofInitialMarginPosted() {
            return this.currencyofInitialMarginPosted;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByTheReportingEntityPreHaircut")
        @RuneAttribute(value="initialMarginCollectedByTheReportingEntityPreHaircut")
        public BigDecimal getInitialMarginCollectedByTheReportingEntityPreHaircut() {
            return this.initialMarginCollectedByTheReportingEntityPreHaircut;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByTheReportingEntityPostHaircut")
        @RuneAttribute(value="initialMarginCollectedByTheReportingEntityPostHaircut")
        public BigDecimal getInitialMarginCollectedByTheReportingEntityPostHaircut() {
            return this.initialMarginCollectedByTheReportingEntityPostHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyofInitialMarginCollected")
        @RuneAttribute(value="currencyofInitialMarginCollected")
        public ISOCurrencyCodeEnum getCurrencyofInitialMarginCollected() {
            return this.currencyofInitialMarginCollected;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheReportingEntityPreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheReportingEntityPreHaircut")
        public BigDecimal getVariationMarginPostedByTheReportingEntityPreHaircut() {
            return this.variationMarginPostedByTheReportingEntityPreHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginPosted")
        @RuneAttribute(value="currencyOfVariationMarginPosted")
        public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
            return this.currencyOfVariationMarginPosted;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheReportingEntityPreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheReportingEntityPreHaircut")
        public BigDecimal getVariationMarginCollectedByTheReportingEntityPreHaircut() {
            return this.variationMarginCollectedByTheReportingEntityPreHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginCollected")
        @RuneAttribute(value="currencyOfVariationMarginCollected")
        public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
            return this.currencyOfVariationMarginCollected;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public MarginActionEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="counterpartyIdentifierType", isRequired=true)
        @RuneAttribute(value="counterpartyIdentifierType", isRequired=true)
        public Boolean getCounterpartyIdentifierType() {
            return this.counterpartyIdentifierType;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty1", isRequired=true)
        @RuneAttribute(value="executionAgentOfCounterparty1", isRequired=true)
        public String getExecutionAgentOfCounterparty1() {
            return this.executionAgentOfCounterparty1;
        }

        @Override
        public ASICMarginReport build() {
            return this;
        }

        @Override
        public ASICMarginReportBuilder toBuilder() {
            ASICMarginReportBuilder builder = ASICMarginReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ASICMarginReportBuilder builder) {
            Optional.ofNullable(this.getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
            Optional.ofNullable(this.getUniqueTransactionIdentifierProprietary()).ifPresent(builder::setUniqueTransactionIdentifierProprietary);
            Optional.ofNullable(this.getReportingEntity()).ifPresent(builder::setReportingEntity);
            Optional.ofNullable(this.getCounterparty1()).ifPresent(builder::setCounterparty1);
            Optional.ofNullable(this.getSmallScaleBuySideEntityIndicator()).ifPresent(builder::setSmallScaleBuySideEntityIndicator);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2);
            Optional.ofNullable(this.getCollateralTimestamp()).ifPresent(builder::setCollateralTimestamp);
            Optional.ofNullable(this.getCollateralisationCategory()).ifPresent(builder::setCollateralisationCategory);
            Optional.ofNullable(this.getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
            Optional.ofNullable(this.getPortfolioContainingNonReportedComponentIndicator()).ifPresent(builder::setPortfolioContainingNonReportedComponentIndicator);
            Optional.ofNullable(this.getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getCollateralPortfolioCodeVM()).ifPresent(builder::setCollateralPortfolioCodeVM);
            Optional.ofNullable(this.getInitialMarginPostedByTheReportingEntityPreHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingEntityPreHaircut);
            Optional.ofNullable(this.getInitialMarginPostedByTheReportingEntityPostHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingEntityPostHaircut);
            Optional.ofNullable(this.getCurrencyofInitialMarginPosted()).ifPresent(builder::setCurrencyofInitialMarginPosted);
            Optional.ofNullable(this.getInitialMarginCollectedByTheReportingEntityPreHaircut()).ifPresent(builder::setInitialMarginCollectedByTheReportingEntityPreHaircut);
            Optional.ofNullable(this.getInitialMarginCollectedByTheReportingEntityPostHaircut()).ifPresent(builder::setInitialMarginCollectedByTheReportingEntityPostHaircut);
            Optional.ofNullable(this.getCurrencyofInitialMarginCollected()).ifPresent(builder::setCurrencyofInitialMarginCollected);
            Optional.ofNullable(this.getVariationMarginPostedByTheReportingEntityPreHaircut()).ifPresent(builder::setVariationMarginPostedByTheReportingEntityPreHaircut);
            Optional.ofNullable(this.getCurrencyOfVariationMarginPosted()).ifPresent(builder::setCurrencyOfVariationMarginPosted);
            Optional.ofNullable(this.getVariationMarginCollectedByTheReportingEntityPreHaircut()).ifPresent(builder::setVariationMarginCollectedByTheReportingEntityPreHaircut);
            Optional.ofNullable(this.getCurrencyOfVariationMarginCollected()).ifPresent(builder::setCurrencyOfVariationMarginCollected);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
            Optional.ofNullable(this.getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
            Optional.ofNullable(this.getCounterpartyIdentifierType()).ifPresent(builder::setCounterpartyIdentifierType);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
            Optional.ofNullable(this.getExecutionAgentOfCounterparty1()).ifPresent(builder::setExecutionAgentOfCounterparty1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ASICMarginReport _that = this.getType().cast(o);
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.reportingEntity, _that.getReportingEntity())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.collateralTimestamp, _that.getCollateralTimestamp())) {
                return false;
            }
            if (!Objects.equals((Object)this.collateralisationCategory, (Object)_that.getCollateralisationCategory())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.portfolioContainingNonReportedComponentIndicator, _that.getPortfolioContainingNonReportedComponentIndicator())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioCodeVM, _that.getCollateralPortfolioCodeVM())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginPostedByTheReportingEntityPreHaircut, _that.getInitialMarginPostedByTheReportingEntityPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginPostedByTheReportingEntityPostHaircut, _that.getInitialMarginPostedByTheReportingEntityPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyofInitialMarginPosted, _that.getCurrencyofInitialMarginPosted())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollectedByTheReportingEntityPreHaircut, _that.getInitialMarginCollectedByTheReportingEntityPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollectedByTheReportingEntityPostHaircut, _that.getInitialMarginCollectedByTheReportingEntityPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyofInitialMarginCollected, _that.getCurrencyofInitialMarginCollected())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginPostedByTheReportingEntityPreHaircut, _that.getVariationMarginPostedByTheReportingEntityPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollectedByTheReportingEntityPreHaircut, _that.getVariationMarginCollectedByTheReportingEntityPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.counterpartyIdentifierType, _that.getCounterpartyIdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            return Objects.equals(this.executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.reportingEntity != null ? this.reportingEntity.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.smallScaleBuySideEntityIndicator != null ? this.smallScaleBuySideEntityIndicator.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.collateralTimestamp != null ? this.collateralTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.collateralisationCategory != null ? ((Object)((Object)this.collateralisationCategory)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.portfolioContainingNonReportedComponentIndicator != null ? this.portfolioContainingNonReportedComponentIndicator.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioCodeVM != null ? this.collateralPortfolioCodeVM.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginPostedByTheReportingEntityPreHaircut != null ? this.initialMarginPostedByTheReportingEntityPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginPostedByTheReportingEntityPostHaircut != null ? this.initialMarginPostedByTheReportingEntityPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyofInitialMarginPosted != null ? this.currencyofInitialMarginPosted.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollectedByTheReportingEntityPreHaircut != null ? this.initialMarginCollectedByTheReportingEntityPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollectedByTheReportingEntityPostHaircut != null ? this.initialMarginCollectedByTheReportingEntityPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyofInitialMarginCollected != null ? this.currencyofInitialMarginCollected.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginPostedByTheReportingEntityPreHaircut != null ? this.variationMarginPostedByTheReportingEntityPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfVariationMarginPosted != null ? this.currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollectedByTheReportingEntityPreHaircut != null ? this.variationMarginCollectedByTheReportingEntityPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfVariationMarginCollected != null ? this.currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.counterpartyIdentifierType != null ? this.counterpartyIdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfCounterparty1 != null ? this.executionAgentOfCounterparty1.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ASICMarginReport {uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", reportingEntity=" + this.reportingEntity + ", counterparty1=" + this.counterparty1 + ", smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", counterparty2=" + this.counterparty2 + ", collateralTimestamp=" + String.valueOf(this.collateralTimestamp) + ", collateralisationCategory=" + String.valueOf((Object)this.collateralisationCategory) + ", collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", portfolioContainingNonReportedComponentIndicator=" + this.portfolioContainingNonReportedComponentIndicator + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", collateralPortfolioCodeVM=" + this.collateralPortfolioCodeVM + ", initialMarginPostedByTheReportingEntityPreHaircut=" + String.valueOf(this.initialMarginPostedByTheReportingEntityPreHaircut) + ", initialMarginPostedByTheReportingEntityPostHaircut=" + String.valueOf(this.initialMarginPostedByTheReportingEntityPostHaircut) + ", currencyofInitialMarginPosted=" + String.valueOf(this.currencyofInitialMarginPosted) + ", initialMarginCollectedByTheReportingEntityPreHaircut=" + String.valueOf(this.initialMarginCollectedByTheReportingEntityPreHaircut) + ", initialMarginCollectedByTheReportingEntityPostHaircut=" + String.valueOf(this.initialMarginCollectedByTheReportingEntityPostHaircut) + ", currencyofInitialMarginCollected=" + String.valueOf(this.currencyofInitialMarginCollected) + ", variationMarginPostedByTheReportingEntityPreHaircut=" + String.valueOf(this.variationMarginPostedByTheReportingEntityPreHaircut) + ", currencyOfVariationMarginPosted=" + String.valueOf(this.currencyOfVariationMarginPosted) + ", variationMarginCollectedByTheReportingEntityPreHaircut=" + String.valueOf(this.variationMarginCollectedByTheReportingEntityPreHaircut) + ", currencyOfVariationMarginCollected=" + String.valueOf(this.currencyOfVariationMarginCollected) + ", actionType=" + String.valueOf((Object)this.actionType) + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", counterpartyIdentifierType=" + this.counterpartyIdentifierType + ", technicalRecordId=" + this.technicalRecordId + ", executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 + "}";
        }
    }
}

